/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.entity.IShootable;
import mods.flammpfeil.slashblade.util.CustomDamageSource;
import mods.flammpfeil.slashblade.util.EnumSetConverter;
import mods.flammpfeil.slashblade.util.NBTHelper;
import mods.flammpfeil.slashblade.util.TargetSelector;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityAbstractSummonedSword
extends Entity
implements IProjectile,
IShootable {
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityAbstractSummonedSword.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FLAGS = EntityDataManager.func_187226_a(EntityAbstractSummonedSword.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HIT_ENTITY_ID = EntityDataManager.func_187226_a(EntityAbstractSummonedSword.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> OFFSET_YAW = EntityDataManager.func_187226_a(EntityAbstractSummonedSword.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> OFFSET_PITCH = EntityDataManager.func_187226_a(EntityAbstractSummonedSword.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Byte> PIERCE = EntityDataManager.func_187226_a(EntityAbstractSummonedSword.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<String> MODEL = EntityDataManager.func_187226_a(EntityAbstractSummonedSword.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> DELAY = EntityDataManager.func_187226_a(EntityAbstractSummonedSword.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int ticksInGround;
    private boolean inGround;
    private BlockState inBlockState;
    private int ticksInAir;
    private double damage = 1.0;
    private IntOpenHashSet alreadyHits;
    public UUID shootingEntity;
    private Entity hitEntity = null;
    private SoundEvent hitEntitySound = SoundEvents.field_203268_ij;
    private SoundEvent hitEntityPlayerSound = SoundEvents.field_203268_ij;
    private SoundEvent hitGroundSound = SoundEvents.field_203269_ik;
    EnumSet<FlagsState> flags = EnumSet.noneOf(FlagsState.class);
    int intFlags = 0;
    private static final String defaultModelName = "slashblade:model/util/ss";
    private static final ResourceLocation defaultModel = new ResourceLocation("slashblade:model/util/ss.obj");
    public LazyOptional<ResourceLocation> modelLoc = LazyOptional.of(() -> new ResourceLocation(this.getModelName() + ".obj"));
    private static final ResourceLocation defaultTexture = new ResourceLocation("slashblade:model/util/ss.png");
    public LazyOptional<ResourceLocation> textureLoc = LazyOptional.of(() -> new ResourceLocation(this.getModelName() + ".png"));

    protected SoundEvent getHitEntitySound() {
        return this.hitEntitySound;
    }

    protected SoundEvent getHitEntityPlayerSound() {
        return this.hitEntityPlayerSound;
    }

    protected SoundEvent getHitGroundSound() {
        return this.hitGroundSound;
    }

    public EntityAbstractSummonedSword(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.func_189654_d(true);
    }

    public static EntityAbstractSummonedSword createInstance(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        return new EntityAbstractSummonedSword(SlashBlade.RegistryEvents.SummonedSword, worldIn);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(COLOR, (Object)0x3333FF);
        this.field_70180_af.func_187214_a(FLAGS, (Object)0);
        this.field_70180_af.func_187214_a(HIT_ENTITY_ID, (Object)-1);
        this.field_70180_af.func_187214_a(OFFSET_YAW, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(OFFSET_PITCH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(PIERCE, (Object)0);
        this.field_70180_af.func_187214_a(MODEL, (Object)"");
        this.field_70180_af.func_187214_a(DELAY, (Object)10);
    }

    protected void func_213281_b(CompoundNBT compound) {
        NBTHelper.getNBTCoupler(compound).put("Color", this.getColor()).put("life", (short)this.ticksInGround).put("inBlockState", this.inBlockState != null ? NBTUtil.func_190009_a((BlockState)this.inBlockState) : null).put("inGround", this.inGround).put("damage", this.damage).put("crit", this.getIsCritical()).put("clip", this.isNoClip()).put("PierceLevel", this.getPierce()).put("OwnerUUID", this.shootingEntity).put("model", this.getModelName()).put("Delay", this.getDelay());
    }

    protected void func_70037_a(CompoundNBT compound) {
        NBTHelper.getNBTCoupler(compound).get("Color", this::setColor, new Integer[0]).get("life", v -> {
            this.ticksInGround = v;
        }, new Integer[0]).get("inBlockState", v -> {
            this.inBlockState = NBTUtil.func_190008_d((CompoundNBT)v);
        }, new CompoundNBT[0]).get("inGround", v -> {
            this.inGround = v;
        }, new Boolean[0]).get("damage", v -> {
            this.damage = v;
        }, this.damage).get("crit", this::setIsCritical, new Boolean[0]).get("clip", this::setNoClip, new Boolean[0]).get("PierceLevel", this::setPierce, new Byte[0]).get("OwnerUUID", v -> {
            this.shootingEntity = v;
        }, true, (T[])new UUID[0]).get("model", this::setModelName, new String[0]).get("Delay", this::setDelay, new Integer[0]);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3d vec3d = new Vec3d(x, y, z).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy).func_186678_a((double)velocity);
        this.func_213317_d(vec3d);
        float f = MathHelper.func_76133_a((double)EntityAbstractSummonedSword.func_213296_b((Vec3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.ticksInGround = 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityAbstractSummonedSword.func_184183_bd()) * d0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
            this.ticksInGround = 0;
        }
    }

    private void setFlags(FlagsState value) {
        this.flags.add(value);
        this.refreshFlags();
    }

    private void removeFlags(FlagsState value) {
        this.flags.remove((Object)value);
        this.refreshFlags();
    }

    private void refreshFlags() {
        if (this.field_70170_p.field_72995_K) {
            int newValue = (Integer)this.field_70180_af.func_187225_a(FLAGS);
            if (this.intFlags != newValue) {
                this.intFlags = newValue;
                EnumSetConverter.convertToEnumSet(this.flags, (Enum[])FlagsState.values(), (int)this.intFlags);
            }
        } else {
            int newValue = EnumSetConverter.convertToInt(this.flags);
            if (this.intFlags != newValue) {
                this.field_70180_af.func_187227_b(FLAGS, (Object)newValue);
                this.intFlags = newValue;
            }
        }
    }

    public void setIsCritical(boolean value) {
        if (value) {
            this.setFlags(FlagsState.Critical);
        } else {
            this.removeFlags(FlagsState.Critical);
        }
    }

    public boolean getIsCritical() {
        this.refreshFlags();
        return this.flags.contains((Object)FlagsState.Critical);
    }

    public void setNoClip(boolean value) {
        this.field_70145_X = value;
        if (value) {
            this.setFlags(FlagsState.NoClip);
        } else {
            this.removeFlags(FlagsState.NoClip);
        }
    }

    public boolean isNoClip() {
        if (!this.field_70170_p.field_72995_K) {
            return this.field_70145_X;
        }
        this.refreshFlags();
        return this.flags.contains((Object)FlagsState.NoClip);
    }

    public void func_70071_h_() {
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        super.func_70071_h_();
        boolean disallowedHitBlock = this.isNoClip();
        Vec3d motionVec = this.func_213322_ci();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)EntityAbstractSummonedSword.func_213296_b((Vec3d)motionVec));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)motionVec.field_72450_a, (double)motionVec.field_72449_c) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)motionVec.field_72448_b, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!((blockstate = this.field_70170_p.func_180495_p(blockpos = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()))).isAir((IBlockReader)this.field_70170_p, blockpos) || disallowedHitBlock || (voxelshape = blockstate.func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b())) {
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()))) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        if (this.inGround && !disallowedHitBlock) {
            if (this.inBlockState != blockstate && this.field_70170_p.func_226664_a_(this.func_174813_aQ().func_186662_g(0.06))) {
                this.inGround = false;
                this.func_213317_d(motionVec.func_216372_d((double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f)));
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            } else if (!this.field_70170_p.field_72995_K) {
                this.tryDespawn();
            }
        } else {
            Vec3d movedVec;
            ++this.ticksInAir;
            Vec3d positionVec = this.func_213303_ch();
            BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(positionVec, movedVec = positionVec.func_178787_e(motionVec), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
                movedVec = raytraceresult.func_216347_e();
            }
            while (this.func_70089_S()) {
                EntityRayTraceResult entityraytraceresult = this.getRayTrace(positionVec, movedVec);
                if (entityraytraceresult != null) {
                    raytraceresult = entityraytraceresult;
                }
                if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                    Entity entity1 = this.getShooter();
                    if (entity instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
                if (raytraceresult != null && !disallowedHitBlock && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                    this.onHit((RayTraceResult)raytraceresult);
                    this.field_70160_al = true;
                }
                if (entityraytraceresult == null || this.getPierce() <= 0) break;
                raytraceresult = null;
            }
            motionVec = this.func_213322_ci();
            double mx = motionVec.field_72450_a;
            double my = motionVec.field_72448_b;
            double mz = motionVec.field_72449_c;
            if (this.getIsCritical()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197614_g, this.func_226277_ct_() + mx * (double)i / 4.0, this.func_226278_cu_() + my * (double)i / 4.0, this.func_226281_cx_() + mz * (double)i / 4.0, -mx, -my + 0.2, -mz);
                }
            }
            this.func_70107_b(this.func_226277_ct_() + mx, this.func_226278_cu_() + my, this.func_226281_cx_() + mz);
            float f4 = MathHelper.func_76133_a((double)EntityAbstractSummonedSword.func_213296_b((Vec3d)motionVec));
            this.field_70177_z = disallowedHitBlock ? (float)(MathHelper.func_181159_b((double)(-mx), (double)(-mz)) * 57.2957763671875) : (float)(MathHelper.func_181159_b((double)mx, (double)mz) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)my, (double)f4) * 57.2957763671875);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
            this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
            float f1 = 0.99f;
            float f2 = 0.05f;
            if (this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    float f3 = 0.25f;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() - mx * 0.25, this.func_226278_cu_() - my * 0.25, this.func_226281_cx_() - mz * 0.25, mx, my, mz);
                }
            }
            this.func_213317_d(motionVec.func_186678_a((double)f1));
            if (!this.func_189652_ae() && !disallowedHitBlock) {
                Vec3d vec3d3 = this.func_213322_ci();
                this.func_213293_j(vec3d3.field_72450_a, vec3d3.field_72448_b - (double)0.05f, vec3d3.field_72449_c);
            }
            this.func_145775_I();
        }
        if (!this.field_70170_p.field_72995_K && this.ticksInGround <= 0 && 100 < this.field_70173_aa) {
            this.func_70106_y();
        }
    }

    protected void tryDespawn() {
        ++this.ticksInGround;
        if (1200 <= this.ticksInGround) {
            this.burst();
        }
    }

    protected void onHit(RayTraceResult raytraceResultIn) {
        RayTraceResult.Type type = raytraceResultIn.func_216346_c();
        switch (type) {
            case ENTITY: {
                this.onHitEntity((EntityRayTraceResult)raytraceResultIn);
                break;
            }
            case BLOCK: {
                this.onHitBlock((BlockRayTraceResult)raytraceResultIn);
            }
        }
    }

    protected void onHitBlock(BlockRayTraceResult blockraytraceresult) {
        BlockState blockstate;
        this.inBlockState = blockstate = this.field_70170_p.func_180495_p(blockraytraceresult.func_216350_a());
        Vec3d vec3d = blockraytraceresult.func_216347_e().func_178786_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.func_213317_d(vec3d);
        Vec3d vec3d1 = this.func_213303_ch().func_178788_d(vec3d.func_72432_b().func_186678_a((double)0.05f));
        this.func_70107_b(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c);
        this.func_184185_a(this.getHitGroundSound(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        this.inGround = true;
        this.setIsCritical(false);
        this.setPierce((byte)0);
        this.resetAlreadyHits();
        blockstate.func_215690_a(this.field_70170_p, blockstate, blockraytraceresult, (Entity)this);
    }

    protected void onHitEntity(EntityRayTraceResult p_213868_1_) {
        DamageSource damagesource;
        Entity shooter;
        Entity targetEntity = p_213868_1_.func_216348_a();
        float f = (float)this.func_213322_ci().func_72433_c();
        int i = MathHelper.func_76143_f((double)Math.max((double)f * this.damage, 0.0));
        if (this.getPierce() > 0) {
            if (this.alreadyHits == null) {
                this.alreadyHits = new IntOpenHashSet(5);
            }
            if (this.alreadyHits.size() >= this.getPierce() + 1) {
                this.burst();
                return;
            }
            this.alreadyHits.add(targetEntity.func_145782_y());
        }
        if (this.getIsCritical()) {
            i += this.field_70146_Z.nextInt(i / 2 + 2);
        }
        if ((shooter = this.getShooter()) == null) {
            damagesource = CustomDamageSource.causeSummonedSwordDamage(this, this);
        } else {
            damagesource = CustomDamageSource.causeSummonedSwordDamage(this, shooter);
            if (shooter instanceof LivingEntity) {
                ((LivingEntity)shooter).func_130011_c(targetEntity);
            }
        }
        int fireTime = targetEntity.func_223314_ad();
        if (this.func_70027_ad() && !(targetEntity instanceof EndermanEntity)) {
            targetEntity.func_70015_d(5);
        }
        if (targetEntity.func_70097_a(damagesource, (float)i)) {
            if (targetEntity instanceof LivingEntity) {
                LivingEntity targetLivingEntity = (LivingEntity)targetEntity;
                if (!this.field_70170_p.field_72995_K && this.getPierce() <= 0) {
                    this.setHitEntity(targetEntity);
                }
                if (!this.field_70170_p.field_72995_K && shooter instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)targetLivingEntity, (Entity)shooter);
                    EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)shooter), (Entity)targetLivingEntity);
                }
                this.affectEntity(targetLivingEntity, this.getPotionEffects(), 1.0);
                if (shooter != null && targetLivingEntity != shooter && targetLivingEntity instanceof PlayerEntity && shooter instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)shooter).func_213823_a(this.getHitEntityPlayerSound(), SoundCategory.PLAYERS, 0.18f, 0.45f);
                }
            }
            this.func_184185_a(this.getHitEntitySound(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            if (this.getPierce() <= 0) {
                this.burst();
            }
        } else {
            targetEntity.func_223308_g(fireTime);
            this.func_213317_d(this.func_213322_ci().func_186678_a(-0.1));
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            this.ticksInAir = 0;
            if (!this.field_70170_p.field_72995_K && this.func_213322_ci().func_189985_c() < 1.0E-7) {
                this.burst();
            }
        }
    }

    public int getColor() {
        return (Integer)this.func_184212_Q().func_187225_a(COLOR);
    }

    public void setColor(int value) {
        this.func_184212_Q().func_187227_b(COLOR, (Object)value);
    }

    public byte getPierce() {
        return (Byte)this.func_184212_Q().func_187225_a(PIERCE);
    }

    public void setPierce(byte value) {
        this.func_184212_Q().func_187227_b(PIERCE, (Object)value);
    }

    public int getDelay() {
        return (Integer)this.func_184212_Q().func_187225_a(DELAY);
    }

    public void setDelay(int value) {
        this.func_184212_Q().func_187227_b(DELAY, (Object)value);
    }

    @Nullable
    protected EntityRayTraceResult getRayTrace(Vec3d p_213866_1_, Vec3d p_213866_2_) {
        return ProjectileHelper.func_221271_a((World)this.field_70170_p, (Entity)this, (Vec3d)p_213866_1_, (Vec3d)p_213866_2_, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), p_213871_1_ -> !(p_213871_1_.func_175149_v() || !p_213871_1_.func_70089_S() || !p_213871_1_.func_70067_L() || p_213871_1_ == this.getShooter() && this.ticksInAir < 5 || this.alreadyHits != null && this.alreadyHits.contains(p_213871_1_.func_145782_y())));
    }

    @Override
    @Nullable
    public Entity getShooter() {
        return this.shootingEntity != null && this.field_70170_p instanceof ServerWorld ? ((ServerWorld)this.field_70170_p).func_217461_a(this.shootingEntity) : null;
    }

    @Override
    public void setShooter(Entity shooter) {
        this.shootingEntity = shooter != null ? shooter.func_110124_au() : null;
    }

    public List<EffectInstance> getPotionEffects() {
        List effects = PotionUtils.func_185185_a((CompoundNBT)this.getPersistentData());
        if (effects.isEmpty()) {
            effects.add(new EffectInstance(Effects.field_76436_u, 1, 1));
        }
        return effects;
    }

    public void burst() {
        this.func_184185_a(SoundEvents.field_187561_bM, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197614_g, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 16, 0.5, 0.5, 0.5, 0.25);
            }
            this.burst(this.getPotionEffects(), null);
        }
        super.func_70106_y();
    }

    public void burst(List<EffectInstance> effects, @Nullable Entity focusEntity) {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
        List<Entity> list = TargetSelector.getTargettableEntitiesWithinAABB(this.field_70170_p, 2.0, this);
        list.stream().filter(e -> e instanceof LivingEntity).map(e -> (LivingEntity)e).forEach(e -> {
            double distanceSq = this.func_70068_e((Entity)e);
            if (distanceSq < 9.0) {
                double factor = 1.0 - Math.sqrt(distanceSq) / 4.0;
                if (e == focusEntity) {
                    factor = 1.0;
                }
                this.affectEntity((LivingEntity)e, effects, factor);
            }
        });
    }

    public void affectEntity(LivingEntity focusEntity, List<EffectInstance> effects, double factor) {
        for (EffectInstance effectinstance : this.getPotionEffects()) {
            Effect effect = effectinstance.func_188419_a();
            if (effect.func_76403_b()) {
                effect.func_180793_a((Entity)this, this.getShooter(), focusEntity, effectinstance.func_76458_c(), factor);
                continue;
            }
            int duration = (int)(factor * (double)effectinstance.func_76459_b() + 0.5);
            if (duration <= 0) continue;
            focusEntity.func_195064_c(new EffectInstance(effect, duration, effectinstance.func_76458_c(), effectinstance.func_82720_e(), effectinstance.func_188418_e()));
        }
    }

    private void resetAlreadyHits() {
        if (this.alreadyHits != null) {
            this.alreadyHits.clear();
        }
    }

    public void setHitEntity(Entity hitEntity) {
        if (hitEntity != this) {
            this.field_70180_af.func_187227_b(HIT_ENTITY_ID, (Object)hitEntity.func_145782_y());
            float offsetYaw = this.field_70177_z - hitEntity.field_70177_z;
            float offsetPitch = this.field_70125_A - hitEntity.field_70125_A;
            this.field_70180_af.func_187227_b(OFFSET_YAW, (Object)Float.valueOf(offsetYaw));
            this.field_70180_af.func_187227_b(OFFSET_PITCH, (Object)Float.valueOf(offsetPitch));
        }
    }

    @Nullable
    public Entity getHitEntity() {
        int id;
        if (this.hitEntity == null && 0 <= (id = ((Integer)this.field_70180_af.func_187225_a(HIT_ENTITY_ID)).intValue())) {
            this.hitEntity = this.field_70170_p.func_73045_a(id);
        }
        return this.hitEntity;
    }

    public float getOffsetYaw() {
        return ((Float)this.field_70180_af.func_187225_a(OFFSET_YAW)).floatValue();
    }

    public float getOffsetPitch() {
        return ((Float)this.field_70180_af.func_187225_a(OFFSET_PITCH)).floatValue();
    }

    public void setDamage(double damageIn) {
        this.damage = damageIn;
    }

    @Override
    public double getDamage() {
        return this.damage;
    }

    public void setModelName(String name) {
        this.field_70180_af.func_187227_b(MODEL, (Object)Optional.ofNullable(name).orElse(defaultModelName));
    }

    public String getModelName() {
        String name = (String)this.field_70180_af.func_187225_a(MODEL);
        if (name == null || name.length() == 0) {
            name = defaultModelName;
        }
        return name;
    }

    public ResourceLocation getModelLoc() {
        return (ResourceLocation)this.modelLoc.orElse((Object)defaultModel);
    }

    public ResourceLocation getTextureLoc() {
        return (ResourceLocation)this.textureLoc.orElse((Object)defaultTexture);
    }

    static enum FlagsState {
        Critical,
        NoClip;

    }
}

