/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event;

import mods.flammpfeil.slashblade.event.AnvilCraftingRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AnvilCrafting {
    private static final ResourceLocation REFORGE = new ResourceLocation("slashblade", "tips/reforge");

    public static AnvilCrafting getInstance() {
        return SingletonHolder.instance;
    }

    private AnvilCrafting() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onAnvilUpdateEvent(AnvilUpdateEvent event) {
        ItemStack base = event.getLeft();
        ItemStack material = event.getRight();
        if (base.func_190926_b()) {
            return;
        }
        if (material.func_190926_b()) {
            return;
        }
        AnvilCraftingRecipe recipe = AnvilCraftingRecipe.getRecipe(material);
        if (recipe == null) {
            return;
        }
        if (!recipe.matches(base)) {
            return;
        }
        event.setMaterialCost(1);
        event.setCost(recipe.getLevel());
        event.setOutput(recipe.getResult(base));
    }

    @SubscribeEvent
    public void onAnvilRepairEvent(AnvilRepairEvent event) {
        if (!(event.getPlayer() instanceof ServerPlayerEntity)) {
            return;
        }
        ItemStack material = event.getIngredientInput();
        AnvilCraftingRecipe recipe = AnvilCraftingRecipe.getRecipe(material);
        if (recipe == null) {
            return;
        }
        ItemStack base = event.getItemInput();
        if (!recipe.matches(base)) {
            return;
        }
        AnvilCrafting.grantCriterion((ServerPlayerEntity)event.getPlayer(), REFORGE);
    }

    private static void grantCriterion(ServerPlayerEntity player, ResourceLocation resourcelocation) {
        Advancement adv = player.func_184102_h().func_191949_aK().func_192778_a(resourcelocation);
        if (adv == null) {
            return;
        }
        AdvancementProgress advancementprogress = player.func_192039_O().func_192747_a(adv);
        if (advancementprogress.func_192105_a()) {
            return;
        }
        for (String s : advancementprogress.func_192107_d()) {
            player.func_192039_O().func_192750_a(adv, s);
        }
    }

    private static final class SingletonHolder {
        private static final AnvilCrafting instance = new AnvilCrafting();

        private SingletonHolder() {
        }
    }
}

