/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event;

import com.google.common.collect.Maps;
import java.util.Map;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.NBTHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class AnvilCraftingRecipe {
    int level = 1;
    int killcount = 0;
    int refine = 0;
    boolean broken = false;
    boolean noScabbard = false;
    String translationKey = null;
    Map<Enchantment, Integer> Enchantments = Maps.newHashMap();
    ItemStack result = ItemStack.field_190927_a;
    CompoundNBT overwriteTag = null;

    public static AnvilCraftingRecipe getRecipe(ItemStack material) {
        if (!material.func_77942_o()) {
            return null;
        }
        CompoundNBT tag = material.func_196082_o();
        if (!tag.func_74764_b("RequiredBlade")) {
            return null;
        }
        AnvilCraftingRecipe recipe = new AnvilCraftingRecipe();
        recipe.readNBT(tag.func_74775_l("RequiredBlade"));
        recipe.setEnchantments(EnchantmentHelper.func_82781_a((ItemStack)material));
        return recipe;
    }

    public void readNBT(CompoundNBT tag) {
        NBTHelper.getNBTCoupler(tag).get("level", this::setLevel, new Integer[0]).get("killCount", this::setKillcount, new Integer[0]).get("refine", this::setRefine, new Integer[0]).get("broken", this::setBroken, new Boolean[0]).get("noScabbard", this::setNoScabbard, new Boolean[0]).get("translationKey", this::setTranslationKey, new String[0]).get("result", this::setResultWithNBT, new CompoundNBT[0]).get("overwriteTag", this::setOverwriteTag, new CompoundNBT[0]);
    }

    public INBT writeNBT() {
        CompoundNBT tag = new CompoundNBT();
        NBTHelper.getNBTCoupler(tag).put("level", this.getLevel()).put("killCount", this.getKillcount()).put("refine", this.getRefine()).put("broken", this.isBroken()).put("noScabbard", this.isNoScabbard()).put("translationKey", this.getTranslationKey()).put("result", this.getResult().func_77955_b(new CompoundNBT())).put("overwriteTag", this.getOverwriteTag());
        return tag;
    }

    public boolean matches(ItemStack base) {
        if (base.func_190926_b()) {
            return false;
        }
        if (!this.translationKey.isEmpty() && !base.func_77977_a().equals(this.translationKey)) {
            return false;
        }
        if (this.needBlade()) {
            if (!(base.func_77973_b() instanceof ItemSlashBlade)) {
                return false;
            }
            boolean stateMatches = base.getCapability(ItemSlashBlade.BLADESTATE).filter(state -> this.getKillcount() <= state.getKillCount() && this.getRefine() <= state.getRefine() && this.isNoScabbard() == state.isNoScabbard() && !((this.isBroken() ^ state.isBroken()) & this.isBroken())).isPresent();
            if (!stateMatches) {
                return false;
            }
        }
        if (!this.getEnchantments().isEmpty()) {
            for (Map.Entry<Enchantment, Integer> entry : this.getEnchantments().entrySet()) {
                if (EnchantmentHelper.func_77506_a((Enchantment)entry.getKey(), (ItemStack)base) >= entry.getValue()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean needBlade() {
        return this.getKillcount() != 0 || this.getRefine() != 0 || this.broken || this.noScabbard;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getKillcount() {
        return this.killcount;
    }

    public void setKillcount(int killcount) {
        this.killcount = killcount;
    }

    public int getRefine() {
        return this.refine;
    }

    public void setRefine(int refine) {
        this.refine = refine;
    }

    public boolean isBroken() {
        return this.broken;
    }

    public void setBroken(boolean broken) {
        this.broken = broken;
    }

    public boolean isNoScabbard() {
        return this.noScabbard;
    }

    public void setNoScabbard(boolean noScabbard) {
        this.noScabbard = noScabbard;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public void setTranslationKey(String translationKey) {
        this.translationKey = translationKey;
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return this.Enchantments;
    }

    public void setEnchantments(Map<Enchantment, Integer> enchantments) {
        this.Enchantments = enchantments;
    }

    public ItemStack getResult() {
        return this.result.func_77946_l();
    }

    public ItemStack getResult(ItemStack base) {
        ItemStack result;
        if (this.isOnlyTagOverwrite()) {
            CompoundNBT tag = base.func_77955_b(new CompoundNBT());
            tag.func_197643_a(this.getOverwriteTag().func_74737_b());
            result = ItemStack.func_199557_a((CompoundNBT)tag);
        } else {
            result = this.getResult();
            base.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(oldState -> result.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(newState -> {
                newState.setKillCount(oldState.getKillCount());
                newState.setRefine(oldState.getRefine());
            }));
            Map destMap = EnchantmentHelper.func_82781_a((ItemStack)result);
            Map srcMap = EnchantmentHelper.func_82781_a((ItemStack)base);
            for (Map.Entry srcEntry : srcMap.entrySet()) {
                Enchantment key = (Enchantment)srcEntry.getKey();
                int srcLevel = (Integer)srcEntry.getValue();
                if (destMap.containsKey(key)) {
                    int destLevel = (Integer)destMap.get(key);
                    if (destLevel >= srcLevel) continue;
                    destMap.put(key, srcLevel);
                    continue;
                }
                destMap.put(key, srcLevel);
            }
            EnchantmentHelper.func_82782_a((Map)destMap, (ItemStack)result);
        }
        result.getShareTag();
        return result;
    }

    public void setResult(ItemStack result) {
        this.result = result;
    }

    public void setResultWithNBT(CompoundNBT tag) {
        this.setResult(ItemStack.func_199557_a((CompoundNBT)tag));
    }

    public boolean isOnlyTagOverwrite() {
        return this.overwriteTag != null;
    }

    public CompoundNBT getOverwriteTag() {
        return this.overwriteTag;
    }

    public void setOverwriteTag(CompoundNBT overwriteTag) {
        this.overwriteTag = overwriteTag;
    }
}

