/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.util;

import java.util.List;
import java.util.function.Consumer;
import mods.flammpfeil.slashblade.ability.ArrowReflector;
import mods.flammpfeil.slashblade.entity.IShootable;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.TargetSelector;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;

public class AttackManager {
    public static void areaAttack(LivingEntity playerIn, Consumer<LivingEntity> beforeHit) {
        AttackManager.areaAttack(playerIn, beforeHit, 1.0f, true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void areaAttack(LivingEntity playerIn, Consumer<LivingEntity> beforeHit, float ratio, boolean forceHit, boolean resetHit, boolean mute) {
        float modifiedRatio = (1.0f + EnchantmentHelper.func_191527_a((LivingEntity)playerIn) * 0.5f) * ratio;
        AttributeModifier am = new AttributeModifier("SweepingDamageRatio", (double)modifiedRatio, AttributeModifier.Operation.MULTIPLY_BASE);
        if (!playerIn.field_70170_p.func_201670_d()) {
            try {
                playerIn.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(am);
                List<Entity> founds = TargetSelector.getTargettableEntitiesWithinAABB(playerIn.field_70170_p, TargetSelector.getResolvedReach(playerIn), playerIn);
                for (Entity entity : founds) {
                    if (entity instanceof LivingEntity) {
                        beforeHit.accept((LivingEntity)entity);
                    }
                    AttackManager.doMeleeAttack(playerIn, entity, forceHit, resetHit);
                }
            }
            finally {
                playerIn.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(am);
            }
        }
        if (!mute) {
            playerIn.field_70170_p.func_184148_a((PlayerEntity)null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187730_dW, SoundCategory.PLAYERS, 0.5f, 0.4f / (playerIn.func_70681_au().nextFloat() * 0.4f + 0.8f));
        }
    }

    public static <E extends Entity> void areaAttack(E owner, Consumer<LivingEntity> beforeHit, double reach, boolean forceHit, boolean resetHit) {
        AxisAlignedBB bb = owner.func_174813_aQ();
        if (!owner.field_70170_p.func_201670_d()) {
            List<Entity> founds = TargetSelector.getTargettableEntitiesWithinAABB(owner.field_70170_p, reach, owner);
            for (Entity entity : founds) {
                if (entity instanceof LivingEntity) {
                    beforeHit.accept((LivingEntity)entity);
                }
                float baseAmount = (float)((IShootable)owner).getDamage();
                AttackManager.doAttackWith(DamageSource.func_76354_b(owner, (Entity)((IShootable)owner).getShooter()), baseAmount, entity, forceHit, resetHit);
            }
        }
    }

    public static void doManagedAttack(Consumer<Entity> attack, Entity target, boolean forceHit, boolean resetHit) {
        if (forceHit) {
            target.field_70172_ad = 0;
        }
        attack.accept(target);
        if (resetHit) {
            target.field_70172_ad = 0;
        }
    }

    public static void doAttackWith(DamageSource src, float amount, Entity target, boolean forceHit, boolean resetHit) {
        AttackManager.doManagedAttack(t -> t.func_70097_a(src, amount), target, forceHit, resetHit);
    }

    public static void doMeleeAttack(LivingEntity attacker, Entity target, boolean forceHit, boolean resetHit) {
        if (attacker instanceof PlayerEntity) {
            AttackManager.doManagedAttack(t -> attacker.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                state.setOnClick(true);
                ((PlayerEntity)attacker).func_71059_n(t);
                state.setOnClick(false);
            }), target, forceHit, resetHit);
        } else {
            float baseAmount = (float)attacker.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            AttackManager.doAttackWith(DamageSource.func_76358_a((LivingEntity)attacker), baseAmount, target, forceHit, resetHit);
        }
        ArrowReflector.doReflect(target, (Entity)attacker);
    }
}

