/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.util;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.Vec3d;

public class NBTHelper {
    public static Vec3d getVec3d(CompoundNBT tag, String key) {
        ListNBT listnbt = tag.func_150295_c(key, 6);
        return new Vec3d(listnbt.func_150309_d(0), listnbt.func_150309_d(1), listnbt.func_150309_d(2));
    }

    public static void putVec3d(CompoundNBT tag, String key, Vec3d value) {
        tag.func_218657_a(key, (INBT)NBTHelper.newDoubleNBTList(value.field_72450_a, value.field_72448_b, value.field_72449_c));
    }

    public static ListNBT newDoubleNBTList(Vec3d value) {
        return NBTHelper.newDoubleNBTList(value.field_72450_a, value.field_72448_b, value.field_72449_c);
    }

    public static ListNBT newDoubleNBTList(double ... numbers) {
        ListNBT listnbt = new ListNBT();
        for (double dValue : numbers) {
            listnbt.add((Object)DoubleNBT.func_229684_a_((double)dValue));
        }
        return listnbt;
    }

    public static NBTCoupler getNBTCoupler(CompoundNBT tag) {
        return new NBTCoupler(tag);
    }

    public static <T> void writeNBT(CompoundNBT dest, String key, T ... value) {
        if (value == null || value.length != 1 || value[0] == null) {
            return;
        }
        Class<?> type = value.getClass().getComponentType();
        if (type.equals(Integer.class)) {
            dest.func_74768_a(key, ((Integer)value[0]).intValue());
        } else if (type.equals(Float.class)) {
            dest.func_74776_a(key, ((Float)value[0]).floatValue());
        } else if (type.equals(Short.class)) {
            dest.func_74777_a(key, ((Short)value[0]).shortValue());
        } else if (type.equals(Byte.class)) {
            dest.func_74774_a(key, ((Byte)value[0]).byteValue());
        } else if (type.equals(Long.class)) {
            dest.func_74772_a(key, ((Long)value[0]).longValue());
        } else if (type.equals(Double.class)) {
            dest.func_74780_a(key, ((Double)value[0]).doubleValue());
        } else if (type.equals(Boolean.class)) {
            dest.func_74757_a(key, ((Boolean)value[0]).booleanValue());
        } else if (value[0] != null) {
            if (type.equals(UUID.class)) {
                dest.func_186854_a(key, (UUID)value[0]);
            } else if (type.equals(byte[].class)) {
                dest.func_74773_a(key, (byte[])value[0]);
            } else if (type.equals(int[].class)) {
                dest.func_74783_a(key, (int[])value[0]);
            } else if (type.equals(long[].class)) {
                dest.func_197644_a(key, (long[])value[0]);
            } else if (type.equals(CompoundNBT.class)) {
                dest.func_218657_a(key, (INBT)((CompoundNBT)value[0]));
            } else if (type.equals(String.class)) {
                dest.func_74778_a(key, (String)value[0]);
            } else if (type.equals(Vec3d.class)) {
                NBTHelper.putVec3d(dest, key, (Vec3d)value[0]);
            }
        }
    }

    public static <T> void readNBT(CompoundNBT src, String key, Consumer<T> dest, T ... values) {
        NBTHelper.readNBT(src, key, dest, false, values);
    }

    public static <T> void readNBT(CompoundNBT src, String key, Consumer<T> dest, boolean isNullable, T ... defaultValue) {
        if (isNullable) {
            dest.accept(NBTHelper.castValue(key, src, defaultValue).orElse(null));
        } else {
            NBTHelper.castValue(key, src, defaultValue).ifPresent(dest);
        }
    }

    public static <T> Optional<T> castValue(String key, CompoundNBT src, T ... defaultValue) {
        if (defaultValue == null) {
            return Optional.empty();
        }
        Class<?> type = defaultValue.getClass().getComponentType();
        Object result = null;
        int typeId = -1;
        if (type.equals(Integer.class)) {
            typeId = 99;
            result = src.func_74762_e(key);
        } else if (type.equals(Float.class)) {
            typeId = 99;
            result = Float.valueOf(src.func_74760_g(key));
        } else if (type.equals(Short.class)) {
            typeId = 99;
            result = src.func_74765_d(key);
        } else if (type.equals(Byte.class)) {
            typeId = 99;
            result = src.func_74771_c(key);
        } else if (type.equals(Long.class)) {
            typeId = 99;
            result = src.func_74763_f(key);
        } else if (type.equals(Double.class)) {
            typeId = 99;
            result = src.func_74769_h(key);
        } else if (type.equals(Boolean.class)) {
            typeId = 99;
            result = src.func_74767_n(key);
        } else if (src.func_74764_b(key)) {
            if (type.equals(UUID.class)) {
                typeId = -2;
                if (src.func_186855_b(key)) {
                    result = src.func_186857_a(key);
                }
            } else if (type.equals(byte[].class)) {
                typeId = 7;
                result = src.func_74770_j(key);
            } else if (type.equals(int[].class)) {
                typeId = 11;
                result = src.func_74759_k(key);
            } else if (type.equals(long[].class)) {
                typeId = 12;
                result = src.func_197645_o(key);
            } else if (type.equals(CompoundNBT.class)) {
                typeId = 10;
                result = src.func_74775_l(key);
            } else if (type.equals(String.class)) {
                typeId = 8;
                result = src.func_74779_i(key);
            }
        } else if (type.equals(Vec3d.class)) {
            typeId = 6;
            result = NBTHelper.getVec3d(src, key);
        }
        if (0 < defaultValue.length) {
            boolean exists;
            boolean bl = exists = typeId == -2 ? src.func_186855_b(key) : src.func_150297_b(key, typeId);
            if (!exists) {
                result = defaultValue;
            }
        }
        return Optional.ofNullable(result);
    }

    public static class NBTCoupler {
        CompoundNBT instance;
        NBTCoupler parent = null;

        protected NBTCoupler(CompoundNBT tag) {
            this.instance = tag;
        }

        public <T> NBTCoupler put(String key, T ... value) {
            NBTHelper.writeNBT(this.instance, key, value);
            return this;
        }

        public <T> NBTCoupler get(String key, Consumer<T> dest, T ... values) {
            return this.get(key, dest, false, values);
        }

        public <T> NBTCoupler get(String key, Consumer<T> dest, boolean isNullable, T ... values) {
            NBTHelper.readNBT(this.instance, key, dest, isNullable, values);
            return this;
        }

        public NBTCoupler remove(String key) {
            if (this.instance.func_186855_b(key)) {
                this.instance.func_82580_o(key + "Most");
                this.instance.func_82580_o(key + "Least");
            } else {
                this.instance.func_82580_o(key);
            }
            return this;
        }

        public NBTCoupler getChild(String key) {
            CompoundNBT tag;
            if (this.instance.func_150297_b(key, 10)) {
                tag = this.instance.func_74775_l(key);
            } else {
                tag = new CompoundNBT();
                this.instance.func_218657_a(key, (INBT)tag);
            }
            return NBTHelper.getNBTCoupler(tag);
        }

        public NBTCoupler getParent() {
            if (this.parent != null) {
                return this.parent;
            }
            return this;
        }

        public CompoundNBT getRawCompound() {
            return this.instance;
        }

        public CompoundNBT getRawCompound(String key) {
            if (this.instance.func_150297_b(key, 10)) {
                return this.instance.func_74775_l(key);
            }
            return new CompoundNBT();
        }

        public NBTCoupler doRawCompound(String key, Consumer<CompoundNBT> action) {
            if (this.instance.func_150297_b(key, 10)) {
                action.accept(this.instance.func_74775_l(key));
            }
            return this;
        }
    }
}

