/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.entity.IShootable;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.ImputCommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TargetSelector {
    public static final EntityPredicate lockon = new EntityPredicate().func_221013_a(12.0).func_221012_a((Predicate)new AttackablePredicate());
    public static final EntityPredicate lockon_focus = new EntityPredicate().func_221013_a(12.0);
    static final String AttackableTag = "RevengeAttacker";
    public static final EntityPredicate areaAttack = new EntityPredicate(){

        public boolean func_221015_a(@Nullable LivingEntity attacker, LivingEntity target) {
            if (target.func_70643_av() == attacker) {
                target.func_184211_a(TargetSelector.AttackableTag);
            }
            return super.func_221015_a(attacker, target);
        }
    }.func_221013_a(12.0).func_221010_e().func_221012_a((Predicate)new AttackablePredicate());

    public static EntityPredicate getAreaAttackPredicate(double reach) {
        return areaAttack.func_221013_a(reach);
    }

    public static List<Entity> getReflectableEntitiesWithinAABB(World world, double reach, LivingEntity attacker) {
        AxisAlignedBB aabb = TargetSelector.getResolvedAxisAligned(attacker, attacker.func_70040_Z(), reach);
        return Stream.of(world.func_217357_a(ThrowableEntity.class, aabb).stream().filter(e -> e.func_85052_h() == null || e.func_85052_h() != attacker), world.func_217357_a(DamagingProjectileEntity.class, aabb).stream().filter(e -> e.field_70235_a == null || e.field_70235_a != attacker), world.func_217357_a(AbstractArrowEntity.class, aabb).stream().filter(e -> e.func_212360_k() == null || e.func_212360_k() != attacker)).flatMap(s -> s).filter(e -> e.func_70068_e((Entity)attacker) < reach * reach).collect(Collectors.toList());
    }

    public static List<Entity> getTargettableEntitiesWithinAABB(World world, double reach, LivingEntity attacker) {
        ArrayList list1 = Lists.newArrayList();
        AxisAlignedBB aabb = TargetSelector.getResolvedAxisAligned(attacker, attacker.func_70040_Z(), reach);
        list1.addAll(world.func_217357_a(EnderDragonEntity.class, aabb.func_186662_g(5.0)).stream().flatMap(d -> Arrays.stream(d.func_213404_dT())).filter(e -> e.func_70068_e((Entity)attacker) < reach * reach).collect(Collectors.toList()));
        list1.addAll(TargetSelector.getReflectableEntitiesWithinAABB(world, reach, attacker));
        EntityPredicate predicate = TargetSelector.getAreaAttackPredicate(reach);
        list1.addAll(world.func_175647_a(LivingEntity.class, aabb, (Predicate)null).stream().filter(t -> predicate.func_221015_a(attacker, t)).collect(Collectors.toList()));
        return list1;
    }

    public static <E extends Entity> List<Entity> getTargettableEntitiesWithinAABB(World world, double reach, E owner) {
        AxisAlignedBB aabb = owner.func_174813_aQ().func_186662_g(reach);
        ArrayList list1 = Lists.newArrayList();
        list1.addAll(world.func_217357_a(EnderDragonEntity.class, aabb.func_186662_g(5.0)).stream().flatMap(d -> Arrays.stream(d.func_213404_dT())).filter(e -> e.func_70068_e(owner) < reach * reach).collect(Collectors.toList()));
        LivingEntity user = ((IShootable)owner).getShooter() instanceof LivingEntity ? (LivingEntity)((IShootable)owner).getShooter() : null;
        list1.addAll(TargetSelector.getReflectableEntitiesWithinAABB(world, reach, owner));
        EntityPredicate predicate = TargetSelector.getAreaAttackPredicate(0.0);
        list1.addAll(world.func_175647_a(LivingEntity.class, aabb, (Predicate)null).stream().filter(t -> predicate.func_221015_a(user, t)).collect(Collectors.toList()));
        return list1;
    }

    public static <E extends Entity> List<Entity> getReflectableEntitiesWithinAABB(World world, double reach, E owner) {
        AxisAlignedBB aabb = owner.func_174813_aQ().func_186662_g(reach);
        return Stream.of(world.func_217357_a(ThrowableEntity.class, aabb).stream().filter(e -> e.func_85052_h() == null || e.func_85052_h() != ((IShootable)owner).getShooter()), world.func_217357_a(DamagingProjectileEntity.class, aabb).stream().filter(e -> e.field_70235_a == null || e.field_70235_a != ((IShootable)owner).getShooter()), world.func_217357_a(AbstractArrowEntity.class, aabb).stream().filter(e -> e.func_212360_k() == null || e.func_212360_k() != ((IShootable)owner).getShooter())).flatMap(s -> s).filter(e -> e.func_70068_e(owner) < reach * reach && e != owner).collect(Collectors.toList());
    }

    public static AxisAlignedBB getResolvedAxisAligned(LivingEntity user, Vec3d dir, double reach) {
        double padding = 1.0;
        AxisAlignedBB bb = user.func_174813_aQ();
        bb = dir == Vec3d.field_186680_a ? bb.func_186662_g(reach * 2.0) : bb.func_191194_a(dir.func_186678_a(reach * 0.5)).func_186662_g(reach);
        bb = bb.func_186662_g(1.0);
        return bb;
    }

    public static double getResolvedReach(LivingEntity user) {
        double reach = 4.0;
        IAttributeInstance attrib = user.func_110148_a(PlayerEntity.REACH_DISTANCE);
        if (attrib != null) {
            reach = attrib.func_111126_e() - 1.0;
        }
        return reach;
    }

    public static void onImputChange(EnumSet<ImputCommand> old, EnumSet<ImputCommand> current, ServerPlayerEntity sender) {
        if (old.contains((Object)ImputCommand.M_DOWN) || !current.contains((Object)ImputCommand.M_DOWN) || !current.contains((Object)ImputCommand.SNEAK)) {
            return;
        }
        ItemStack stack = sender.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemSlashBlade)) {
            return;
        }
        stack.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(s -> {
            Entity tmp = s.getTargetEntity(sender.field_70170_p);
            if (tmp == null) {
                return;
            }
            if (!(tmp instanceof LivingEntity)) {
                return;
            }
            LivingEntity target = (LivingEntity)tmp;
            target.func_70604_c((LivingEntity)sender);
            if (target.field_70170_p instanceof ServerWorld) {
                ServerWorld sw = (ServerWorld)target.field_70170_p;
                sw.func_195600_a(sender, (IParticleData)ParticleTypes.field_197609_b, false, target.func_226277_ct_(), target.func_226278_cu_() + (double)target.func_70047_e(), target.func_226281_cx_(), 5, (double)target.func_213311_cf() * 1.5, (double)target.func_213302_cg(), (double)target.func_213311_cf() * 1.5, 0.02);
            }
        });
    }

    public static class AttackablePredicate
    implements Predicate<LivingEntity> {
        @Override
        public boolean test(LivingEntity livingentity) {
            if (livingentity instanceof ArmorStandEntity) {
                return ((ArmorStandEntity)livingentity).func_181026_s();
            }
            if (livingentity instanceof IMob) {
                return true;
            }
            if (livingentity.func_225510_bt_()) {
                return true;
            }
            if (livingentity instanceof WolfEntity && ((WolfEntity)livingentity).func_70919_bu()) {
                return true;
            }
            if (livingentity.func_184216_O().contains(TargetSelector.AttackableTag)) {
                livingentity.func_184197_b(TargetSelector.AttackableTag);
                return true;
            }
            return livingentity.func_96124_cp() != null;
        }
    }
}

