/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api.weaponproperty;

import com.oblivioussp.spartanweaponry.api.SpartanWeaponryAPI;
import com.oblivioussp.spartanweaponry.api.ToolMaterialEx;
import com.oblivioussp.spartanweaponry.api.weaponproperty.WeaponPropertyWithCallback;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class WeaponPropertyExtraDamage
extends WeaponPropertyWithCallback {
    public WeaponPropertyExtraDamage(String propType, String propModId, float propMagnitude) {
        super(propType, propModId, propMagnitude);
    }

    @Override
    protected void addTooltipDescription(ItemStack stack, List<String> tooltip) {
        tooltip.add(TextFormatting.ITALIC + "  " + SpartanWeaponryAPI.internalHandler.translateFormattedString(this.type + ".desc", "tooltip", this.modId, MathHelper.func_76141_d((float)((this.magnitude - 1.0f) * 100.0f))));
    }

    @Override
    public float modifyDamageDealt(ToolMaterialEx material, float baseDamage, float initialDamage, DamageSource source, EntityLivingBase attacker, EntityLivingBase victim) {
        if (attacker == null || victim == null) {
            return baseDamage;
        }
        float bonusDamage = (this.getMagnitude() - 1.0f) * initialDamage;
        switch (this.type) {
            case "extra_damage_chest": {
                return victim.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() ? baseDamage + bonusDamage : baseDamage;
            }
            case "extra_damage_unarmoured": {
                if (victim.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && victim.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() && victim.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b() && victim.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b()) {
                    return baseDamage + bonusDamage;
                }
                return baseDamage;
            }
            case "extra_damage_riding": {
                return attacker.func_184218_aH() ? baseDamage + bonusDamage : baseDamage;
            }
            case "extra_damage_undead": {
                return victim.func_70668_bt() == EnumCreatureAttribute.UNDEAD ? baseDamage + bonusDamage : baseDamage;
            }
        }
        return baseDamage;
    }
}

