/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.entity.projectile;

import com.oblivioussp.spartanweaponry.entity.projectile.EntityThrownWeapon;
import com.oblivioussp.spartanweaponry.init.SoundRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityBoomerang
extends EntityThrownWeapon {
    protected final String NBT_RETURN_POS = "returnPos";
    protected final String NBT_X = "x";
    protected final String NBT_Y = "y";
    protected final String NBT_Z = "z";
    protected final String NBT_IS_RETURNING = "isReturning";
    protected final String NBT_MAX_DISTANCE = "maxDistance";
    protected final double MAX_VELOCITY = 1.0;
    protected final double VELOCITY_PER_TICK = 0.06;
    public static final double MAX_DISTANCE_LIMIT = 12.0;
    protected final double DEFAULT_DISTANCE = 12.0;
    protected Vec3d returnPos = null;
    protected boolean isReturning = false;
    protected double maxDistance = 12.0;
    protected int ticksUntilSound = 0;
    protected final int TICKS_PER_SOUND = 5;

    public EntityBoomerang(World world) {
        super(world);
        this.func_189654_d(true);
    }

    public EntityBoomerang(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.func_189654_d(true);
    }

    public EntityBoomerang(World world, EntityLivingBase shooter) {
        super(world, shooter);
        this.func_189654_d(true);
        this.maxDistance = 12.0;
        this.returnPos = new Vec3d(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() * 0.9 - 0.1, shooter.field_70161_v);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.returnPos != null) {
            NBTTagCompound returnPosTag = new NBTTagCompound();
            returnPosTag.func_74780_a("x", this.returnPos.field_72450_a);
            returnPosTag.func_74780_a("y", this.returnPos.field_72448_b);
            returnPosTag.func_74780_a("z", this.returnPos.field_72449_c);
            compound.func_74782_a("returnPos", (NBTBase)returnPosTag);
            compound.func_74780_a("maxDistance", this.maxDistance);
        } else {
            compound.func_82580_o("returnPos");
        }
        compound.func_74757_a("isReturning", this.isReturning);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("returnPos")) {
            NBTTagCompound returnPosTag = compound.func_74775_l("returnPos");
            if (returnPosTag != null && !returnPosTag.func_82582_d()) {
                double x = returnPosTag.func_74769_h("x");
                double y = returnPosTag.func_74769_h("y");
                double z = returnPosTag.func_74769_h("z");
                this.returnPos = new Vec3d(x, y, z);
            } else {
                this.returnPos = null;
            }
            this.maxDistance = compound.func_74769_h("maxDistance");
        } else {
            this.returnPos = null;
        }
        this.isReturning = compound.func_74767_n("isReturning");
    }

    public int getTicksInAir() {
        return this.field_70257_an;
    }

    public void setMaxDistance(double distance) {
        this.maxDistance = distance;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70254_i) {
            return;
        }
        if (this.field_70250_c != null) {
            this.returnPos = new Vec3d(this.field_70250_c.field_70165_t, this.field_70250_c.field_70163_u + (double)this.field_70250_c.func_70047_e() * 0.9 - 0.1, this.field_70250_c.field_70161_v);
        }
        double distance = -1.0;
        if (this.returnPos != null) {
            distance = this.returnPos.func_72438_d(this.func_174791_d());
        }
        if (this.func_189652_ae()) {
            if (distance < 1.0 && this.isReturning || this.field_70171_ac || this.returnPos == null) {
                this.func_189654_d(false);
            }
            if (distance > this.maxDistance && !this.isReturning) {
                this.isReturning = true;
            }
            if (this.isReturning && this.returnPos != null) {
                double dX = this.field_70165_t - this.returnPos.field_72450_a;
                double dY = this.field_70163_u - this.returnPos.field_72448_b;
                double dZ = this.field_70161_v - this.returnPos.field_72449_c;
                double d = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
                this.field_70159_w -= this.VELOCITY_PER_TICK * (dX /= d);
                this.field_70181_x -= this.VELOCITY_PER_TICK * (dY /= d);
                this.field_70179_y -= this.VELOCITY_PER_TICK * (dZ /= d);
                if (d < 5.0) {
                    this.field_70159_w = -dX;
                    this.field_70181_x = -dY;
                    this.field_70179_y = -dZ;
                }
            }
            --this.ticksUntilSound;
            if (this.ticksUntilSound <= 0) {
                this.ticksUntilSound = 5;
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundRegistry.BOOMERANG_FLIGHT, SoundCategory.NEUTRAL, 2.0f, 0.5f);
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 60) {
            if (this.field_70251_a == EntityArrow.PickupStatus.ALLOWED) {
                this.func_70099_a(this.func_184550_j(), 0.1f);
            }
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K && !this.field_70254_i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT_MAGIC, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void func_184548_a(EntityLivingBase entity) {
        this.isReturning = true;
    }

    @Override
    protected void func_184549_a(RayTraceResult rayTrace) {
        if (rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.isReturning = true;
            BlockPos pos = rayTrace.func_178782_a();
            IBlockState iblockstate = this.field_70170_p.func_180495_p(pos);
            Block block = iblockstate.func_177230_c();
            this.field_70159_w *= -0.9;
            this.field_70181_x *= -0.9;
            this.field_70179_y *= -0.9;
            this.func_184185_a(SoundEvents.field_187724_dU, 1.0f, 2.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                block.func_180634_a(this.field_70170_p, pos, iblockstate, (Entity)this);
            }
        } else {
            super.func_184549_a(rayTrace);
        }
    }

    @Override
    protected boolean canBeCaughtInMidair(Entity shooter, Entity entityHit) {
        return shooter.func_70028_i(entityHit);
    }
}

