/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.entity.projectile;

import com.oblivioussp.spartanweaponry.api.IWeaponPropertyContainer;
import com.oblivioussp.spartanweaponry.api.ToolMaterialEx;
import com.oblivioussp.spartanweaponry.api.weaponproperty.IPropertyCallback;
import com.oblivioussp.spartanweaponry.api.weaponproperty.WeaponProperty;
import com.oblivioussp.spartanweaponry.init.SoundRegistry;
import com.oblivioussp.spartanweaponry.util.DamageSourcesSW;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.common.registry.IThrowableEntity;

public class EntityThrownWeapon
extends EntityArrow
implements IThrowableEntity,
IEntityAdditionalSpawnData {
    public static final String NBT_WEAPON = "weapon";
    protected ItemStack weapon = ItemStack.field_190927_a;
    protected int field_70256_ap = 0;
    protected int field_70257_an = 0;

    public EntityThrownWeapon(World world) {
        super(world);
    }

    public EntityThrownWeapon(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityThrownWeapon(World world, EntityLivingBase shooter) {
        super(world, shooter);
    }

    public void setWeapon(ItemStack weaponStack) {
        this.weapon = weaponStack.func_77946_l();
    }

    protected ItemStack func_184550_j() {
        return this.weapon;
    }

    public ItemStack getWeaponStack() {
        return this.func_184550_j();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagCompound weaponTag = new NBTTagCompound();
        if (!this.weapon.func_190926_b()) {
            this.weapon.func_77955_b(weaponTag);
        }
        compound.func_74782_a(NBT_WEAPON, (NBTBase)weaponTag);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        NBTTagCompound weaponTag = compound.func_74775_l(NBT_WEAPON);
        ItemStack weaponStack = new ItemStack(weaponTag);
        if (!weaponStack.func_190926_b()) {
            this.setWeapon(weaponStack);
        }
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        Entity entity = raytraceResultIn.field_72308_g;
        if (entity != null) {
            float i = MathHelper.func_76143_f((double)this.func_70242_d());
            if (this.func_70241_g()) {
                i += (float)this.field_70146_Z.nextInt((int)i / 2 + 2);
            }
            if (this.field_70250_c != null && this.canBeCaughtInMidair(this.field_70250_c, entity) && entity instanceof EntityPlayer && this.attemptCatch((EntityPlayer)entity)) {
                return;
            }
            DamageSource damagesource = this.field_70250_c == null ? DamageSourcesSW.causeThrownWeaponMobDamage((Entity)this, (Entity)this) : (this.field_70250_c instanceof EntityPlayer ? DamageSourcesSW.causeThrownWeaponPlayerDamage((Entity)this, (EntityPlayer)this.field_70250_c) : DamageSourcesSW.causeThrownWeaponMobDamage((Entity)this, this.field_70250_c));
            if (this.weapon.func_77973_b() instanceof IWeaponPropertyContainer && entity instanceof EntityLivingBase && this.field_70250_c instanceof EntityLivingBase && !entity.func_70028_i(this.field_70250_c)) {
                IPropertyCallback callback;
                IWeaponPropertyContainer container = (IWeaponPropertyContainer)this.weapon.func_77973_b();
                ToolMaterialEx materialEx = container.getMaterialEx();
                List<WeaponProperty> properties = container.getAllWeaponProperties();
                for (WeaponProperty prop : properties) {
                    callback = prop.getCallback();
                    if (callback == null) continue;
                    i = callback.modifyDamageDealt(materialEx, i, damagesource, (EntityLivingBase)this.field_70250_c, (EntityLivingBase)entity);
                    callback.onHitEntity(container.getMaterialEx(), this.weapon, (EntityLivingBase)entity, (EntityLivingBase)this.field_70250_c, (Entity)this);
                }
                for (WeaponProperty prop : materialEx.getAllWeaponProperties()) {
                    callback = prop.getCallback();
                    if (callback == null) continue;
                    i = callback.modifyDamageDealt(materialEx, i, damagesource, (EntityLivingBase)this.field_70250_c, (EntityLivingBase)entity);
                    callback.onHitEntity(materialEx, this.weapon, (EntityLivingBase)entity, (EntityLivingBase)this.field_70250_c, (Entity)this);
                }
            }
            if (this.func_70027_ad() && !(entity instanceof EntityEnderman)) {
                entity.func_70015_d(5);
            }
            if (entity.func_70097_a(damagesource, i)) {
                if (this.weapon.func_96631_a(1, this.field_70146_Z, null)) {
                    this.func_184185_a(SoundEvents.field_187635_cQ, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                    this.func_70106_y();
                }
                if (entity instanceof EntityLivingBase) {
                    float f1;
                    EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                    if (this.field_70256_ap > 0 && (f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                        entitylivingbase.func_70024_g(this.field_70159_w * (double)this.field_70256_ap * (double)0.6f / (double)f1, 0.1, this.field_70179_y * (double)this.field_70256_ap * (double)0.6f / (double)f1);
                    }
                    if (this.field_70250_c instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)entitylivingbase, (Entity)this.field_70250_c);
                        EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.field_70250_c), (Entity)entitylivingbase);
                    }
                    this.func_184548_a(entitylivingbase);
                    if (this.field_70250_c != null && entitylivingbase != this.field_70250_c && entitylivingbase instanceof EntityPlayer && this.field_70250_c instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)this.field_70250_c).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                    }
                }
                this.func_184185_a(SoundRegistry.THROWING_WEAPON_HIT, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                if (!(entity instanceof EntityEnderman)) {
                    this.field_70159_w *= -0.1;
                    this.field_70181_x *= -0.1;
                    this.field_70179_y *= -0.1;
                    this.field_70177_z += 180.0f;
                    this.field_70126_B += 180.0f;
                }
            } else {
                this.field_70159_w *= (double)-0.1f;
                this.field_70181_x *= (double)-0.1f;
                this.field_70179_y *= (double)-0.1f;
                this.field_70177_z += 180.0f;
                this.field_70126_B += 180.0f;
                this.field_70257_an = 0;
                if (!this.field_70170_p.field_72995_K && this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y < (double)0.001f) {
                    if (this.field_70251_a == EntityArrow.PickupStatus.ALLOWED) {
                        this.func_70099_a(this.func_184550_j(), 0.1f);
                    }
                    this.func_70106_y();
                }
            }
        } else {
            super.func_184549_a(raytraceResultIn);
        }
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        if (this.field_70254_i) {
            this.attemptCatch(entityIn);
        }
    }

    protected boolean attemptCatch(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && this.field_70249_b <= 0) {
            boolean pickUpAsNewItem;
            boolean flag;
            boolean bl = flag = this.field_70251_a == EntityArrow.PickupStatus.ALLOWED || this.field_70251_a == EntityArrow.PickupStatus.CREATIVE_ONLY && player.field_71075_bZ.field_75098_d;
            if (this.field_70251_a == EntityArrow.PickupStatus.ALLOWED && (pickUpAsNewItem = true)) {
                flag = player.field_71071_by.func_70441_a(this.func_184550_j());
            }
            if (flag) {
                player.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
            return flag;
        }
        return false;
    }

    protected boolean canBeCaughtInMidair(Entity shooter, Entity entityHit) {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70254_i) {
            ++this.field_70257_an;
        } else if (this.field_70257_an != 0) {
            this.field_70257_an = 0;
        }
    }

    public void func_70240_a(int knockback) {
        this.field_70256_ap = knockback;
    }

    public Entity getThrower() {
        return this.field_70250_c;
    }

    public void setThrower(Entity entity) {
        this.field_70250_c = entity;
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.weapon);
    }

    public void readSpawnData(ByteBuf additionalData) {
        ItemStack stack = ByteBufUtils.readItemStack((ByteBuf)additionalData);
        this.setWeapon(stack);
    }
}

