/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.event;

import baubles.api.BaublesApi;
import com.oblivioussp.spartanweaponry.api.IWeaponPropertyContainer;
import com.oblivioussp.spartanweaponry.api.weaponproperty.IPropertyCallback;
import com.oblivioussp.spartanweaponry.api.weaponproperty.WeaponProperty;
import com.oblivioussp.spartanweaponry.entity.projectile.EntityThrownWeapon;
import com.oblivioussp.spartanweaponry.init.EnchantmentRegistrySW;
import com.oblivioussp.spartanweaponry.item.IBlockingWeapon;
import com.oblivioussp.spartanweaponry.item.ItemQuiverBase;
import com.oblivioussp.spartanweaponry.util.AdvancementTrigger;
import com.oblivioussp.spartanweaponry.util.ConfigHandler;
import com.oblivioussp.spartanweaponry.util.QuiverHelper;
import com.oblivioussp.spartanweaponry.util.WeaponHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber
public class EventHandlerCommon {
    public static Random rand = new Random();
    public static int tickCounter = 0;

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent ev) {
        DamageSource source = ev.getSource();
        if (source.func_76352_a() || source.func_76347_k() || source.func_94541_c() || source.func_82725_o() || !source.func_76355_l().equals("player") && !source.func_76355_l().equals("mob")) {
            return;
        }
        EntityLivingBase victim = ev.getEntityLiving();
        if (source.func_76346_g() instanceof EntityLivingBase && victim != null) {
            IWeaponPropertyContainer container;
            EntityLivingBase attacker = (EntityLivingBase)source.func_76346_g();
            ItemStack stack = attacker.func_184614_ca();
            ItemStack victimStack = victim.func_184614_ca();
            float dmgDealt = ev.getAmount();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof IWeaponPropertyContainer) {
                IPropertyCallback callback;
                container = (IWeaponPropertyContainer)stack.func_77973_b();
                WeaponProperty property = null;
                List<WeaponProperty> props = container.getAllWeaponProperties();
                for (WeaponProperty prop : props) {
                    callback = prop.getCallback();
                    if (callback == null) continue;
                    dmgDealt = callback.modifyDamageDealt(container.getMaterialEx(), dmgDealt, container.getDirectAttackDamage() + 1.0f, source, attacker, victim);
                }
                for (WeaponProperty prop : container.getMaterialEx().getAllWeaponProperties()) {
                    callback = prop.getCallback();
                    if (callback == null) continue;
                    dmgDealt = callback.modifyDamageDealt(container.getMaterialEx(), dmgDealt, container.getDirectAttackDamage() + 1.0f, source, attacker, victim);
                }
                property = container.getFirstWeaponPropertyWithType("armour_piercing");
                if (property != null) {
                    dmgDealt = WeaponHelper.dealArmourPiercingDamage(attacker, property.getMagnitude() / 100.0f, victim, ev.getAmount());
                }
            }
            if (!victimStack.func_190926_b() && victimStack.func_77973_b() instanceof IWeaponPropertyContainer) {
                IPropertyCallback callback;
                container = (IWeaponPropertyContainer)victimStack.func_77973_b();
                List<WeaponProperty> props = container.getAllWeaponProperties();
                for (WeaponProperty prop : props) {
                    callback = prop.getCallback();
                    if (callback == null) continue;
                    dmgDealt = callback.modifyDamageTaken(container.getMaterialEx(), dmgDealt, source, attacker, victim);
                }
                for (WeaponProperty prop : container.getMaterialEx().getAllWeaponProperties()) {
                    callback = prop.getCallback();
                    if (callback == null) continue;
                    dmgDealt = callback.modifyDamageTaken(container.getMaterialEx(), dmgDealt, source, attacker, victim);
                }
            }
            if (dmgDealt != ev.getAmount()) {
                ev.setAmount(dmgDealt);
            }
        }
    }

    @SubscribeEvent
    public static void attackEvent(LivingAttackEvent ev) {
        ItemStack activeStack;
        EntityPlayer player;
        if (ev.getEntityLiving() instanceof EntityPlayer && !(player = (EntityPlayer)ev.getEntityLiving()).func_184607_cu().func_190926_b() && (activeStack = player.func_184607_cu()).func_77973_b() instanceof IBlockingWeapon) {
            IBlockingWeapon weapon = (IBlockingWeapon)activeStack.func_77973_b();
            DamageSource source = ev.getSource();
            if (!(!weapon.canBlockMelee() || source.func_94541_c() || source.func_76347_k() || source.func_82725_o() || source.func_76352_a() || source.func_76363_c())) {
                if (source.func_76346_g() instanceof EntityLivingBase) {
                    ((EntityLivingBase)source.func_76346_g()).func_70653_a((Entity)player, 0.3f, player.field_70165_t - source.func_76346_g().field_70165_t, player.field_70161_v - source.func_76346_g().field_70161_v);
                }
                activeStack.func_77972_a(2, (EntityLivingBase)player);
                player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187721_dT, SoundCategory.PLAYERS, 0.8f, 0.8f);
                ev.setCanceled(true);
            } else if (weapon.canBlockProjectiles() && ev.getSource().func_76352_a()) {
                player.func_184185_a(SoundEvents.field_187721_dT, 0.8f, 0.8f);
                ev.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onCraftEvent(PlayerEvent.ItemCraftedEvent ev) {
        if (ev.player instanceof EntityPlayerMP && ev.crafting.func_77973_b().getRegistryName().func_110623_a().equals("spartanweaponry")) {
            AdvancementTrigger.CRAFT_ITEM.trigger((EntityPlayerMP)ev.player, ev.crafting.func_77973_b());
        }
    }

    @SubscribeEvent
    public static void onLootLevel(LootingLevelEvent ev) {
        Entity e = ev.getDamageSource().func_76364_f();
        if (e instanceof EntityThrownWeapon) {
            EntityThrownWeapon thrownWeapon = (EntityThrownWeapon)e;
            int luckLevel = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistrySW.THROWING_LUCK, (ItemStack)thrownWeapon.getWeaponStack());
            ev.setLootingLevel(luckLevel);
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent ev) {
        if ((ev.getSlot() == EntityEquipmentSlot.MAINHAND || ev.getSlot() == EntityEquipmentSlot.OFFHAND) && ev.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)ev.getEntityLiving();
            ItemStack fromStack = ev.getFrom();
            ItemStack toStack = ev.getTo();
            EntityEquipmentSlot oppositeHand = ev.getSlot() == EntityEquipmentSlot.OFFHAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND;
            ItemStack oppositeStack = player.func_184582_a(oppositeHand);
            if (!fromStack.func_77969_a(toStack) && !oppositeStack.func_190926_b()) {
                boolean toStackBlacklisted = false;
                String toName = toStack.func_77973_b().getRegistryName().toString();
                for (String compName : ConfigHandler.quiverBowBlacklist) {
                    if (!compName.equals(toName)) continue;
                    toStackBlacklisted = true;
                }
                for (QuiverHelper.IQuiverInfo quiverInfo : QuiverHelper.info) {
                    if (!quiverInfo.isWeapon(fromStack) || quiverInfo.isWeapon(toStack) && !toStackBlacklisted || !quiverInfo.isAmmo(oppositeStack)) continue;
                    ItemStack quiver = QuiverHelper.findFirstOfType(player, quiverInfo);
                    EventHandlerCommon.placeAmmoIntoQuiver(player, quiver, oppositeHand);
                    oppositeStack = player.func_184582_a(oppositeHand);
                    if (!oppositeStack.func_190926_b()) continue;
                    break;
                }
            }
            if (!toStack.func_77969_a(fromStack) && oppositeStack.func_190926_b()) {
                String regName = toStack.func_77973_b().getRegistryName().toString();
                for (String compName : ConfigHandler.quiverBowBlacklist) {
                    if (!compName.equals(regName)) continue;
                    return;
                }
                for (QuiverHelper.IQuiverInfo quiverInfo : QuiverHelper.info) {
                    if (!quiverInfo.isWeapon(toStack)) continue;
                    ItemStack quiver = QuiverHelper.findFirstOfType(player, quiverInfo);
                    EventHandlerCommon.takeAmmoFromQuiver(player, quiver, oppositeHand);
                    oppositeStack = player.func_184582_a(oppositeHand);
                    if (oppositeStack.func_190926_b()) continue;
                    break;
                }
            }
        }
    }

    protected static void placeAmmoIntoQuiver(EntityPlayer player, ItemStack quiver, EntityEquipmentSlot oppositeHandSlot) {
        if (!quiver.func_190926_b() && quiver.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler quiverHandler = (IItemHandler)quiver.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            ItemStack arrowStack = player.func_184582_a(oppositeHandSlot);
            for (int j = 0; j < quiverHandler.getSlots() && !(arrowStack = quiverHandler.insertItem(j, arrowStack, false)).func_190926_b(); ++j) {
            }
            player.func_184201_a(oppositeHandSlot, arrowStack);
        }
    }

    protected static void takeAmmoFromQuiver(EntityPlayer player, ItemStack quiver, EntityEquipmentSlot oppositeHandSlot) {
        if (!quiver.func_190926_b() && quiver.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler quiverHandler = (IItemHandler)quiver.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            ItemStack arrowStack = ItemStack.field_190927_a;
            for (int j = 0; j < quiverHandler.getSlots(); ++j) {
                arrowStack = quiverHandler.extractItem(j, 64, false);
                if (arrowStack.func_190926_b()) continue;
                player.func_184201_a(oppositeHandSlot, arrowStack);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerPickupEvent(EntityItemPickupEvent ev) {
        int beforeCount;
        ItemStack pickedUpStack = ev.getItem().func_92059_d().func_77946_l();
        int afterCount = beforeCount = pickedUpStack.func_190916_E();
        List<ItemStack> quivers = EventHandlerCommon.findValidQuivers(ev.getEntityPlayer());
        for (ItemStack quiver : quivers) {
            if (!pickedUpStack.func_190926_b() && !quiver.func_190926_b() && quiver.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && ((ItemQuiverBase)quiver.func_77973_b()).isAmmoValid(pickedUpStack, quiver) && quiver.func_77942_o() && quiver.func_77978_p().func_74767_n("ammoCollect")) {
                IItemHandler quiverHandler = (IItemHandler)quiver.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                for (int i = 0; i < quiverHandler.getSlots() && !(pickedUpStack = quiverHandler.insertItem(i, pickedUpStack, false)).func_190926_b(); ++i) {
                }
            }
            if (!pickedUpStack.func_190926_b()) continue;
            break;
        }
        if ((afterCount = pickedUpStack.func_190916_E()) < beforeCount) {
            ev.getEntityPlayer().func_71001_a((Entity)ev.getItem(), beforeCount - afterCount);
            ev.getItem().func_92059_d().func_190920_e(afterCount);
            ev.getEntityPlayer().field_70170_p.func_184148_a((EntityPlayer)null, ev.getItem().field_70165_t, ev.getItem().field_70163_u, ev.getItem().field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, (rand.nextFloat() - rand.nextFloat()) * 0.7f + 0.0f);
        }
    }

    protected static List<ItemStack> findValidQuivers(EntityPlayer player) {
        ItemStack bauble;
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (Loader.isModLoaded((String)"baubles") && !(bauble = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(5)).func_190926_b() && bauble.func_77973_b() instanceof ItemQuiverBase) {
            result.add(bauble);
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemQuiverBase)) continue;
            result.add(stack);
        }
        return result;
    }
}

