/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.oblivioussp.spartanweaponry.api.SpartanWeaponryAPI;
import com.oblivioussp.spartanweaponry.client.ClientHelper;
import com.oblivioussp.spartanweaponry.network.NetworkHandler;
import com.oblivioussp.spartanweaponry.util.Config;
import com.oblivioussp.spartanweaponry.util.InternalAPIMethodHandler;
import com.oblivioussp.spartanweaponry.util.Log;
import com.oblivioussp.spartanweaponry.util.RecipeJsonGenerator;
import net.minecraft.command.CommandSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import top.theillusivec4.curios.api.imc.CurioIMCMessage;

@Mod(value="spartanweaponry")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModSpartanWeaponry {
    public static final String ID = "spartanweaponry";
    public static final String NAME = "Spartan Weaponry";
    private final boolean isDevVersion = false;

    public ModSpartanWeaponry() {
        Log.info("Constructing Mod: Spartan Weaponry");
        Log.info("Initialising API! Version: 5");
        SpartanWeaponryAPI.internalHandler = new InternalAPIMethodHandler();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onIMCEnqueue);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.CONFIG_SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void onSetup(FMLCommonSetupEvent ev) {
        Log.info("Setting up Spartan Weaponry!");
        DeferredWorkQueue.runLater(() -> NetworkHandler.init());
    }

    private void onClientSetup(FMLClientSetupEvent ev) {
        Log.info("Setting up Client for Spartan Weaponry!");
        ClientHelper.registerEntityRenders();
        ClientHelper.registerItemRenders();
        ClientHelper.registerScreens();
    }

    private void onIMCEnqueue(InterModEnqueueEvent ev) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage("back"));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent ev) {
        Log.info("Starting up Server for Spartan Weaponry!");
        if (SpartanWeaponryAPI.internalHandler.getClass() != InternalAPIMethodHandler.class) {
            throw new IllegalAccessError("Wait, that's illegal! The Spartan Weaponry API Internal Handler has been tampered with!\nRemove the addon mod that has tampered with that handler!");
        }
        Log.debug("The API Internal Handler appears to be the correct class");
    }

    private static /* synthetic */ int lambda$onServerStarting$3(CommandContext context) throws CommandSyntaxException {
        RecipeJsonGenerator.generate();
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(String.format("Finished generating recipes! %d new; %d overwritten", RecipeJsonGenerator.newFilesGenerated, RecipeJsonGenerator.oldFilesOverwritten)), false);
        return 0;
    }

    private static /* synthetic */ boolean lambda$onServerStarting$2(CommandSource source) {
        return source.func_197028_i().func_71264_H();
    }
}

