/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api.trait;

import com.oblivioussp.spartanweaponry.api.trait.ITraitCallback;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class WeaponTrait {
    public static final TextFormatting TITLE_COLOUR_POSITIVE = TextFormatting.GREEN;
    public static final TextFormatting TITLE_COLOUR_NEGATIVE = TextFormatting.RED;
    public static final TextFormatting[] DESCRIPTION_COLOUR = new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC};
    protected String type;
    protected String modId;
    protected int level;
    protected float magnitude;
    protected boolean isNegative;

    public WeaponTrait(String type, String modId, int level, float magnitude, boolean isNegative) {
        this.type = type;
        this.modId = modId;
        this.level = level;
        this.magnitude = magnitude;
        this.isNegative = isNegative;
    }

    public WeaponTrait(String type, String modId, int level, boolean isNegative) {
        this(type, modId, level, 0.0f, isNegative);
    }

    public WeaponTrait(String type, String modId, float magnitude, boolean isNegative) {
        this(type, modId, 0, magnitude, isNegative);
    }

    public WeaponTrait(String type, String modId, boolean isNegative) {
        this(type, modId, 0, isNegative);
    }

    public String toString() {
        return String.format("WeaponTrait{Type: %s:%s - Level: %d - Magnitude: %f}", this.modId, this.type, this.level, Float.valueOf(this.magnitude));
    }

    public String getType() {
        return this.type;
    }

    public float getMagnitude() {
        return this.magnitude;
    }

    public boolean isNegative() {
        return this.isNegative;
    }

    public ITraitCallback getCallback() {
        return null;
    }

    public final void addTooltip(ItemStack stack, List<ITextComponent> tooltip, boolean isShiftPressed) {
        this.addTooltipTitle(stack, tooltip);
        if (isShiftPressed && I18n.func_188566_a((String)String.format("tooltip.%s.trait.%s.desc", "spartanweaponry", this.type))) {
            this.addTooltipDescription(stack, tooltip);
        }
    }

    protected void addTooltipTitle(ItemStack stack, List<ITextComponent> tooltip) {
        if (this.level == 0) {
            tooltip.add(new TranslationTextComponent(String.format("tooltip.%s.trait.%s", "spartanweaponry", this.type), new Object[0]).func_211708_a(this.isNegative ? TITLE_COLOUR_NEGATIVE : TITLE_COLOUR_POSITIVE));
        } else {
            tooltip.add(new TranslationTextComponent(String.format("tooltip.%s.trait.%s", "spartanweaponry", this.type), new Object[]{I18n.func_135052_a((String)("enchantment.level." + Integer.toString(this.level)), (Object[])new Object[0])}).func_211708_a(this.isNegative ? TITLE_COLOUR_NEGATIVE : TITLE_COLOUR_POSITIVE));
        }
    }

    protected void addTooltipDescription(ItemStack stack, List<ITextComponent> tooltip) {
        tooltip.add(new TranslationTextComponent(String.format("tooltip.%s.trait.%s.desc", "spartanweaponry", this.type), new Object[0]).func_211709_a(DESCRIPTION_COLOUR));
    }
}

