/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.entity.projectile;

import com.oblivioussp.spartanweaponry.init.ModEntities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ArrowBaseEntity
extends AbstractArrowEntity
implements IEntityAdditionalSpawnData {
    protected final String NBT_ARROW = "Arrow";
    protected final String NBT_POTION = "Potion";
    protected final String NBT_POTION_COLOUR = "PotionColour";
    protected static final DataParameter<Integer> COLOUR = EntityDataManager.func_187226_a(ArrowBaseEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected Potion potion = Potions.field_185229_a;
    protected float baseDamage = 1.0f;
    protected float rangeMultiplier = 1.0f;
    protected ItemStack arrowStack = ItemStack.field_190927_a;

    public ArrowBaseEntity(EntityType<? extends ArrowBaseEntity> type, World world) {
        super(type, world);
    }

    public ArrowBaseEntity(World worldIn, double x, double y, double z) {
        super(ModEntities.ARROW_SW, x, y, z, worldIn);
    }

    public ArrowBaseEntity(World worldIn, LivingEntity shooter) {
        super(ModEntities.ARROW_SW, shooter, worldIn);
    }

    public ArrowBaseEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(ModEntities.ARROW_SW, world);
    }

    public void initEntity(float baseDamage, float rangeMultiplier, ItemStack arrowStack) {
        this.baseDamage = baseDamage;
        this.rangeMultiplier = rangeMultiplier;
        this.func_70239_b(this.baseDamage);
        this.arrowStack = arrowStack;
    }

    public void func_184547_a(Entity shooter, float pitch, float yaw, float p_184547_4_, float velocity, float inaccuracy) {
        super.func_184547_a(shooter, pitch, yaw, p_184547_4_, velocity * this.rangeMultiplier, inaccuracy);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOUR, (Object)-1);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70254_i) {
                if (this.field_184552_b % 5 == 0) {
                    this.spawnPotionParticles(1);
                }
            } else {
                this.spawnPotionParticles(2);
            }
        } else if (this.field_70254_i && this.field_184552_b != 0 && this.field_184552_b >= 600) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)0);
            this.potion = Potions.field_185229_a;
            this.field_70180_af.func_187227_b(COLOUR, (Object)-1);
        }
    }

    protected void func_184548_a(LivingEntity living) {
        super.func_184548_a(living);
        for (EffectInstance effect : this.potion.func_185170_a()) {
            living.func_195064_c(new EffectInstance(effect.func_188419_a(), Math.max(effect.func_76459_b() / 8, 1), effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e()));
        }
    }

    public void func_70103_a(byte id) {
        if (id == 0) {
            int i = (Integer)this.field_70180_af.func_187225_a(COLOUR);
            if (i != -1) {
                double cR = (double)(i >> 16 & 0xFF) / 255.0;
                double cG = (double)(i >> 8 & 0xFF) / 255.0;
                double cB = (double)(i >> 0 & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg(), this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), cR, cG, cB);
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }

    protected ItemStack func_184550_j() {
        return this.arrowStack;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150788_a(this.arrowStack);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        CompoundNBT nbt = new CompoundNBT();
        nbt = this.arrowStack.func_77955_b(nbt);
        compound.func_218657_a("Arrow", (INBT)nbt);
        if (this.potion != null && this.potion != Potions.field_185229_a) {
            compound.func_74778_a("Potion", ForgeRegistries.POTION_TYPES.getKey((IForgeRegistryEntry)this.potion).toString());
        }
        compound.func_74768_a("PotionColour", ((Integer)this.field_70180_af.func_187225_a(COLOUR)).intValue());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.arrowStack = additionalData.func_150791_c();
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        CompoundNBT nbt = compound.func_74775_l("Arrow");
        this.arrowStack = ItemStack.func_199557_a((CompoundNBT)nbt);
        if (compound.func_150297_b("Potion", 8)) {
            this.potion = PotionUtils.func_185187_c((CompoundNBT)compound);
        }
        this.field_70180_af.func_187227_b(COLOUR, (Object)(compound.func_74764_b("PotionColour") ? compound.func_74762_e("PotionColour") : -1));
    }

    public boolean isValid() {
        return !this.arrowStack.func_190926_b();
    }

    public ResourceLocation getTexture() {
        int idx;
        String arrowRegName = this.arrowStack.func_77973_b().getRegistryName().func_110623_a();
        if (this.potion.getRegistryName().func_110623_a() != "empty" && (idx = arrowRegName.indexOf("_tipped")) != -1) {
            arrowRegName = arrowRegName.substring(0, idx);
        }
        return new ResourceLocation("spartanweaponry", "textures/entity/projectiles/" + arrowRegName + ".png");
    }

    public void setPotionEffect(ItemStack stack) {
        this.potion = PotionUtils.func_185191_c((ItemStack)stack);
        this.field_70180_af.func_187227_b(COLOUR, (Object)PotionUtils.func_190932_c((ItemStack)stack));
    }

    public void spawnPotionParticles(int particleCount) {
        int colour = (Integer)this.field_70180_af.func_187225_a(COLOUR);
        if (colour != -1 && particleCount > 0) {
            double cR = (double)(colour >> 16 & 0xFF) / 255.0;
            double cG = (double)(colour >> 8 & 0xFF) / 255.0;
            double cB = (double)(colour >> 0 & 0xFF) / 255.0;
            for (int i = 0; i < particleCount; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg(), this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), cR, cG, cB);
            }
        }
    }
}

