/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.entity.projectile;

import com.oblivioussp.spartanweaponry.api.IWeaponTraitContainer;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.trait.ITraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.init.ModEntities;
import com.oblivioussp.spartanweaponry.init.ModSounds;
import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class ThrowingWeaponEntity
extends AbstractArrowEntity
implements IEntityAdditionalSpawnData {
    public static final String NBT_WEAPON = "Weapon";
    protected ItemStack weapon = ItemStack.field_190927_a;
    protected int field_70256_ap = 0;
    protected int field_70257_an = 0;

    public ThrowingWeaponEntity(EntityType<? extends ThrowingWeaponEntity> type, World world) {
        super(type, world);
    }

    public ThrowingWeaponEntity(EntityType<? extends ThrowingWeaponEntity> type, World world, double x, double y, double z) {
        super(type, x, y, z, world);
    }

    public ThrowingWeaponEntity(EntityType<? extends ThrowingWeaponEntity> type, LivingEntity shooter, World world) {
        super(type, shooter, world);
    }

    public ThrowingWeaponEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(ModEntities.THROWING_WEAPON, world);
    }

    protected ItemStack func_184550_j() {
        return this.weapon;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70254_i) {
            ++this.field_70257_an;
        } else if (this.field_70257_an != 0) {
            this.field_70257_an = 0;
        }
    }

    protected void func_203048_f() {
        super.func_203048_f();
        if (!this.func_70089_S() && this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
            this.func_70099_a(this.func_184550_j(), 0.1f);
        }
    }

    protected void func_213868_a(EntityRayTraceResult rayTrace) {
        Entity entity = rayTrace.func_216348_a();
        Entity shooter = this.func_212360_k();
        if (entity != null) {
            float damage = (float)this.func_70242_d();
            if (shooter != null && this.canBeCaughtInMidair(shooter, entity) && entity instanceof PlayerEntity && this.attemptCatch((PlayerEntity)entity)) {
                return;
            }
            EntityDamageSource src = shooter == null ? new EntityDamageSource("mob", (Entity)this) : (shooter instanceof PlayerEntity ? new EntityDamageSource("player", shooter) : new EntityDamageSource("mob", shooter));
            if (this.weapon.func_77973_b() instanceof IWeaponTraitContainer && entity instanceof LivingEntity && shooter instanceof LivingEntity && !entity.func_70028_i(shooter)) {
                ITraitCallback callback;
                IWeaponTraitContainer container = (IWeaponTraitContainer)this.weapon.func_77973_b();
                WeaponMaterial material = container.getMaterial();
                List<WeaponTrait> traits = container.getAllWeaponTraits();
                for (WeaponTrait trait : traits) {
                    callback = trait.getCallback();
                    if (callback == null) continue;
                    damage = callback.modifyDamageDealt(material, damage, (DamageSource)src, (LivingEntity)shooter, (LivingEntity)entity);
                    callback.onHitEntity(container.getMaterial(), this.weapon, (LivingEntity)entity, (LivingEntity)shooter, (Entity)this);
                }
                for (WeaponTrait prop : material.getAllWeaponTraits()) {
                    callback = prop.getCallback();
                    if (callback == null) continue;
                    damage = callback.modifyDamageDealt(material, damage, (DamageSource)src, (LivingEntity)shooter, (LivingEntity)entity);
                    callback.onHitEntity(material, this.weapon, (LivingEntity)entity, (LivingEntity)shooter, (Entity)this);
                }
            }
            if (this.func_70027_ad() && !(entity instanceof EndermanEntity)) {
                entity.func_70015_d(5);
            }
            if (entity.func_70097_a((DamageSource)src, damage)) {
                if (entity instanceof LivingEntity) {
                    Vec3d knockVec;
                    LivingEntity entitylivingbase = (LivingEntity)entity;
                    if (this.field_70256_ap > 0 && (knockVec = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)this.field_70256_ap * 0.6)).func_189985_c() > 0.0) {
                        entitylivingbase.func_70024_g(knockVec.field_72450_a, 0.1, knockVec.field_72449_c);
                    }
                    if (!this.field_70170_p.field_72995_K && shooter instanceof LivingEntity) {
                        EnchantmentHelper.func_151384_a((LivingEntity)entitylivingbase, (Entity)shooter);
                        EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)shooter), (Entity)entitylivingbase);
                    }
                    this.func_184548_a(entitylivingbase);
                    if (shooter != null && entitylivingbase != shooter && entitylivingbase instanceof PlayerEntity && shooter instanceof ServerPlayerEntity) {
                        ((ServerPlayerEntity)shooter).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(6, 0.0f));
                    }
                }
                this.func_184185_a(this.getMobHitSound(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                if (!(entity instanceof EndermanEntity)) {
                    this.func_213317_d(this.func_213322_ci().func_186678_a(-0.1));
                    this.field_70177_z += 180.0f;
                    this.field_70126_B += 180.0f;
                }
            } else {
                this.func_213317_d(this.func_213322_ci().func_186678_a(-0.1));
                this.field_70177_z += 180.0f;
                this.field_70126_B += 180.0f;
                this.field_70257_an = 0;
                if (!this.field_70170_p.field_72995_K && this.func_213322_ci().func_189985_c() < 1.0E-7) {
                    if (this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                        this.func_70099_a(this.func_184550_j(), 0.1f);
                    }
                    this.func_70106_y();
                }
            }
        } else {
            super.func_213868_a(rayTrace);
        }
    }

    public void func_70103_a(byte id) {
        if (id == 3) {
            float maxMotion = 0.5f;
            for (int i = 0; i < 16; ++i) {
                ItemParticleData particle = new ItemParticleData(ParticleTypes.field_197591_B, this.weapon);
                float motionX = (this.field_70146_Z.nextFloat() - 0.5f) * maxMotion;
                float motionY = this.field_70146_Z.nextFloat() * 0.5f * maxMotion;
                float motionZ = (this.field_70146_Z.nextFloat() - 0.5f) * maxMotion;
                this.field_70170_p.func_195594_a((IParticleData)particle, this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)motionX, (double)motionY, (double)motionZ);
            }
        }
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        if (this.field_70254_i) {
            this.attemptCatch(entityIn);
        }
    }

    public void func_70240_a(int knockbackStrengthIn) {
        this.field_70256_ap = knockbackStrengthIn;
    }

    protected SoundEvent func_213867_k() {
        return this.getGroundHitSound();
    }

    protected SoundEvent getGroundHitSound() {
        return ModSounds.THROWING_KNIFE_HIT_GROUND;
    }

    protected SoundEvent getMobHitSound() {
        return ModSounds.THROWING_KNIFE_HIT_MOB;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        CompoundNBT weaponNBT = compound.func_74775_l(NBT_WEAPON);
        this.weapon = ItemStack.func_199557_a((CompoundNBT)weaponNBT);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeItemStack(this.weapon, false);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        ItemStack stack = additionalData.func_150791_c();
        this.setWeapon(stack);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        CompoundNBT weaponNBT = new CompoundNBT();
        weaponNBT = this.weapon.func_77955_b(weaponNBT);
        compound.func_218657_a(NBT_WEAPON, (INBT)weaponNBT);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ItemStack getWeaponStack() {
        return this.func_184550_j();
    }

    public boolean isValidThrowingWeapon() {
        return !this.weapon.func_190926_b();
    }

    public void setWeapon(ItemStack weaponStack) {
        this.weapon = weaponStack.func_77946_l();
    }

    protected boolean canBeCaughtInMidair(Entity shooter, Entity entityHit) {
        return false;
    }

    public int getTicksInAir() {
        return this.field_70257_an;
    }

    protected boolean attemptCatch(PlayerEntity player) {
        if (!this.field_70170_p.field_72995_K && this.field_70249_b <= 0) {
            boolean canBePickedUp;
            boolean bl = canBePickedUp = this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED || this.field_70251_a == AbstractArrowEntity.PickupStatus.CREATIVE_ONLY && player.field_71075_bZ.field_75098_d;
            if (this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                canBePickedUp = player.field_71071_by.func_70441_a(this.func_184550_j());
            }
            if (canBePickedUp) {
                player.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
            return canBePickedUp;
        }
        return false;
    }
}

