/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.client.gui.HudElementCrosshair;
import com.oblivioussp.spartanweaponry.client.gui.HudElementCrosshairHeavyCrossbow;
import com.oblivioussp.spartanweaponry.entity.projectile.BoltEntity;
import com.oblivioussp.spartanweaponry.init.ModItems;
import com.oblivioussp.spartanweaponry.item.BoltItem;
import com.oblivioussp.spartanweaponry.item.IHudCrosshair;
import com.oblivioussp.spartanweaponry.item.IHudLoadState;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HeavyCrossbowItem
extends CrossbowItem
implements IHudLoadState,
IHudCrosshair {
    protected WeaponMaterial material;
    protected String modId = null;
    protected String displayName = null;
    public static final String NBT_CHARGED = "Charged";
    public static final String NBT_PROJECTILE = "Projectile";
    public static final Predicate<ItemStack> BOLT = stack -> stack.func_77973_b().func_206844_a(ItemTags.func_199903_a().func_199910_a(new ResourceLocation("spartanweaponry", "bolts")));

    public HeavyCrossbowItem(String unlocName, ItemGroup group, WeaponMaterial material) {
        super(new Item.Properties().func_200916_a(group).func_200917_a(1).func_200918_c((int)((float)material.func_200926_a() * 1.5f)));
        this.setRegistryName("spartanweaponry", unlocName);
        this.material = material;
        this.func_185043_a(new ResourceLocation("pull"), (stack, world, living) -> {
            if (living != null && stack.func_77973_b() == this) {
                return this.isLoaded(stack) ? 0.0f : (float)this.getLoadingTicks(stack, living) / (float)this.getFullLoadTicks(stack);
            }
            return 0.0f;
        });
        this.func_185043_a(new ResourceLocation("pulling"), (stack, world, living) -> living != null && living.func_184587_cr() && living.func_184607_cu() == stack ? 1.0f : 0.0f);
        this.func_185043_a(new ResourceLocation("charged"), (stack, world, living) -> this.isLoaded(stack) ? 1.0f : 0.0f);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.material.func_200926_a();
    }

    public Predicate<ItemStack> func_220006_d() {
        return BOLT;
    }

    public Predicate<ItemStack> func_220004_b() {
        return BOLT;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            boolean isCreativeOrInfinite;
            PlayerEntity player = (PlayerEntity)entityLiving;
            boolean bl = isCreativeOrInfinite = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            if (this.getLoadProgress(stack, entityLiving) == 1.0f) {
                stack.func_196082_o().func_74757_a(NBT_CHARGED, true);
                ItemStack bolt = ItemStack.field_190927_a;
                int count = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222192_G, (ItemStack)stack) > 0 ? 3 : 1;
                bolt = entityLiving.func_213356_f(stack);
                if (bolt.func_190926_b() || !BOLT.test(bolt)) {
                    bolt = new ItemStack((IItemProvider)ModItems.bolt, count);
                }
                ItemStack boltToStore = bolt.func_77946_l();
                boltToStore.func_190920_e(count);
                CompoundNBT nbtBolt = new CompoundNBT();
                boltToStore.func_77955_b(nbtBolt);
                stack.func_77978_p().func_218657_a(NBT_PROJECTILE, (INBT)nbtBolt);
                if (!player.field_71075_bZ.field_75098_d) {
                    bolt.func_190918_g(1);
                    if (bolt.func_190926_b()) {
                        player.field_71071_by.func_184437_d(bolt);
                    }
                }
                worldIn.func_184148_a((PlayerEntity)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_219610_bB, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.0f) + 0.2f);
            } else {
                int i;
                ItemStack itemstack = ItemStack.field_190927_a;
                CompoundNBT tag = stack.func_196082_o().func_74775_l(NBT_PROJECTILE);
                if (tag != null && !tag.isEmpty()) {
                    itemstack = ItemStack.func_199557_a((CompoundNBT)tag);
                }
                if ((i = this.func_77626_a(stack) - timeLeft) < 0 || !stack.func_77978_p().func_74767_n(NBT_CHARGED)) {
                    return;
                }
                if (!itemstack.func_190926_b() || isCreativeOrInfinite) {
                    if (itemstack.func_190926_b()) {
                        itemstack = new ItemStack((IItemProvider)ModItems.bolt);
                    }
                    if (!worldIn.field_72995_K) {
                        BoltItem itemBolt = (BoltItem)(itemstack.func_77973_b() instanceof BoltItem ? itemstack.func_77973_b() : ModItems.bolt);
                        boolean flag1 = player.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof BoltItem && ((BoltItem)itemstack.func_77973_b()).isInfinite(itemstack, stack, player);
                        int inaccuracy = MathHelper.func_76125_a((int)(10 - i), (int)0, (int)10);
                        float inaccuracyModifier = 0.0f;
                        if (inaccuracy != 0) {
                            inaccuracyModifier = 12.0f * ((float)inaccuracy / 10.0f);
                        }
                        this.spawnProjectile(stack, itemBolt, itemstack, worldIn, player, flag1, inaccuracyModifier, 0.0f);
                        if (itemstack.func_190916_E() > 1) {
                            this.spawnProjectile(stack, itemBolt, itemstack, worldIn, player, flag1, inaccuracyModifier, -10.0f);
                            this.spawnProjectile(stack, itemBolt, itemstack, worldIn, player, flag1, inaccuracyModifier, 10.0f);
                        }
                        int damage = itemstack.func_190916_E() > 1 ? 3 : 1;
                        stack.func_222118_a(damage, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(player.func_184600_cs()));
                        stack.func_77978_p().func_74757_a(NBT_CHARGED, false);
                        stack.func_77978_p().func_218657_a(NBT_PROJECTILE, (INBT)new CompoundNBT());
                    }
                    worldIn.func_184148_a((PlayerEntity)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_219616_bH, SoundCategory.NEUTRAL, 1.0f, 1.0f / (Item.field_77697_d.nextFloat() * 0.4f + 1.2f) + HeavyCrossbowItem.getBoltVelocity() * 0.5f);
                    player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                }
            }
        }
    }

    public static float getBoltVelocity() {
        return 1.5f;
    }

    protected void spawnProjectile(ItemStack crossbow, BoltItem boltItem, ItemStack boltStack, World worldIn, PlayerEntity player, boolean creativeOrInfinite, float inaccuracyModifier, float projectileAngle) {
        int k;
        BoltEntity entityBolt = boltItem.createBolt(worldIn, boltStack, (LivingEntity)player);
        entityBolt.func_70243_d(true);
        entityBolt.func_213869_a(SoundEvents.field_219609_bA);
        int pierceLvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222194_I, (ItemStack)crossbow);
        if (pierceLvl > 0) {
            entityBolt.func_213872_b((byte)pierceLvl);
        }
        Quaternion quat = new Quaternion(new Vector3f(player.func_213286_i(1.0f)), projectileAngle, true);
        Vector3f velocityVec = new Vector3f(player.func_70676_i(1.0f));
        velocityVec.func_214905_a(quat);
        entityBolt.func_70186_c(velocityVec.func_195899_a(), velocityVec.func_195900_b(), velocityVec.func_195902_c(), HeavyCrossbowItem.getBoltVelocity() * 3.0f, inaccuracyModifier);
        int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)crossbow);
        if (j > 0) {
            entityBolt.func_70239_b(entityBolt.func_70242_d() + (double)j * 0.5 + 0.5);
        }
        if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)crossbow)) > 0) {
            entityBolt.func_70240_a(k);
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)crossbow) > 0) {
            entityBolt.func_70015_d(100);
        }
        if (creativeOrInfinite || projectileAngle != 0.0f) {
            entityBolt.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
        }
        worldIn.func_217376_c((Entity)entityBolt);
    }

    public UseAction func_77661_b(ItemStack stack) {
        if (!stack.func_196082_o().func_74767_n(NBT_CHARGED)) {
            return UseAction.CROSSBOW;
        }
        return UseAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        boolean hasAmmo;
        ItemStack stack = playerIn.func_184586_b(handIn);
        ItemStack ammoStack = playerIn.func_213356_f(stack);
        boolean bl = hasAmmo = !ammoStack.func_190926_b();
        if (!(playerIn.field_71075_bZ.field_75098_d || hasAmmo || stack.func_196082_o().func_74767_n(NBT_CHARGED) || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) != 0)) {
            return !hasAmmo ? new ActionResult(ActionResultType.FAIL, (Object)stack) : new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        playerIn.func_184598_c(handIn);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void func_219972_a(World worldIn, LivingEntity livingEntityIn, ItemStack stack, int count) {
        if (!worldIn.field_72995_K && !stack.func_196082_o().func_74767_n(NBT_CHARGED) && livingEntityIn instanceof PlayerEntity) {
            float loadTicks = this.getLoadProgress(stack, livingEntityIn);
            SoundEvent loadingSound = null;
            if (loadTicks == 0.0f) {
                loadingSound = SoundEvents.field_219612_bD;
            } else if (loadTicks == 0.5f || loadTicks == 0.9f) {
                loadingSound = SoundEvents.field_219611_bC;
            }
            if (loadingSound != null) {
                worldIn.func_184148_a((PlayerEntity)null, livingEntityIn.field_70165_t, livingEntityIn.field_70163_u, livingEntityIn.field_70161_v, loadingSound, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.material != null ? this.material.func_200927_e() : 1;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.material.func_200924_f().test(repair);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ItemStack bolt;
        if (stack.func_196082_o().func_74764_b(NBT_CHARGED) && !(bolt = ItemStack.func_199557_a((CompoundNBT)stack.func_77978_p().func_74775_l(NBT_PROJECTILE))).func_190926_b()) {
            tooltip.add((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.heavy_crossbow.loaded_bolt", "spartanweaponry"), new Object[]{String.format("[%s x%d]", TextFormatting.AQUA.toString() + bolt.func_200301_q().func_150261_e() + TextFormatting.WHITE.toString(), bolt.func_190916_E())}));
            tooltip.add((ITextComponent)new StringTextComponent(""));
        }
        if (Screen.hasShiftDown()) {
            tooltip.add((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.heavy_crossbow.desc", "spartanweaponry"), new Object[0]));
            tooltip.add((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.heavy_crossbow.desc_2", "spartanweaponry"), new Object[0]));
            tooltip.add((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.heavy_crossbow.desc_3", "spartanweaponry"), new Object[0]));
        } else {
            tooltip.add(new TranslationTextComponent(String.format("tooltip.%s.show_description", "spartanweaponry"), new Object[]{TextFormatting.DARK_AQUA.toString() + "SHIFT" + TextFormatting.DARK_GRAY.toString()}).func_211708_a(TextFormatting.DARK_GRAY));
        }
        tooltip.add((ITextComponent)new StringTextComponent(""));
        tooltip.add(new TranslationTextComponent(String.format("tooltip.%s.modifiers.ammo.type", "spartanweaponry"), new Object[]{I18n.func_135052_a((String)String.format("tooltip.%s.modifiers.ammo.bolt", "spartanweaponry"), (Object[])new Object[0])}).func_211708_a(TextFormatting.GRAY));
        tooltip.add(new TranslationTextComponent(String.format("tooltip.%s.modifiers.heavy_crossbow.load_time", "spartanweaponry"), new Object[]{Float.valueOf((float)this.getFullLoadTicks(stack) / 20.0f)}).func_211708_a(TextFormatting.GRAY));
        tooltip.add(new TranslationTextComponent(String.format("tooltip.%s.modifiers.heavy_crossbow.aim_time", "spartanweaponry"), new Object[]{Float.valueOf(0.5f)}).func_211708_a(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new StringTextComponent(""));
    }

    public String getHighlightTip(ItemStack item, String displayName) {
        ItemStack bolt;
        if (item.func_77942_o() && !(bolt = ItemStack.func_199557_a((CompoundNBT)item.func_77978_p().func_74775_l(NBT_PROJECTILE))).func_190926_b()) {
            return String.format("%s [%s x%d]", displayName, bolt.func_200301_q().func_150254_d(), bolt.func_190916_E());
        }
        return super.getHighlightTip(item, displayName);
    }

    @Override
    public boolean isLoaded(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74767_n(NBT_CHARGED);
    }

    @Override
    public float getLoadProgress(ItemStack stack, LivingEntity living) {
        return !this.isLoaded(stack) ? MathHelper.func_76131_a((float)((float)this.getLoadingTicks(stack, living) / (float)this.getFullLoadTicks(stack)), (float)0.0f, (float)1.0f) : 0.0f;
    }

    protected int getFullLoadTicks(ItemStack stack) {
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)stack);
        return 25 - 5 * i;
    }

    protected int getLoadingTicks(ItemStack stack, LivingEntity living) {
        return stack.func_77988_m() - living.func_184605_cv();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public HudElementCrosshair createHudElement() {
        return new HudElementCrosshairHeavyCrossbow();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getType() {
        return HudElementCrosshairHeavyCrossbow.TYPE;
    }
}

