/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class LongbowItem
extends BowItem {
    protected WeaponMaterial material;
    protected static float maxVelocity = 1.25f;
    protected String modId = null;
    protected String displayName = null;
    protected boolean doCraftCheck = true;
    protected boolean canBeCrafted = true;

    public LongbowItem(String unlocName, ItemGroup group, WeaponMaterial material) {
        super(new Item.Properties().func_200916_a(group).func_200918_c((int)((float)material.func_200926_a() * 1.5f)));
        this.material = material;
        this.setRegistryName(unlocName);
        maxVelocity = 1.25f;
        this.func_185043_a(new ResourceLocation("pull"), (stack, world, shooter) -> {
            if (shooter == null) {
                return 0.0f;
            }
            return !(shooter.func_184607_cu().func_77973_b() instanceof LongbowItem) ? 0.0f : (float)(stack.func_77988_m() - shooter.func_184605_cv()) / (20.0f * maxVelocity);
        });
    }

    public int getMaxDamage(ItemStack stack) {
        return this.material.func_200926_a();
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            boolean flag = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack itemstack = player.func_213356_f(stack);
            int i = this.func_77626_a(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (PlayerEntity)((PlayerEntity)entityLiving), (int)i, (itemstack != null || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.func_190926_b() || flag) {
                float f;
                if (itemstack.func_190926_b()) {
                    itemstack = new ItemStack((IItemProvider)Items.field_151032_g);
                }
                if ((double)(f = LongbowItem.getArrowVelocity(i)) >= 0.1) {
                    boolean flag1;
                    boolean bl = flag1 = player.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof ArrowItem && ((ArrowItem)itemstack.func_77973_b()).isInfinite(itemstack, stack, player);
                    if (!worldIn.field_72995_K) {
                        int k;
                        int j;
                        ArrowItem itemarrow = (ArrowItem)(itemstack.func_77973_b() instanceof ArrowItem ? itemstack.func_77973_b() : Items.field_151032_g);
                        AbstractArrowEntity entityarrow = itemarrow.func_200887_a(worldIn, itemstack, (LivingEntity)player);
                        entityarrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, f * 3.0f, 0.5f);
                        if (f == maxVelocity) {
                            entityarrow.func_70243_d(true);
                        }
                        if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)j * 0.5 + 0.5);
                        }
                        if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                            entityarrow.func_70240_a(k);
                        }
                        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                            entityarrow.func_70015_d(100);
                        }
                        stack.func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(player.func_184600_cs()));
                        if (flag1 || player.field_71075_bZ.field_75098_d && (itemstack.func_77973_b() == Items.field_185166_h || itemstack.func_77973_b() == Items.field_185167_i)) {
                            entityarrow.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                        }
                        worldIn.func_217376_c((Entity)entityarrow);
                    }
                    worldIn.func_184148_a((PlayerEntity)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag1) {
                        itemstack.func_190918_g(1);
                        if (itemstack.func_190926_b()) {
                            player.field_71071_by.func_184437_d(itemstack);
                        }
                    }
                    player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                }
            }
        }
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > maxVelocity) {
            f = maxVelocity;
        }
        return f;
    }

    public int func_77619_b() {
        return this.material.func_200927_e();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.material.func_200924_f().test(repair);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.hasShiftDown()) {
            tooltip.add((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.longbow.desc", "spartanweaponry"), new Object[0]));
            tooltip.add((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.longbow.desc_2", "spartanweaponry"), new Object[0]));
        } else {
            tooltip.add(new TranslationTextComponent(String.format("tooltip.%s.show_description", "spartanweaponry"), new Object[]{TextFormatting.DARK_AQUA.toString() + "SHIFT" + TextFormatting.DARK_GRAY.toString()}).func_211708_a(TextFormatting.DARK_GRAY));
        }
        tooltip.add((ITextComponent)new StringTextComponent(""));
        tooltip.add(new TranslationTextComponent(String.format("tooltip.%s.modifiers.ammo.type", "spartanweaponry"), new Object[]{I18n.func_135052_a((String)String.format("tooltip.%s.modifiers.ammo.arrow", "spartanweaponry"), (Object[])new Object[0])}).func_211708_a(TextFormatting.GRAY));
        tooltip.add(new TranslationTextComponent(String.format("tooltip.%s.modifiers.longbow.draw_length", "spartanweaponry"), new Object[]{Float.valueOf(1.25f)}).func_211708_a(TextFormatting.GRAY));
        tooltip.add(new TranslationTextComponent(String.format("tooltip.%s.modifiers.longbow.speed_multiplier", "spartanweaponry"), new Object[]{Float.valueOf(1.25f)}).func_211708_a(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new StringTextComponent(""));
    }
}

