/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.oblivioussp.spartanweaponry.api.IWeaponTraitContainer;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.trait.ITraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.client.gui.HudElementCrosshair;
import com.oblivioussp.spartanweaponry.client.gui.HudElementCrosshairThrowingWeapon;
import com.oblivioussp.spartanweaponry.entity.projectile.ThrowingWeaponEntity;
import com.oblivioussp.spartanweaponry.init.ModEnchantments;
import com.oblivioussp.spartanweaponry.init.ModEntities;
import com.oblivioussp.spartanweaponry.init.ModSounds;
import com.oblivioussp.spartanweaponry.item.IHudCrosshair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ThrowingWeaponItem
extends Item
implements IWeaponTraitContainer<ThrowingWeaponItem>,
IHudCrosshair {
    protected float attackDamage = 1.0f;
    protected double attackSpeed = 0.0;
    protected float throwVelocity = 2.0f;
    protected float throwDamageMultiplier = 2.0f;
    protected List<WeaponTrait> traits;
    protected WeaponMaterial material;

    public ThrowingWeaponItem(String regName, Item.Properties prop, WeaponMaterial material, float weaponBaseDamage, float weaponDamageMultiplier, float weaponSpeed, WeaponTrait ... traits) {
        super(prop);
        this.setRegistryName("spartanweaponry", regName);
        this.material = material;
        this.setAttackDamage(weaponBaseDamage, weaponDamageMultiplier);
        this.setAttackSpeed(weaponSpeed);
        this.traits = new ArrayList<WeaponTrait>();
        this.traits.addAll(Arrays.asList(traits));
        WeaponTrait extraDamageTrait = this.getFirstWeaponTraitWithType("extra_damage_thrown");
        this.throwDamageMultiplier = extraDamageTrait != null ? extraDamageTrait.getMagnitude() : 1.0f;
        this.func_185043_a(new ResourceLocation("throwing"), (stack, world, living) -> {
            if (living == null || !stack.func_77969_a(living.func_184607_cu())) {
                return 0.0f;
            }
            return living.func_184605_cv() > 0 ? 1.0f : 0.0f;
        });
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof LivingEntity) {
            ITraitCallback callback;
            LivingEntity living = (LivingEntity)entity;
            if (this.field_185051_m != null) {
                for (WeaponTrait trait : this.traits) {
                    callback = trait.getCallback();
                    if (callback == null) continue;
                    callback.onItemUpdate(this.material, stack, world, living, itemSlot, isSelected);
                }
            }
            if (this.material.hasAnyWeaponTrait()) {
                for (WeaponTrait property : this.material.getAllWeaponTraits()) {
                    callback = property.getCallback();
                    if (callback == null) continue;
                    callback.onItemUpdate(this.material, stack, world, living, itemSlot, isSelected);
                }
            }
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        boolean isShiftPressed = Screen.hasShiftDown();
        tooltip.add(new TranslationTextComponent(String.format("tooltip.%s.modifiers.max_stack_size", "spartanweaponry"), new Object[]{stack.func_77976_d()}).func_211708_a(TextFormatting.GRAY));
        if (!this.traits.isEmpty()) {
            if (isShiftPressed) {
                tooltip.add(new TranslationTextComponent(String.format("tooltip.%s.traits", "spartanweaponry"), new Object[]{TextFormatting.DARK_GRAY.toString() + I18n.func_135052_a((String)"tooltip.spartanweaponry.traits.showing_details", (Object[])new Object[0])}).func_211708_a(TextFormatting.GOLD));
            } else {
                tooltip.add(new TranslationTextComponent(String.format("tooltip.%s.traits", "spartanweaponry"), new Object[]{TextFormatting.DARK_GRAY.toString() + I18n.func_135052_a((String)"tooltip.spartanweaponry.traits.show_details", (Object[])new Object[]{TextFormatting.DARK_AQUA.toString() + "SHIFT" + TextFormatting.DARK_GRAY.toString()})}).func_211708_a(TextFormatting.GOLD));
            }
            for (WeaponTrait trait : this.traits) {
                trait.addTooltip(stack, tooltip, isShiftPressed);
            }
        }
        if (this.material.hasAnyWeaponTrait()) {
            tooltip.add((ITextComponent)new StringTextComponent(""));
            tooltip.add(new TranslationTextComponent(String.format("tooltip.%s.traits.material_bonus", "spartanweaponry"), new Object[0]).func_211708_a(TextFormatting.DARK_AQUA));
            for (WeaponTrait matTrait : this.material.getAllWeaponTraits()) {
                matTrait.addTooltip(stack, tooltip, isShiftPressed);
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.getDirectAttackDamage(), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", this.attackSpeed - 4.0, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        ITraitCallback callback;
        for (WeaponTrait trait : this.traits) {
            callback = trait.getCallback();
            if (callback == null) continue;
            callback.onHitEntity(this.material, stack, target, attacker, null);
        }
        for (WeaponTrait trait : this.material.getAllWeaponTraits()) {
            callback = trait.getCallback();
            if (callback == null) continue;
            callback.onHitEntity(this.material, stack, target, attacker, null);
        }
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            int charge = this.func_77626_a(stack) - timeLeft;
            if (charge >= 5) {
                charge = 5;
            }
            if (!worldIn.field_72995_K && charge > 2) {
                ThrowingWeaponEntity thrown = this.createThrowingWeaponEntity(worldIn, player, stack, charge);
                if (thrown == null) {
                    return;
                }
                ItemStack weaponStack = stack.func_77946_l();
                weaponStack.func_190920_e(1);
                thrown.setWeapon(weaponStack);
                thrown.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, this.throwVelocity * ((float)charge / 10.0f + 0.5f), 0.5f);
                float damage = (this.getDirectAttackDamage() + 1.0f) * this.throwDamageMultiplier;
                thrown.func_70239_b(damage);
                int j = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.THROWING_DAMAGE, (ItemStack)stack);
                if (j > 0) {
                    thrown.func_70239_b(thrown.func_70242_d() + (double)j * 0.5 + 0.5);
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.THROWING_FIRE, (ItemStack)stack) > 0) {
                    thrown.func_70015_d(100);
                }
                if (player.field_71075_bZ.field_75098_d) {
                    thrown.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                } else if (thrown.isValidThrowingWeapon()) {
                    stack.func_190918_g(1);
                    if (stack.func_190916_E() <= 0) {
                        player.field_71071_by.func_184437_d(stack);
                    }
                }
                if (thrown.isValidThrowingWeapon()) {
                    worldIn.func_184148_a((PlayerEntity)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.getThrowSound(), SoundCategory.PLAYERS, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                    worldIn.func_217376_c((Entity)thrown);
                }
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            }
        }
        super.func_77615_a(stack, worldIn, entityLiving, timeLeft);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.SPEAR;
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        ITraitCallback callback;
        for (WeaponTrait trait : this.traits) {
            callback = trait.getCallback();
            if (callback == null) continue;
            callback.onCreateItem(this.material, stack);
        }
        for (WeaponTrait trait : this.material.getAllWeaponTraits()) {
            callback = trait.getCallback();
            if (callback == null) continue;
            callback.onCreateItem(this.material, stack);
        }
        super.func_77622_d(stack, worldIn, playerIn);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ITraitCallback callback;
            ItemStack stack = new ItemStack((IItemProvider)this);
            for (WeaponTrait trait : this.traits) {
                callback = trait.getCallback();
                if (callback == null) continue;
                callback.onCreateItem(this.material, stack);
            }
            for (WeaponTrait trait : this.material.getAllWeaponTraits()) {
                callback = trait.getCallback();
                if (callback == null) continue;
                callback.onCreateItem(this.material, stack);
            }
            items.add((Object)stack);
        }
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.material.func_200927_e();
    }

    @Override
    public boolean hasWeaponTrait(WeaponTrait prop) {
        return this.traits.contains(prop);
    }

    @Override
    public ThrowingWeaponItem addWeaponTrait(WeaponTrait prop) {
        this.traits.add(prop);
        return this;
    }

    @Override
    public WeaponTrait getFirstWeaponTraitWithType(String type) {
        for (WeaponTrait property : this.traits) {
            if (property.getType() != type) continue;
            return property;
        }
        for (WeaponTrait trait : this.material.getAllWeaponTraits()) {
            if (trait.getType() != type) continue;
            return trait;
        }
        return null;
    }

    @Override
    public List<WeaponTrait> getAllWeaponTraitsWithType(String type) {
        ArrayList<WeaponTrait> result = new ArrayList<WeaponTrait>();
        for (WeaponTrait property : this.traits) {
            if (property.getType() != type) continue;
            result.add(property);
        }
        for (WeaponTrait trait : this.material.getAllWeaponTraits()) {
            if (trait.getType() != type) continue;
            result.add(trait);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    @Override
    public List<WeaponTrait> getAllWeaponTraits() {
        return new ArrayList<WeaponTrait>(this.traits);
    }

    @Override
    public WeaponMaterial getMaterial() {
        return this.material;
    }

    public float getDirectAttackDamage() {
        return this.attackDamage;
    }

    public void setAttackDamage(float baseDamage, float damageMultiplier) {
        this.attackDamage = this.material.func_200929_c() * damageMultiplier + baseDamage - 1.0f;
    }

    public void setAttackSpeed(double speed) {
        this.attackSpeed = speed;
    }

    public ThrowingWeaponEntity createThrowingWeaponEntity(World worldIn, PlayerEntity player, ItemStack stack, int charge) {
        return new ThrowingWeaponEntity(ModEntities.THROWING_WEAPON, (LivingEntity)player, worldIn);
    }

    protected SoundEvent getThrowSound() {
        return ModSounds.THROWING_KNIFE_THROW;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public HudElementCrosshair createHudElement() {
        return new HudElementCrosshairThrowingWeapon();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getType() {
        return HudElementCrosshairThrowingWeapon.TYPE;
    }
}

