/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.network;

import com.oblivioussp.spartanweaponry.api.IWeaponTraitContainer;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.util.Log;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketLongReachAttack {
    private int entityID;

    public PacketLongReachAttack(int entityID) {
        this.entityID = entityID;
    }

    public static void encode(PacketLongReachAttack packet, PacketBuffer buf) {
        buf.writeInt(packet.entityID);
    }

    public static PacketLongReachAttack decode(PacketBuffer buf) {
        return new PacketLongReachAttack(buf.readInt());
    }

    public static class Handler {
        public static void handle(PacketLongReachAttack packet, Supplier<NetworkEvent.Context> ctx) {
            if (packet == null) {
                return;
            }
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                Entity target = player.field_70170_p.func_73045_a(packet.entityID);
                if (player == null || target == null) {
                    return;
                }
                Log.debug("Victim of attack: " + target.func_145748_c_().toString());
                ItemStack weapon = player.func_184614_ca();
                if (weapon.func_190926_b()) {
                    return;
                }
                if (weapon.func_77973_b() instanceof IWeaponTraitContainer) {
                    double distanceSquared;
                    float reach;
                    double reachSquared;
                    WeaponTrait reachTrait = ((IWeaponTraitContainer)weapon.func_77973_b()).getFirstWeaponTraitWithType("reach");
                    if (reachTrait != null && (reachSquared = (double)((reach = reachTrait.getMagnitude()) * reach)) >= (distanceSquared = player.func_70068_e(target))) {
                        player.func_71059_n(target);
                        Log.debug("Attacking victim!");
                    }
                    player.func_184609_a(Hand.MAIN_HAND);
                    player.func_184821_cY();
                }
            });
        }
    }
}

