/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api;

import com.oblivioussp.spartanweaponry.api.WeaponTraits;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemTier;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;

public class WeaponMaterial
implements IItemTier {
    public static final WeaponMaterial WOOD = new WeaponMaterial("wood", (IItemTier)ItemTier.WOOD, ItemTags.field_199905_b.func_199886_b());
    public static final WeaponMaterial STONE = new WeaponMaterial("stone", (IItemTier)ItemTier.STONE, new ResourceLocation("forge:cobblestone"));
    public static final WeaponMaterial IRON = new WeaponMaterial("iron", (IItemTier)ItemTier.IRON, new ResourceLocation("forge:ingots/iron"));
    public static final WeaponMaterial GOLD = new WeaponMaterial("gold", (IItemTier)ItemTier.GOLD, new ResourceLocation("forge:ingots/gold"));
    public static final WeaponMaterial DIAMOND = new WeaponMaterial("diamond", (IItemTier)ItemTier.DIAMOND, new ResourceLocation("forge:gems/diamond"));
    public static final WeaponMaterial LEATHER = new WeaponMaterial("leather", 0, 128, 2.0f, 0.0f, 5, new ResourceLocation("forge:leather"));
    public static final WeaponMaterial COPPER = new WeaponMaterial("copper", "spartanweaponry", 16744512, 16760986, 1, 200, 5.0f, 1.5f, 8, new ResourceLocation("forge:ingots/copper"), new WeaponTrait[0]);
    public static final WeaponMaterial TIN = new WeaponMaterial("tin", "spartanweaponry", 12500696, 0xD2D2FF, 1, 180, 5.25f, 1.75f, 6, new ResourceLocation("forge:ingots/tin"), new WeaponTrait[0]);
    public static final WeaponMaterial BRONZE = new WeaponMaterial("bronze", "spartanweaponry", 11758858, 13407798, 2, 320, 5.75f, 2.0f, 12, new ResourceLocation("forge:ingots/bronze"), new WeaponTrait[0]);
    public static final WeaponMaterial STEEL = new WeaponMaterial("steel", "spartanweaponry", 0x858585, 0xBEBEBE, 2, 480, 6.5f, 2.5f, 14, new ResourceLocation("forge:ingots/steel"), new WeaponTrait[0]);
    public static final WeaponMaterial SILVER = new WeaponMaterial("silver", "spartanweaponry", 13487600, 0xFFFFFF, 1, 48, 5.0f, 1.5f, 16, new ResourceLocation("forge:ingots/silver"), WeaponTraits.EXTRA_DAMAGE_50P_UNDEAD);
    public static final WeaponMaterial INVAR = new WeaponMaterial("invar", "spartanweaponry", 11450027, 14607328, 2, 440, 6.0f, 2.2f, 12, new ResourceLocation("forge:ingots/invar"), new WeaponTrait[0]);
    public static final WeaponMaterial PLATINUM = new WeaponMaterial("platinum", "spartanweaponry", 6937328, 11200511, 3, 1024, 4.0f, 3.5f, 18, new ResourceLocation("forge:ingots/platinum"), new WeaponTrait[0]);
    public static final WeaponMaterial ELECTRUM = new WeaponMaterial("electrum", "spartanweaponry", 14007119, 0xFFFF95, 1, 180, 3.5f, 2.0f, 8, new ResourceLocation("forge:ingots/electrum"), new WeaponTrait[0]);
    public static final WeaponMaterial NICKEL = new WeaponMaterial("nickel", "spartanweaponry", 14405525, 16250827, 1, 200, 4.5f, 2.0f, 6, new ResourceLocation("forge:ingots/nickel"), new WeaponTrait[0]);
    public static final WeaponMaterial LEAD = new WeaponMaterial("lead", "spartanweaponry", 5726589, 9150162, 1, 240, 4.5f, 2.0f, 5, new ResourceLocation("forge:ingots/lead"), new WeaponTrait[0]);
    private final int harvestLevel;
    private int maxUses;
    private final float efficiency;
    private float baseDamage;
    private final int enchantability;
    private final LazyValue<Ingredient> repairMaterial;
    private final ResourceLocation tagName;
    private String name;
    private String modId = "spartanweaponry";
    private int colourPrimary = 0x7F7F7F;
    private int colourSecondary = 0xFFFFFF;
    protected List<WeaponTrait> traits = new ArrayList<WeaponTrait>();

    public WeaponMaterial(String unlocName, String modId, int colourPrimary, int colourSecondary, int harvestLevel, int maxUses, float efficiency, float baseDamage, int enchantability, ResourceLocation tagName, WeaponTrait ... traits) {
        this.name = unlocName;
        this.modId = modId;
        this.colourPrimary = colourPrimary;
        this.colourSecondary = colourSecondary;
        this.harvestLevel = harvestLevel;
        this.maxUses = maxUses;
        this.efficiency = efficiency;
        this.baseDamage = baseDamage;
        this.enchantability = enchantability;
        this.tagName = tagName;
        this.repairMaterial = new LazyValue(() -> Ingredient.func_199805_a((Tag)ItemTags.func_199903_a().func_199910_a(tagName)));
        this.traits = Arrays.asList(traits);
    }

    public WeaponMaterial(String unlocName, int harvestLevel, int maxUses, float efficiency, float baseDamage, int enchantability, ResourceLocation tagName) {
        this(unlocName, "spartanweaponry", 0x7F7F7F, 0xFFFFFF, harvestLevel, maxUses, efficiency, baseDamage, enchantability, tagName, new WeaponTrait[0]);
    }

    public WeaponMaterial(String unlocName, String modId, IItemTier itemTier, ResourceLocation tagName) {
        this(unlocName, modId, 0x7F7F7F, 0xFFFFFF, itemTier.func_200925_d(), itemTier.func_200926_a(), itemTier.func_200928_b(), itemTier.func_200929_c(), itemTier.func_200927_e(), tagName, new WeaponTrait[0]);
    }

    public WeaponMaterial(String unlocName, IItemTier itemTier, ResourceLocation tagName) {
        this(unlocName, "spartanweaponry", itemTier, tagName);
    }

    public String getMaterialName() {
        return this.name;
    }

    public int getPrimaryColour() {
        return this.colourPrimary;
    }

    public int getSecondaryColour() {
        return this.colourSecondary;
    }

    public String getModId() {
        return this.modId;
    }

    public int func_200926_a() {
        return this.maxUses;
    }

    public void setMaxUses(int maxUses) {
        this.maxUses = maxUses;
    }

    public float func_200928_b() {
        return this.efficiency;
    }

    public float func_200929_c() {
        return this.baseDamage;
    }

    public void setAttackDamage(float baseDamage) {
        this.baseDamage = baseDamage;
    }

    public int func_200925_d() {
        return this.harvestLevel;
    }

    public int func_200927_e() {
        return this.enchantability;
    }

    public Ingredient func_200924_f() {
        return (Ingredient)this.repairMaterial.func_179281_c();
    }

    public boolean hasAnyWeaponTrait() {
        return !this.traits.isEmpty();
    }

    public boolean hasWeaponTrait(WeaponTrait trait) {
        return this.traits.contains(trait);
    }

    public WeaponTrait getFirstWeaponTraitWithType(String type) {
        for (WeaponTrait trait : this.traits) {
            if (trait.getType() != type) continue;
            return trait;
        }
        return null;
    }

    public List<WeaponTrait> getAllWeaponPropertiesWithType(String type) {
        ArrayList<WeaponTrait> result = new ArrayList<WeaponTrait>();
        for (WeaponTrait trait : this.traits) {
            if (trait.getType() != type) continue;
            result.add(trait);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public List<WeaponTrait> getAllWeaponTraits() {
        return this.traits;
    }

    public ResourceLocation getTagName() {
        return this.tagName;
    }
}

