/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api.trait;

import com.oblivioussp.spartanweaponry.api.trait.ITraitCallback;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class WeaponTrait {
    public static final TextFormatting[] DESCRIPTION_COLOUR = new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC};
    protected String type;
    protected String modId;
    protected int level;
    protected float magnitude;
    protected TraitQuality quality;

    public WeaponTrait(String type, String modId, int level, float magnitude, TraitQuality quality) {
        this.type = type;
        this.modId = modId;
        this.level = level;
        this.magnitude = magnitude;
        this.quality = quality;
    }

    public WeaponTrait(String type, String modId, int level, TraitQuality quality) {
        this(type, modId, level, 0.0f, quality);
    }

    public WeaponTrait(String type, String modId, float magnitude, TraitQuality quality) {
        this(type, modId, 0, magnitude, quality);
    }

    public WeaponTrait(String type, String modId, TraitQuality quality) {
        this(type, modId, 0, quality);
    }

    public String toString() {
        return String.format("WeaponTrait{Type: %s:%s - Level: %d - Magnitude: %f}", this.modId, this.type, this.level, Float.valueOf(this.magnitude));
    }

    public String getType() {
        return this.type;
    }

    public float getMagnitude() {
        return this.magnitude;
    }

    public void setMagnitude(float value) {
        this.magnitude = value;
    }

    public ITraitCallback getCallback() {
        return null;
    }

    public final void addTooltip(ItemStack stack, List<ITextComponent> tooltip, boolean isShiftPressed) {
        this.addTooltipTitle(stack, tooltip);
        if (isShiftPressed && I18n.func_188566_a((String)String.format("tooltip.%s.trait.%s.desc", "spartanweaponry", this.type))) {
            this.addTooltipDescription(stack, tooltip);
        }
    }

    protected void addTooltipTitle(ItemStack stack, List<ITextComponent> tooltip) {
        if (this.level == 0) {
            tooltip.add(new TranslationTextComponent(String.format("tooltip.%s.trait.%s", "spartanweaponry", this.type), new Object[0]).func_211708_a(this.quality.getFormatting()));
        } else {
            tooltip.add(new TranslationTextComponent(String.format("tooltip.%s.trait.%s", "spartanweaponry", this.type), new Object[]{I18n.func_135052_a((String)("enchantment.level." + Integer.toString(this.level)), (Object[])new Object[0])}).func_211708_a(this.quality.getFormatting()));
        }
    }

    protected void addTooltipDescription(ItemStack stack, List<ITextComponent> tooltip) {
        tooltip.add(new TranslationTextComponent(String.format("tooltip.%s.trait.%s.desc", "spartanweaponry", this.type), new Object[0]).func_211709_a(DESCRIPTION_COLOUR));
    }

    public static enum TraitQuality {
        POSITIVE(TextFormatting.GREEN),
        NEUTRAL(TextFormatting.YELLOW),
        NEGATIVE(TextFormatting.RED);

        private TextFormatting formatting;

        private TraitQuality(TextFormatting formatting) {
            this.formatting = formatting;
        }

        public TextFormatting getFormatting() {
            return this.formatting;
        }
    }
}

