/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.client;

import com.oblivioussp.spartanweaponry.client.gui.container.QuiverArrowScreen;
import com.oblivioussp.spartanweaponry.client.gui.container.QuiverBoltScreen;
import com.oblivioussp.spartanweaponry.client.render.entity.ArrowBaseRenderFactory;
import com.oblivioussp.spartanweaponry.client.render.entity.BoltRenderFactory;
import com.oblivioussp.spartanweaponry.client.render.entity.BoomerangRenderFactory;
import com.oblivioussp.spartanweaponry.client.render.entity.JavelinRenderFactory;
import com.oblivioussp.spartanweaponry.client.render.entity.SimpleArrowRenderFactory;
import com.oblivioussp.spartanweaponry.client.render.entity.ThrowingWeaponRenderFactory;
import com.oblivioussp.spartanweaponry.client.render.entity.TomahawkRenderFactory;
import com.oblivioussp.spartanweaponry.entity.projectile.DynamiteEntity;
import com.oblivioussp.spartanweaponry.init.ModContainers;
import com.oblivioussp.spartanweaponry.init.ModEntities;
import com.oblivioussp.spartanweaponry.init.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

@OnlyIn(value=Dist.CLIENT)
public class ClientHelper {
    @OnlyIn(value=Dist.CLIENT)
    public static void registerItemRenders() {
        ClientHelper.registerTippedProjectile((Item)ModItems.tippedArrowWood);
        ClientHelper.registerTippedProjectile((Item)ModItems.tippedArrowIron);
        ClientHelper.registerTippedProjectile((Item)ModItems.tippedArrowDiamond);
        ClientHelper.registerTippedProjectile(ModItems.tippedBolt);
        ClientHelper.registerTippedProjectile(ModItems.tippedBoltDiamond);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerTippedProjectile(Item arrow) {
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, idx) -> idx == 1 ? PotionUtils.func_190932_c((ItemStack)stack) : 0xFFFFFF, new IItemProvider[]{arrow});
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerEntityRenders() {
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.ARROW_SW, new ArrowBaseRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.ARROW_EXPLOSIVE, new SimpleArrowRenderFactory("textures/entity/projectiles/arrow_explosive.png"));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.BOLT, new BoltRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.BOLT_SPECTRAL, new BoltRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.THROWING_WEAPON, new ThrowingWeaponRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.TOMAHAWK, new TomahawkRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.JAVELIN, new JavelinRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.BOOMERANG, (IRenderFactory)new BoomerangRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.DYNAMITE, (IRenderFactory)new IRenderFactory<DynamiteEntity>(){

            public EntityRenderer<? super DynamiteEntity> createRenderFor(EntityRendererManager manager) {
                return new SpriteRenderer(manager, Minecraft.func_71410_x().func_175599_af());
            }
        });
    }

    public static void registerScreens() {
        ScreenManager.func_216911_a(ModContainers.QUIVER_ARROW, QuiverArrowScreen::new);
        ScreenManager.func_216911_a(ModContainers.QUIVER_BOLT, QuiverBoltScreen::new);
    }
}

