/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.oblivioussp.spartanweaponry.capability.QuiverCapabilityProvider;
import com.oblivioussp.spartanweaponry.init.ModItems;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class QuiverBaseItem
extends Item {
    public static final String NBT_SIZE = "size";
    public static final String NBT_CURRENT_AMMO = "currentAmmo";
    public static final String NBT_TOTAL_AMMO = "totalAmmo";
    public static final String NBT_AMMO_COLLECT = "ammoCollect";
    public static final String NBT_CLIENT_INVENTORY = "ClientInventory";
    public static final NonNullSupplier<IllegalArgumentException> CAPABILITY_EXCEPTION = () -> new IllegalArgumentException("Capability must not be null!");
    protected int ammoSlots = 4;

    public QuiverBaseItem(String regName, int inventorySize) {
        super(new Item.Properties().func_200916_a(ModItems.GROUP_SW).func_200917_a(1));
        this.setRegistryName("spartanweaponry", regName);
        this.func_185043_a(new ResourceLocation("arrow"), new IItemPropertyGetter(){

            public float call(ItemStack stack, World worldIn, LivingEntity entityIn) {
                return QuiverBaseItem.this.getAmmoCount(stack);
            }
        });
        this.ammoSlots = inventorySize;
    }

    protected int getAmmoCount(ItemStack stack) {
        int ammo = 0;
        ListNBT list = null;
        list = stack.func_196082_o().func_150295_c(NBT_CLIENT_INVENTORY, 10);
        if (list == null) {
            return 0;
        }
        for (int i = 0; i < list.size(); ++i) {
            ItemStack item = ItemStack.func_199557_a((CompoundNBT)list.func_150305_b(i));
            if (item.func_190926_b()) continue;
            ++ammo;
        }
        if (this.ammoSlots == 9) {
            if (ammo > 5) {
                ammo = 5;
            }
        } else if (ammo > 3) {
            ammo = 3;
        }
        return ammo;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new QuiverCapabilityProvider(stack, this.ammoSlots);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K) {
            if (!playerIn.func_213453_ef()) {
                IItemHandler handler = (IItemHandler)heldItem.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(CAPABILITY_EXCEPTION);
                if (handler instanceof ItemStackHandler) {
                    this.openGui(heldItem, playerIn, handIn);
                    return ActionResult.func_226248_a_((Object)heldItem);
                }
                return ActionResult.func_226251_d_((Object)heldItem);
            }
            boolean ammoCollect = !heldItem.func_196082_o().func_74767_n(NBT_AMMO_COLLECT);
            heldItem.func_77978_p().func_74757_a(NBT_AMMO_COLLECT, ammoCollect);
            String collectStatus = ammoCollect ? "enabled" : "disabled";
            TextFormatting collectColour = ammoCollect ? TextFormatting.GREEN : TextFormatting.RED;
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("message.spartanweaponry.ammo_collect_toggle", new Object[]{collectColour + I18n.func_135052_a((String)("tooltip.spartanweaponry." + collectStatus), (Object[])new Object[0])}), true);
            return ActionResult.func_226251_d_((Object)heldItem);
        }
        return ActionResult.func_226250_c_((Object)heldItem);
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(CAPABILITY_EXCEPTION);
        INBT capTag = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.getStorage().writeNBT(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)handler, null);
        CompoundNBT tag = super.getShareTag(stack);
        if (tag == null) {
            tag = new CompoundNBT();
        }
        if (capTag != null) {
            tag.func_218657_a(NBT_CLIENT_INVENTORY, capTag);
        }
        return tag;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        boolean ammoCollect;
        int itemCount = 0;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(new TranslationTextComponent("tooltip.spartanweaponry.quiver_capacity", new Object[]{this.ammoSlots}).func_211708_a(TextFormatting.GRAY));
        tooltip.add(new TranslationTextComponent("tooltip.spartanweaponry.quiver_contains", new Object[0]).func_211708_a(TextFormatting.GRAY));
        ListNBT list = stack.func_196082_o().func_150295_c(NBT_CLIENT_INVENTORY, 10);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack slotStack = ItemStack.func_199557_a((CompoundNBT)list.func_150305_b(i));
            if (slotStack.func_190926_b()) continue;
            if (itemCount < 2 || Screen.hasShiftDown()) {
                tooltip.add(new TranslationTextComponent("tooltip.spartanweaponry.quiver_ammo", new Object[]{slotStack.func_190916_E(), slotStack.func_200301_q().func_150254_d()}).func_211708_a(TextFormatting.GRAY));
            } else if (itemCount == 2) {
                tooltip.add(new TranslationTextComponent("tooltip.spartanweaponry.quiver_show_contents", new Object[]{TextFormatting.AQUA + "SHIFT" + TextFormatting.DARK_GRAY}).func_211708_a(TextFormatting.DARK_GRAY));
            }
            ++itemCount;
        }
        if (itemCount == 0) {
            tooltip.add(new TranslationTextComponent("tooltip.spartanweaponry.quiver_none", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
        String collectStatus = (ammoCollect = stack.func_77978_p().func_74767_n(NBT_AMMO_COLLECT)) ? "enabled" : "disabled";
        TextFormatting statusColour = ammoCollect ? TextFormatting.GREEN : TextFormatting.RED;
        tooltip.add(new TranslationTextComponent("tooltip.spartanweaponry.quiver_collect_status", new Object[]{statusColour + I18n.func_135052_a((String)("tooltip.spartanweaponry." + collectStatus), (Object[])new Object[0])}).func_211708_a(TextFormatting.GRAY));
    }

    protected abstract void openGui(ItemStack var1, PlayerEntity var2, Hand var3);

    public abstract boolean isAmmoValid(ItemStack var1, ItemStack var2);
}

