/*
 * Decompiled with CFR 0.152.
 */
package stalkermod;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import stalkermod.Stalkermod;
import stalkermod.StalkermodVariables;
import stalkermod.gui.GuiRespawngui;

public class ElementsStalkermod
implements IFuelHandler,
IWorldGenerator {
    public final List<ModElement> elements = new ArrayList<ModElement>();
    public final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    public final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    public final List<Supplier<Biome>> biomes = new ArrayList<Supplier<Biome>>();
    public final List<Supplier<EntityEntry>> entities = new ArrayList<Supplier<EntityEntry>>();
    public final List<Supplier<Potion>> potions = new ArrayList<Supplier<Potion>>();
    public static Map<ResourceLocation, SoundEvent> sounds = new HashMap<ResourceLocation, SoundEvent>();
    private int messageID = 0;

    public ElementsStalkermod() {
        sounds.put(new ResourceLocation("stalkermod", "trampolineamb"), new SoundEvent(new ResourceLocation("stalkermod", "trampolineamb")));
        sounds.put(new ResourceLocation("stalkermod", "trampolinehitbig"), new SoundEvent(new ResourceLocation("stalkermod", "trampolinehitbig")));
        sounds.put(new ResourceLocation("stalkermod", "trampolinehitsmall"), new SoundEvent(new ResourceLocation("stalkermod", "trampolinehitsmall")));
        sounds.put(new ResourceLocation("stalkermod", "funnelamb"), new SoundEvent(new ResourceLocation("stalkermod", "funnelamb")));
        sounds.put(new ResourceLocation("stalkermod", "funnelhit"), new SoundEvent(new ResourceLocation("stalkermod", "funnelhit")));
        sounds.put(new ResourceLocation("stalkermod", "electroamb"), new SoundEvent(new ResourceLocation("stalkermod", "electroamb")));
        sounds.put(new ResourceLocation("stalkermod", "electroactive"), new SoundEvent(new ResourceLocation("stalkermod", "electroactive")));
        sounds.put(new ResourceLocation("stalkermod", "electrohit"), new SoundEvent(new ResourceLocation("stalkermod", "electrohit")));
        sounds.put(new ResourceLocation("stalkermod", "deadbodyfunnel"), new SoundEvent(new ResourceLocation("stalkermod", "deadbodyfunnel")));
        sounds.put(new ResourceLocation("stalkermod", "boltchecktrampoline"), new SoundEvent(new ResourceLocation("stalkermod", "boltchecktrampoline")));
        sounds.put(new ResourceLocation("stalkermod", "boltcheckfunnel"), new SoundEvent(new ResourceLocation("stalkermod", "boltcheckfunnel")));
        sounds.put(new ResourceLocation("stalkermod", "boltcheckeletro1"), new SoundEvent(new ResourceLocation("stalkermod", "boltcheckeletro1")));
        sounds.put(new ResourceLocation("stalkermod", "boltcheckeletro2"), new SoundEvent(new ResourceLocation("stalkermod", "boltcheckeletro2")));
        sounds.put(new ResourceLocation("stalkermod", "kisselhit1"), new SoundEvent(new ResourceLocation("stalkermod", "kisselhit1")));
        sounds.put(new ResourceLocation("stalkermod", "kisselhit2"), new SoundEvent(new ResourceLocation("stalkermod", "kisselhit2")));
        sounds.put(new ResourceLocation("stalkermod", "kisselamb"), new SoundEvent(new ResourceLocation("stalkermod", "kisselamb")));
        sounds.put(new ResourceLocation("stalkermod", "fryingamb"), new SoundEvent(new ResourceLocation("stalkermod", "fryingamb")));
        sounds.put(new ResourceLocation("stalkermod", "fryingactive"), new SoundEvent(new ResourceLocation("stalkermod", "fryingactive")));
        sounds.put(new ResourceLocation("stalkermod", "burningfluffhit"), new SoundEvent(new ResourceLocation("stalkermod", "burningfluffhit")));
        sounds.put(new ResourceLocation("stalkermod", "boltchecktrampolinebig"), new SoundEvent(new ResourceLocation("stalkermod", "boltchecktrampolinebig")));
        sounds.put(new ResourceLocation("stalkermod", "pmreload"), new SoundEvent(new ResourceLocation("stalkermod", "pmreload")));
        sounds.put(new ResourceLocation("stalkermod", "pmshot"), new SoundEvent(new ResourceLocation("stalkermod", "pmshot")));
        sounds.put(new ResourceLocation("stalkermod", "pmdraw"), new SoundEvent(new ResourceLocation("stalkermod", "pmdraw")));
        sounds.put(new ResourceLocation("stalkermod", "pmreloadnoammo"), new SoundEvent(new ResourceLocation("stalkermod", "pmreloadnoammo")));
        sounds.put(new ResourceLocation("stalkermod", "noammopistol"), new SoundEvent(new ResourceLocation("stalkermod", "noammopistol")));
        sounds.put(new ResourceLocation("stalkermod", "pb-1sshot"), new SoundEvent(new ResourceLocation("stalkermod", "pb-1sshot")));
        sounds.put(new ResourceLocation("stalkermod", "fora-12shot"), new SoundEvent(new ResourceLocation("stalkermod", "fora-12shot")));
        sounds.put(new ResourceLocation("stalkermod", "hpss-1mshot"), new SoundEvent(new ResourceLocation("stalkermod", "hpss-1mshot")));
        sounds.put(new ResourceLocation("stalkermod", "martashot"), new SoundEvent(new ResourceLocation("stalkermod", "martashot")));
        sounds.put(new ResourceLocation("stalkermod", "blackhawkshot"), new SoundEvent(new ResourceLocation("stalkermod", "blackhawkshot")));
        sounds.put(new ResourceLocation("stalkermod", "uspshot"), new SoundEvent(new ResourceLocation("stalkermod", "uspshot")));
        sounds.put(new ResourceLocation("stalkermod", "volkershot"), new SoundEvent(new ResourceLocation("stalkermod", "volkershot")));
        sounds.put(new ResourceLocation("stalkermod", "sip-1shot"), new SoundEvent(new ResourceLocation("stalkermod", "sip-1shot")));
        sounds.put(new ResourceLocation("stalkermod", "colt1911shot"), new SoundEvent(new ResourceLocation("stalkermod", "colt1911shot")));
        sounds.put(new ResourceLocation("stalkermod", "sawn-offshotgunreload"), new SoundEvent(new ResourceLocation("stalkermod", "sawn-offshotgunreload")));
        sounds.put(new ResourceLocation("stalkermod", "sawn-offshotgunshot"), new SoundEvent(new ResourceLocation("stalkermod", "sawn-offshotgunshot")));
        sounds.put(new ResourceLocation("stalkermod", "bm16shot"), new SoundEvent(new ResourceLocation("stalkermod", "bm16shot")));
        sounds.put(new ResourceLocation("stalkermod", "bm16reload"), new SoundEvent(new ResourceLocation("stalkermod", "bm16reload")));
        sounds.put(new ResourceLocation("stalkermod", "huntingweaponreload"), new SoundEvent(new ResourceLocation("stalkermod", "huntingweaponreload")));
        sounds.put(new ResourceLocation("stalkermod", "huntingweaponshot"), new SoundEvent(new ResourceLocation("stalkermod", "huntingweaponshot")));
        sounds.put(new ResourceLocation("stalkermod", "spas12shot"), new SoundEvent(new ResourceLocation("stalkermod", "spas12shot")));
        sounds.put(new ResourceLocation("stalkermod", "spas12reload"), new SoundEvent(new ResourceLocation("stalkermod", "spas12reload")));
        sounds.put(new ResourceLocation("stalkermod", "sawn-offshotgunoammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "sawn-offshotgunoammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "bm16noammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "bm16noammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "huntingweaponnoammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "huntingweaponnoammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "spas12noammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "spas12noammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "bm16noammo"), new SoundEvent(new ResourceLocation("stalkermod", "bm16noammo")));
        sounds.put(new ResourceLocation("stalkermod", "spasnoammo"), new SoundEvent(new ResourceLocation("stalkermod", "spasnoammo")));
        sounds.put(new ResourceLocation("stalkermod", "hk53shot"), new SoundEvent(new ResourceLocation("stalkermod", "hk53shot")));
        sounds.put(new ResourceLocation("stalkermod", "hk53reload"), new SoundEvent(new ResourceLocation("stalkermod", "hk53reload")));
        sounds.put(new ResourceLocation("stalkermod", "hk53noammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "hk53noammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "p90shot"), new SoundEvent(new ResourceLocation("stalkermod", "p90shot")));
        sounds.put(new ResourceLocation("stalkermod", "p90reload"), new SoundEvent(new ResourceLocation("stalkermod", "p90reload")));
        sounds.put(new ResourceLocation("stalkermod", "p90noammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "p90noammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "gaduka-5shot"), new SoundEvent(new ResourceLocation("stalkermod", "gaduka-5shot")));
        sounds.put(new ResourceLocation("stalkermod", "gaduka-5reload"), new SoundEvent(new ResourceLocation("stalkermod", "gaduka-5reload")));
        sounds.put(new ResourceLocation("stalkermod", "gaduka-5noammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "gaduka-5noammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "apsshot"), new SoundEvent(new ResourceLocation("stalkermod", "apsshot")));
        sounds.put(new ResourceLocation("stalkermod", "apsreload"), new SoundEvent(new ResourceLocation("stalkermod", "apsreload")));
        sounds.put(new ResourceLocation("stalkermod", "apsnoammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "apsnoammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "drawweapon2"), new SoundEvent(new ResourceLocation("stalkermod", "drawweapon2")));
        sounds.put(new ResourceLocation("stalkermod", "drawweapon3"), new SoundEvent(new ResourceLocation("stalkermod", "drawweapon3")));
        sounds.put(new ResourceLocation("stalkermod", "noammo1"), new SoundEvent(new ResourceLocation("stalkermod", "noammo1")));
        sounds.put(new ResourceLocation("stalkermod", "noammo2"), new SoundEvent(new ResourceLocation("stalkermod", "noammo2")));
        sounds.put(new ResourceLocation("stalkermod", "drawweapondown"), new SoundEvent(new ResourceLocation("stalkermod", "drawweapondown")));
        sounds.put(new ResourceLocation("stalkermod", "chaser13shot"), new SoundEvent(new ResourceLocation("stalkermod", "chaser13shot")));
        sounds.put(new ResourceLocation("stalkermod", "akm74s"), new SoundEvent(new ResourceLocation("stalkermod", "akm74s")));
        sounds.put(new ResourceLocation("stalkermod", "akm74sreload"), new SoundEvent(new ResourceLocation("stalkermod", "akm74sreload")));
        sounds.put(new ResourceLocation("stalkermod", "akm74snoammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "akm74snoammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "akmshot"), new SoundEvent(new ResourceLocation("stalkermod", "akmshot")));
        sounds.put(new ResourceLocation("stalkermod", "akmreload"), new SoundEvent(new ResourceLocation("stalkermod", "akmreload")));
        sounds.put(new ResourceLocation("stalkermod", "akmnoammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "akmnoammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "ak74shot"), new SoundEvent(new ResourceLocation("stalkermod", "ak74shot")));
        sounds.put(new ResourceLocation("stalkermod", "ak74reload"), new SoundEvent(new ResourceLocation("stalkermod", "ak74reload")));
        sounds.put(new ResourceLocation("stalkermod", "ak74noammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "ak74noammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "abakanshot"), new SoundEvent(new ResourceLocation("stalkermod", "abakanshot")));
        sounds.put(new ResourceLocation("stalkermod", "abakanreload"), new SoundEvent(new ResourceLocation("stalkermod", "abakanreload")));
        sounds.put(new ResourceLocation("stalkermod", "abakannoammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "abakannoammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "blinddogidle"), new SoundEvent(new ResourceLocation("stalkermod", "blinddogidle")));
        sounds.put(new ResourceLocation("stalkermod", "blinddoghurt"), new SoundEvent(new ResourceLocation("stalkermod", "blinddoghurt")));
        sounds.put(new ResourceLocation("stalkermod", "blinddogdie"), new SoundEvent(new ResourceLocation("stalkermod", "blinddogdie")));
        sounds.put(new ResourceLocation("stalkermod", "gromc13noammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "gromc13noammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "vsk94noammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "vsk94noammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "salavinanoammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "salavinanoammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "vssnoammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "vssnoammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "l85noammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "l85noammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "gromc13shot"), new SoundEvent(new ResourceLocation("stalkermod", "gromc13shot")));
        sounds.put(new ResourceLocation("stalkermod", "gromc13reload"), new SoundEvent(new ResourceLocation("stalkermod", "gromc13reload")));
        sounds.put(new ResourceLocation("stalkermod", "vsk94shot"), new SoundEvent(new ResourceLocation("stalkermod", "vsk94shot")));
        sounds.put(new ResourceLocation("stalkermod", "vsk94reload"), new SoundEvent(new ResourceLocation("stalkermod", "vsk94reload")));
        sounds.put(new ResourceLocation("stalkermod", "salavinashot"), new SoundEvent(new ResourceLocation("stalkermod", "salavinashot")));
        sounds.put(new ResourceLocation("stalkermod", "salavinareload"), new SoundEvent(new ResourceLocation("stalkermod", "salavinareload")));
        sounds.put(new ResourceLocation("stalkermod", "vssshot"), new SoundEvent(new ResourceLocation("stalkermod", "vssshot")));
        sounds.put(new ResourceLocation("stalkermod", "vssreload"), new SoundEvent(new ResourceLocation("stalkermod", "vssreload")));
        sounds.put(new ResourceLocation("stalkermod", "l85shot"), new SoundEvent(new ResourceLocation("stalkermod", "l85shot")));
        sounds.put(new ResourceLocation("stalkermod", "l85reload"), new SoundEvent(new ResourceLocation("stalkermod", "l85reload")));
        sounds.put(new ResourceLocation("stalkermod", "scopein"), new SoundEvent(new ResourceLocation("stalkermod", "scopein")));
        sounds.put(new ResourceLocation("stalkermod", "scopeout"), new SoundEvent(new ResourceLocation("stalkermod", "scopeout")));
        sounds.put(new ResourceLocation("stalkermod", "drawweapon1"), new SoundEvent(new ResourceLocation("stalkermod", "drawweapon1")));
        sounds.put(new ResourceLocation("stalkermod", "drawweapon1down"), new SoundEvent(new ResourceLocation("stalkermod", "drawweapon1down")));
        sounds.put(new ResourceLocation("stalkermod", "eatfood"), new SoundEvent(new ResourceLocation("stalkermod", "eatfood")));
        sounds.put(new ResourceLocation("stalkermod", "usebottledrink"), new SoundEvent(new ResourceLocation("stalkermod", "usebottledrink")));
        sounds.put(new ResourceLocation("stalkermod", "usebandage"), new SoundEvent(new ResourceLocation("stalkermod", "usebandage")));
        sounds.put(new ResourceLocation("stalkermod", "usemedkit"), new SoundEvent(new ResourceLocation("stalkermod", "usemedkit")));
        sounds.put(new ResourceLocation("stalkermod", "useantirad"), new SoundEvent(new ResourceLocation("stalkermod", "useantirad")));
        sounds.put(new ResourceLocation("stalkermod", "knifeswep"), new SoundEvent(new ResourceLocation("stalkermod", "knifeswep")));
        sounds.put(new ResourceLocation("stalkermod", "psyemittingamb"), new SoundEvent(new ResourceLocation("stalkermod", "psyemittingamb")));
        sounds.put(new ResourceLocation("stalkermod", "staminaoff"), new SoundEvent(new ResourceLocation("stalkermod", "staminaoff")));
        sounds.put(new ResourceLocation("stalkermod", "eatfood2"), new SoundEvent(new ResourceLocation("stalkermod", "eatfood2")));
        sounds.put(new ResourceLocation("stalkermod", "eatcannedfood"), new SoundEvent(new ResourceLocation("stalkermod", "eatcannedfood")));
        sounds.put(new ResourceLocation("stalkermod", "useenergeticbottle"), new SoundEvent(new ResourceLocation("stalkermod", "useenergeticbottle")));
        sounds.put(new ResourceLocation("stalkermod", "usevodkabottle"), new SoundEvent(new ResourceLocation("stalkermod", "usevodkabottle")));
        sounds.put(new ResourceLocation("stalkermod", "ejectionmsg"), new SoundEvent(new ResourceLocation("stalkermod", "ejectionmsg")));
        sounds.put(new ResourceLocation("stalkermod", "ejectionstart"), new SoundEvent(new ResourceLocation("stalkermod", "ejectionstart")));
        sounds.put(new ResourceLocation("stalkermod", "ejectionend"), new SoundEvent(new ResourceLocation("stalkermod", "ejectionend")));
        sounds.put(new ResourceLocation("stalkermod", "ejectionactive1"), new SoundEvent(new ResourceLocation("stalkermod", "ejectionactive1")));
        sounds.put(new ResourceLocation("stalkermod", "ejectionactive2"), new SoundEvent(new ResourceLocation("stalkermod", "ejectionactive2")));
        sounds.put(new ResourceLocation("stalkermod", "ejectionamb"), new SoundEvent(new ResourceLocation("stalkermod", "ejectionamb")));
        sounds.put(new ResourceLocation("stalkermod", "openeruse"), new SoundEvent(new ResourceLocation("stalkermod", "openeruse")));
        sounds.put(new ResourceLocation("stalkermod", "usegerkulez"), new SoundEvent(new ResourceLocation("stalkermod", "usegerkulez")));
        sounds.put(new ResourceLocation("stalkermod", "guitar1"), new SoundEvent(new ResourceLocation("stalkermod", "guitar1")));
        sounds.put(new ResourceLocation("stalkermod", "guitar2"), new SoundEvent(new ResourceLocation("stalkermod", "guitar2")));
        sounds.put(new ResourceLocation("stalkermod", "guitar3"), new SoundEvent(new ResourceLocation("stalkermod", "guitar3")));
        sounds.put(new ResourceLocation("stalkermod", "guitar4"), new SoundEvent(new ResourceLocation("stalkermod", "guitar4")));
        sounds.put(new ResourceLocation("stalkermod", "guitar5"), new SoundEvent(new ResourceLocation("stalkermod", "guitar5")));
        sounds.put(new ResourceLocation("stalkermod", "guitar6"), new SoundEvent(new ResourceLocation("stalkermod", "guitar6")));
        sounds.put(new ResourceLocation("stalkermod", "guitar7"), new SoundEvent(new ResourceLocation("stalkermod", "guitar7")));
        sounds.put(new ResourceLocation("stalkermod", "guitar8"), new SoundEvent(new ResourceLocation("stalkermod", "guitar8")));
        sounds.put(new ResourceLocation("stalkermod", "guitar9"), new SoundEvent(new ResourceLocation("stalkermod", "guitar9")));
        sounds.put(new ResourceLocation("stalkermod", "trs301shot"), new SoundEvent(new ResourceLocation("stalkermod", "trs301shot")));
        sounds.put(new ResourceLocation("stalkermod", "trs301reload"), new SoundEvent(new ResourceLocation("stalkermod", "trs301reload")));
        sounds.put(new ResourceLocation("stalkermod", "trs301noammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "trs301noammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "sig5shot"), new SoundEvent(new ResourceLocation("stalkermod", "sig5shot")));
        sounds.put(new ResourceLocation("stalkermod", "sig5reload"), new SoundEvent(new ResourceLocation("stalkermod", "sig5reload")));
        sounds.put(new ResourceLocation("stalkermod", "sig5noammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "sig5noammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "g36shot"), new SoundEvent(new ResourceLocation("stalkermod", "g36shot")));
        sounds.put(new ResourceLocation("stalkermod", "g36reload"), new SoundEvent(new ResourceLocation("stalkermod", "g36reload")));
        sounds.put(new ResourceLocation("stalkermod", "g36noammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "g36noammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "fn2000shot"), new SoundEvent(new ResourceLocation("stalkermod", "fn2000shot")));
        sounds.put(new ResourceLocation("stalkermod", "fn2000reload"), new SoundEvent(new ResourceLocation("stalkermod", "fn2000reload")));
        sounds.put(new ResourceLocation("stalkermod", "fn2000noammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "fn2000noammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "gaussshot"), new SoundEvent(new ResourceLocation("stalkermod", "gaussshot")));
        sounds.put(new ResourceLocation("stalkermod", "gaussreload"), new SoundEvent(new ResourceLocation("stalkermod", "gaussreload")));
        sounds.put(new ResourceLocation("stalkermod", "gaussnoammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "gaussnoammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "harmonica1"), new SoundEvent(new ResourceLocation("stalkermod", "harmonica1")));
        sounds.put(new ResourceLocation("stalkermod", "harmonica2"), new SoundEvent(new ResourceLocation("stalkermod", "harmonica2")));
        sounds.put(new ResourceLocation("stalkermod", "harmonica3"), new SoundEvent(new ResourceLocation("stalkermod", "harmonica3")));
        sounds.put(new ResourceLocation("stalkermod", "harmonica_4"), new SoundEvent(new ResourceLocation("stalkermod", "harmonica_4")));
        sounds.put(new ResourceLocation("stalkermod", "showrespawngui"), new SoundEvent(new ResourceLocation("stalkermod", "showrespawngui")));
        sounds.put(new ResourceLocation("stalkermod", "radiationzone"), new SoundEvent(new ResourceLocation("stalkermod", "radiationzone")));
        sounds.put(new ResourceLocation("stalkermod", "gasp1"), new SoundEvent(new ResourceLocation("stalkermod", "gasp1")));
        sounds.put(new ResourceLocation("stalkermod", "gasp2"), new SoundEvent(new ResourceLocation("stalkermod", "gasp2")));
        sounds.put(new ResourceLocation("stalkermod", "throwbolt"), new SoundEvent(new ResourceLocation("stalkermod", "throwbolt")));
        sounds.put(new ResourceLocation("stalkermod", "bulletfly1"), new SoundEvent(new ResourceLocation("stalkermod", "bulletfly1")));
        sounds.put(new ResourceLocation("stalkermod", "bulletfly2"), new SoundEvent(new ResourceLocation("stalkermod", "bulletfly2")));
        sounds.put(new ResourceLocation("stalkermod", "bulletdirt1"), new SoundEvent(new ResourceLocation("stalkermod", "bulletdirt1")));
        sounds.put(new ResourceLocation("stalkermod", "bulletdirt2"), new SoundEvent(new ResourceLocation("stalkermod", "bulletdirt2")));
        sounds.put(new ResourceLocation("stalkermod", "bulletglass1"), new SoundEvent(new ResourceLocation("stalkermod", "bulletglass1")));
        sounds.put(new ResourceLocation("stalkermod", "bulletglass2"), new SoundEvent(new ResourceLocation("stalkermod", "bulletglass2")));
        sounds.put(new ResourceLocation("stalkermod", "bulletmetal1"), new SoundEvent(new ResourceLocation("stalkermod", "bulletmetal1")));
        sounds.put(new ResourceLocation("stalkermod", "bulletmetal2"), new SoundEvent(new ResourceLocation("stalkermod", "bulletmetal2")));
        sounds.put(new ResourceLocation("stalkermod", "bulletstone1"), new SoundEvent(new ResourceLocation("stalkermod", "bulletstone1")));
        sounds.put(new ResourceLocation("stalkermod", "bulletstone2"), new SoundEvent(new ResourceLocation("stalkermod", "bulletstone2")));
        sounds.put(new ResourceLocation("stalkermod", "bulletwood1"), new SoundEvent(new ResourceLocation("stalkermod", "bulletwood1")));
        sounds.put(new ResourceLocation("stalkermod", "bulletwood2"), new SoundEvent(new ResourceLocation("stalkermod", "bulletwood2")));
        sounds.put(new ResourceLocation("stalkermod", "nvon"), new SoundEvent(new ResourceLocation("stalkermod", "nvon")));
        sounds.put(new ResourceLocation("stalkermod", "nvoff"), new SoundEvent(new ResourceLocation("stalkermod", "nvoff")));
        sounds.put(new ResourceLocation("stalkermod", "minigunshot"), new SoundEvent(new ResourceLocation("stalkermod", "minigunshot")));
        sounds.put(new ResourceLocation("stalkermod", "minigunreload"), new SoundEvent(new ResourceLocation("stalkermod", "minigunreload")));
        sounds.put(new ResourceLocation("stalkermod", "minigunnoammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "minigunnoammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "akmsshot"), new SoundEvent(new ResourceLocation("stalkermod", "akmsshot")));
        sounds.put(new ResourceLocation("stalkermod", "akmsreload"), new SoundEvent(new ResourceLocation("stalkermod", "akmsreload")));
        sounds.put(new ResourceLocation("stalkermod", "akmsnoammoreload"), new SoundEvent(new ResourceLocation("stalkermod", "akmsnoammoreload")));
        sounds.put(new ResourceLocation("stalkermod", "gsh18shot"), new SoundEvent(new ResourceLocation("stalkermod", "gsh18shot")));
        sounds.put(new ResourceLocation("stalkermod", "pmmshot"), new SoundEvent(new ResourceLocation("stalkermod", "pmmshot")));
        sounds.put(new ResourceLocation("stalkermod", "drawminigun"), new SoundEvent(new ResourceLocation("stalkermod", "drawminigun")));
        sounds.put(new ResourceLocation("stalkermod", "drawminigundown"), new SoundEvent(new ResourceLocation("stalkermod", "drawminigundown")));
        sounds.put(new ResourceLocation("stalkermod", "spawnartefacrt"), new SoundEvent(new ResourceLocation("stalkermod", "spawnartefacrt")));
        sounds.put(new ResourceLocation("stalkermod", "carouselamb"), new SoundEvent(new ResourceLocation("stalkermod", "carouselamb")));
        sounds.put(new ResourceLocation("stalkermod", "carouselhit1"), new SoundEvent(new ResourceLocation("stalkermod", "carouselhit1")));
        sounds.put(new ResourceLocation("stalkermod", "carouselhit2"), new SoundEvent(new ResourceLocation("stalkermod", "carouselhit2")));
    }

    public void preInit(FMLPreInitializationEvent event) {
        try {
            for (ASMDataTable.ASMData asmData : event.getAsmData().getAll(ModElement.Tag.class.getName())) {
                Class<?> clazz = Class.forName(asmData.getClassName());
                if (clazz.getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
        this.addNetworkMessage(StalkermodVariables.WorldSavedDataSyncMessageHandler.class, StalkermodVariables.WorldSavedDataSyncMessage.class, Side.SERVER, Side.CLIENT);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (Map.Entry<ResourceLocation, SoundEvent> sound : sounds.entrySet()) {
            event.getRegistry().register(sound.getValue().setRegistryName(sound.getKey()));
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator cg, IChunkProvider cp) {
        this.elements.forEach(element -> element.generateWorld(random, chunkX * 16, chunkZ * 16, world, world.field_73011_w.getDimension(), cg, cp));
    }

    public int getBurnTime(ItemStack fuel) {
        for (ModElement element : this.elements) {
            int ret = element.addFuel(fuel);
            if (ret == 0) continue;
            return ret;
        }
        return 0;
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            StalkermodVariables.MapVariables mapdata = StalkermodVariables.MapVariables.get(event.player.field_70170_p);
            StalkermodVariables.WorldVariables worlddata = StalkermodVariables.WorldVariables.get(event.player.field_70170_p);
            if (mapdata != null) {
                Stalkermod.PACKET_HANDLER.sendTo((IMessage)new StalkermodVariables.WorldSavedDataSyncMessage(0, mapdata), (EntityPlayerMP)event.player);
            }
            if (worlddata != null) {
                Stalkermod.PACKET_HANDLER.sendTo((IMessage)new StalkermodVariables.WorldSavedDataSyncMessage(1, worlddata), (EntityPlayerMP)event.player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        StalkermodVariables.WorldVariables worlddata;
        if (!event.player.field_70170_p.field_72995_K && (worlddata = StalkermodVariables.WorldVariables.get(event.player.field_70170_p)) != null) {
            Stalkermod.PACKET_HANDLER.sendTo((IMessage)new StalkermodVariables.WorldSavedDataSyncMessage(1, worlddata), (EntityPlayerMP)event.player);
        }
    }

    public <T extends IMessage, V extends IMessage> void addNetworkMessage(Class<? extends IMessageHandler<T, V>> handler, Class<T> messageClass, Side ... sides) {
        for (Side side : sides) {
            Stalkermod.PACKET_HANDLER.registerMessage(handler, messageClass, this.messageID, side);
        }
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<Biome>> getBiomes() {
        return this.biomes;
    }

    public List<Supplier<EntityEntry>> getEntities() {
        return this.entities;
    }

    public List<Supplier<Potion>> getPotions() {
        return this.potions;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final ElementsStalkermod elements;
        protected final int sortid;

        public ModElement(ElementsStalkermod elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLInitializationEvent event) {
        }

        public void preInit(FMLPreInitializationEvent event) {
        }

        public void generateWorld(Random random, int posX, int posZ, World world, int dimID, IChunkGenerator cg, IChunkProvider cp) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        public void registerModels(ModelRegistryEvent event) {
        }

        public int addFuel(ItemStack fuel) {
            return 0;
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }

    public static class GuiHandler
    implements IGuiHandler {
        public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            if (id == GuiRespawngui.GUIID) {
                return new GuiRespawngui.GuiContainerMod(world, x, y, z, player);
            }
            return null;
        }

        public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            if (id == GuiRespawngui.GUIID) {
                return new GuiRespawngui.GuiWindow(world, x, y, z, player);
            }
            return null;
        }
    }
}

