/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.api;

import com.google.common.collect.Lists;
import gigaherz.survivalist.ConfigManager;
import gigaherz.survivalist.Survivalist;
import gigaherz.survivalist.shadow.common.OreDictionaryHelper;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class Dryable {
    public static final List<DryingRecipe> RECIPES = Lists.newArrayList();

    public static void registerStockRecipes() {
        if (ConfigManager.instance.enableLeatherTanning) {
            Dryable.registerRecipe(new ItemStack(Items.field_151116_aA), new ItemStack(Survivalist.tanned_leather), 600);
        }
        if (ConfigManager.instance.enableMeatRotting) {
            Dryable.registerRecipe(new ItemStack(Items.field_151082_bd), new ItemStack(Items.field_151078_bh), 300);
            Dryable.registerRecipe(new ItemStack(Items.field_179561_bm), new ItemStack(Items.field_151078_bh), 300);
            Dryable.registerRecipe(new ItemStack(Items.field_151147_al), new ItemStack(Items.field_151078_bh), 300);
        }
        if (ConfigManager.instance.enableJerky) {
            if (ConfigManager.instance.enableRottenDrying) {
                Dryable.registerRecipe(new ItemStack(Items.field_151078_bh), new ItemStack(Survivalist.jerky), 300);
            }
            if (ConfigManager.instance.enableMeatDrying) {
                Dryable.registerRecipe(new ItemStack(Items.field_151083_be), new ItemStack(Survivalist.jerky), 300);
                Dryable.registerRecipe(new ItemStack(Items.field_179557_bn), new ItemStack(Survivalist.jerky), 300);
                Dryable.registerRecipe(new ItemStack(Items.field_151157_am), new ItemStack(Survivalist.jerky), 300);
            }
        }
    }

    public static DryingRecipe registerRecipe(ItemStack input, ItemStack output, int time) {
        return Dryable.registerRecipe(new DryingItemRecipe(input, time, output));
    }

    public static DryingRecipe registerRecipe(String input, ItemStack output, int time) {
        return Dryable.registerRecipe(new DryingOreRecipe(input, time, output));
    }

    private static DryingRecipe registerRecipe(DryingRecipe recipe) {
        RECIPES.add(recipe);
        return recipe;
    }

    public static int getDryingTime(ItemStack stack) {
        for (DryingRecipe recipe : RECIPES) {
            if (!recipe.accepts(stack)) continue;
            return recipe.getTime();
        }
        return -1;
    }

    public static ItemStack getDryingResult(ItemStack stack) {
        for (DryingRecipe recipe : RECIPES) {
            if (!recipe.accepts(stack)) continue;
            return recipe.getOutput().func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public static class DryingOreRecipe
    extends DryingRecipe {
        private String oreName;

        public DryingOreRecipe(String oreName, int time, ItemStack right) {
            super(time, right);
            this.oreName = oreName;
        }

        public String getOreName() {
            return this.oreName;
        }

        @Override
        public boolean accepts(ItemStack stack) {
            return OreDictionaryHelper.hasOreName(stack, this.oreName);
        }
    }

    public static class DryingItemRecipe
    extends DryingRecipe {
        private ItemStack input;

        public DryingItemRecipe(ItemStack input, int time, ItemStack output) {
            super(time, output);
            this.input = input;
        }

        public ItemStack getInput() {
            return this.input;
        }

        @Override
        public boolean accepts(ItemStack stack) {
            return OreDictionary.itemMatches((ItemStack)this.input, (ItemStack)stack, (boolean)false);
        }
    }

    public static abstract class DryingRecipe {
        private int time;
        private ItemStack output;

        public DryingRecipe(int time, ItemStack output) {
            this.time = time;
            this.output = output;
        }

        public int getTime() {
            return this.time;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public abstract boolean accepts(ItemStack var1);
    }
}

