/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.chopblock;

import gigaherz.survivalist.api.Choppable;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileChopping
extends TileEntity {
    private static final Random RANDOM = new Random();
    private ItemStackHandler slotInventory = new ItemStackHandler(){

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!Choppable.isValidInput(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        protected void onContentsChanged(int slot) {
            TileChopping.this.breakingProgress = 0;
            if (TileChopping.this.field_145850_b != null) {
                IBlockState state = TileChopping.this.field_145850_b.func_180495_p(TileChopping.this.field_174879_c);
                TileChopping.this.field_145850_b.func_184138_a(TileChopping.this.field_174879_c, state, state, 3);
            }
            TileChopping.this.func_70296_d();
        }
    };
    private int breakingProgress = 0;

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.slotInventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.slotInventory, null, compound.func_74781_a("Inventory"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74782_a("Inventory", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.slotInventory, null));
        return compound;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean chop(EntityPlayer playerIn, int axeLevel, int fortune) {
        boolean completed = false;
        if (this.slotInventory.getStackInSlot(0).func_190916_E() > 0) {
            this.breakingProgress = (int)((double)this.breakingProgress + (25.0 + Choppable.getHitCountMultiplier(this.slotInventory.getStackInSlot(0)) * 25.0 * (double)Math.max(0, axeLevel)));
            if (this.breakingProgress >= 200) {
                if (!this.field_145850_b.field_72995_K) {
                    ItemStack out;
                    Choppable.ChoppingRecipe recipe = Choppable.find(this.slotInventory.getStackInSlot(0));
                    if (recipe != null && (out = recipe.getResults(this.slotInventory.getStackInSlot(0), playerIn, axeLevel, fortune, RANDOM)).func_190916_E() > 0) {
                        TileChopping.spawnItemStack(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5, out);
                    }
                    completed = true;
                }
                this.field_145850_b.func_184133_a(playerIn, this.field_174879_c, SoundEvents.field_187881_gQ, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.slotInventory.setStackInSlot(0, ItemStack.field_190927_a);
                this.breakingProgress = 0;
            }
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
        return completed;
    }

    public static void spawnItemStack(World worldIn, double x, double y, double z, ItemStack stack) {
        while (stack.func_190916_E() > 0) {
            int i = 1;
            if (i > stack.func_190916_E()) {
                i = stack.func_190916_E();
            }
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(i);
            stack.func_190917_f(-i);
            EntityItem entityitem = new EntityItem(worldIn, x, y, z, copy);
            entityitem.func_174867_a(15);
            entityitem.field_70159_w = RANDOM.nextGaussian() * 0.02;
            entityitem.field_70181_x = RANDOM.nextGaussian() * 0.02 + 0.2;
            entityitem.field_70179_y = RANDOM.nextGaussian() * 0.02;
            worldIn.func_72838_d((Entity)entityitem);
        }
    }

    public ItemStackHandler getSlotInventory() {
        return this.slotInventory;
    }

    public int getBreakStage() {
        if (this.breakingProgress <= 0) {
            return -1;
        }
        return this.breakingProgress * 10 / 200;
    }
}

