/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.integration.chopping;

import com.google.common.collect.Lists;
import gigaherz.survivalist.api.Choppable;
import gigaherz.survivalist.shadow.common.client.StackRenderingHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ChoppingRecipeWrapper
extends BlankRecipeWrapper {
    private double multiplier;
    private ItemStack output;

    public static List<ChoppingRecipeWrapper> getRecipes() {
        ArrayList list = Lists.newArrayList();
        for (Choppable.ChoppingRecipe pair : Choppable.RECIPES) {
            Object p = ChoppingRecipeWrapper.wrap(pair);
            if (p == null) continue;
            list.add((ChoppingRecipeWrapper)((Object)p));
        }
        return list;
    }

    @Nullable
    public static Object wrap(Choppable.ChoppingRecipe pair) {
        if (pair instanceof Choppable.ChoppingItemRecipe) {
            return new ItemInput((Choppable.ChoppingItemRecipe)pair);
        }
        if (pair instanceof Choppable.ChoppingOreRecipe) {
            return new OreInput((Choppable.ChoppingOreRecipe)pair);
        }
        return null;
    }

    private static ItemStack copyWithSize(ItemStack middle) {
        middle = middle.func_77946_l();
        middle.func_190920_e(1);
        return middle;
    }

    private ChoppingRecipeWrapper(ItemStack output, double multiplier) {
        this.output = output;
        this.multiplier = multiplier;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setOutput(ItemStack.class, (Object)this.output);
    }

    public void drawInfo(@Nonnull Minecraft mc, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(mc, recipeWidth, recipeHeight, mouseX, mouseY);
        ItemModelMesher mesher = mc.func_175599_af().func_175037_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
        long animTick = mc.field_71441_e.func_82737_E();
        int whichAxe = (int)(animTick / 20L % 5L);
        double amount = 1.0;
        ItemStack stack = null;
        switch (whichAxe) {
            case 0: {
                amount = 0.4 * this.multiplier;
                stack = null;
                break;
            }
            case 1: {
                amount = 1.0 * this.multiplier;
                stack = new ItemStack(Items.field_151053_p);
                break;
            }
            case 2: {
                amount = 2.0 * this.multiplier;
                stack = new ItemStack(Items.field_151049_t);
                break;
            }
            case 3: {
                amount = 3.0 * this.multiplier;
                stack = new ItemStack(Items.field_151036_c);
                break;
            }
            case 4: {
                amount = 4.0 * this.multiplier;
                stack = new ItemStack(Items.field_151056_x);
            }
        }
        if (stack != null) {
            StackRenderingHelper.renderItemStack(mesher, mc.field_71446_o, 28, 4, stack, -1);
        }
        String label = amount + "x";
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)150.0f);
        mc.field_71466_p.func_175065_a(label, (float)(58 - mc.field_71466_p.func_78256_a(label)), 14.0f, -1, true);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    private static class OreInput
    extends ChoppingRecipeWrapper {
        private String inputOredict;

        private OreInput(String input, ItemStack output, double multiplier) {
            super(output, multiplier);
            this.inputOredict = input;
        }

        public OreInput(Choppable.ChoppingOreRecipe recipe) {
            this(recipe.getOreName(), ChoppingRecipeWrapper.copyWithSize(recipe.getOutput()), recipe.getOutputMultiplier());
        }

        @Override
        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputLists(ItemStack.class, Collections.singletonList(OreDictionary.getOres((String)this.inputOredict)));
            super.getIngredients(ingredients);
        }
    }

    private static class ItemInput
    extends ChoppingRecipeWrapper {
        private ItemStack inputStack;

        private ItemInput(ItemStack input, ItemStack output, double multiplier) {
            super(output, multiplier);
            this.inputStack = input;
        }

        public ItemInput(Choppable.ChoppingItemRecipe recipe) {
            this(recipe.getInput(), ChoppingRecipeWrapper.copyWithSize(recipe.getOutput()), recipe.getOutputMultiplier());
        }

        @Override
        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(ItemStack.class, (Object)this.inputStack);
            super.getIngredients(ingredients);
        }
    }
}

