/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.rocks;

import gigaherz.survivalist.ConfigManager;
import gigaherz.survivalist.rocks.EntityRock;
import gigaherz.survivalist.rocks.RockMaterial;
import gigaherz.survivalist.shadow.common.state.IItemState;
import gigaherz.survivalist.shadow.common.state.IItemStateManager;
import gigaherz.survivalist.shadow.common.state.ItemStateful;
import gigaherz.survivalist.shadow.common.state.implementation.ItemStateManager;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class ItemRock
extends ItemStateful {
    public static final PropertyEnum<RockMaterial> TYPE = PropertyEnum.func_177709_a((String)"rock", RockMaterial.class);

    public ItemRock(String name) {
        super(name);
        this.func_77627_a(true);
        this.func_77655_b("survivalist.rock");
        this.func_77637_a(CreativeTabs.field_78035_l);
    }

    @Override
    public IItemStateManager createStateManager() {
        return new ItemStateManager(this, new IProperty[]{TYPE});
    }

    public String func_77667_c(ItemStack stack) {
        IItemState state = this.getStateManager().get(stack.func_77960_j());
        if (state == null) {
            return this.func_77658_a();
        }
        String subName = state.getValue(TYPE).getUnlocalizedSuffix();
        return "item.survivalist" + subName;
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (ConfigManager.instance.enableRocks) {
            for (RockMaterial type : TYPE.func_177700_c()) {
                IItemState state = this.getDefaultState().withProperty(TYPE, type);
                subItems.add((Object)state.getStack());
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!playerIn.field_71075_bZ.field_75098_d) {
            stack.func_190917_f(-1);
        }
        worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187797_fA, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (!worldIn.field_72995_K) {
            EntityRock entity = new EntityRock(worldIn, (EntityLivingBase)playerIn);
            entity.func_184538_a((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, 1.5f, 1.0f);
            worldIn.func_72838_d((Entity)entity);
        }
        playerIn.func_71029_a(StatList.func_188057_b((Item)this));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public ItemStack getStack(RockMaterial material) {
        return this.getDefaultState().withProperty(TYPE, material).getStack();
    }
}

