/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.misc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import gigaherz.survivalist.Survivalist;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class FibersEventHandling {
    private final Random rnd = new Random();
    private Field nonNullListDelegate;
    @GameRegistry.ObjectHolder(value="biomesoplenty:plant_0")
    public static Block bopPlant0 = null;
    @GameRegistry.ObjectHolder(value="biomesoplenty:plant_1")
    public static Block bopPlant1 = null;
    @GameRegistry.ObjectHolder(value="biomesoplenty:double_plant")
    public static Block bopPlantDouble = null;
    @GameRegistry.ObjectHolder(value="biomesoplenty:ivy")
    public static Block bopVineIvy = null;
    @GameRegistry.ObjectHolder(value="biomesoplenty:willow_vine")
    public static Block bopVineWillow = null;
    @GameRegistry.ObjectHolder(value="biomesoplenty:flower_vine")
    public static Block bopVineFlowering = null;

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new FibersEventHandling());
    }

    @SubscribeEvent
    public void onHarvestBlock(BlockEvent.HarvestDropsEvent ev) {
        if (ev.isSilkTouching()) {
            return;
        }
        if (!this.isFibreSource(ev.getState())) {
            return;
        }
        List drops = ev.getDrops();
        if (drops instanceof ImmutableList) {
            Survivalist.logger.warn("WARNING: Some mod is returning an ImmutableList from HarvestBlocks, replacing drops will NOT be possible.");
            return;
        }
        try {
            if (this.rnd.nextFloat() < 0.12f) {
                drops.add(new ItemStack(Survivalist.plant_fibres));
            }
        }
        catch (UnsupportedOperationException ex) {
            if (!(drops instanceof NonNullList)) {
                throw ex;
            }
            if (this.nonNullListDelegate == null) {
                this.nonNullListDelegate = ReflectionHelper.findField(drops.getClass(), (String[])new String[]{"field_191198_a", "delegate"});
            }
            try {
                this.nonNullListDelegate.set(drops, Lists.newArrayList((Iterable)drops));
                drops.add(new ItemStack(Survivalist.plant_fibres));
            }
            catch (IllegalAccessException e) {
                throw ex;
            }
        }
    }

    private boolean isFibreSource(IBlockState state) {
        if (state.func_177230_c() == Blocks.field_150329_H && state.func_177229_b((IProperty)BlockTallGrass.field_176497_a) != BlockTallGrass.EnumType.DEAD_BUSH) {
            return true;
        }
        if (state.func_177230_c() == Blocks.field_150395_bd) {
            return true;
        }
        if (state.func_177230_c() == bopPlant0 || state.func_177230_c() == bopPlant1 || state.func_177230_c() == bopPlantDouble) {
            return true;
        }
        return state.func_177230_c() == bopVineIvy || state.func_177230_c() == bopVineWillow || state.func_177230_c() == bopVineFlowering;
    }
}

