/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.state;

import gigaherz.survivalist.state.IItemState;
import gigaherz.survivalist.state.IItemStateManager;
import gigaherz.survivalist.state.StatefulItem;
import gigaherz.survivalist.state.implementation.ItemStateManager;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class ItemBlockStateful
extends ItemBlock
implements StatefulItem {
    private IItemStateManager stateManager;

    public ItemBlockStateful(Block block) {
        super(block);
        this.setRegistryName(block.getRegistryName());
        this.stateManager = this.createStateManager();
    }

    @Override
    public IItemStateManager getStateManager() {
        return this.stateManager;
    }

    @Override
    public IItemState getDefaultState() {
        return this.stateManager.getDefaultState();
    }

    public void setDefaultState(IItemState defaultState) {
        this.stateManager.setDefaultState(defaultState);
    }

    public IItemStateManager createStateManager() {
        BlockStateContainer blockStateManager = this.field_150939_a.func_176194_O();
        return new ItemStateManager(this, (IProperty[])blockStateManager.func_177623_d().stream().toArray(IProperty[]::new));
    }

    public ItemStack getStack(IBlockState bState) {
        IItemState iState = this.getDefaultState();
        for (IProperty prop : this.getStateManager().getProperties()) {
            iState = iState.withProperty(prop, bState.func_177229_b(prop));
        }
        return iState.getStack();
    }

    public IBlockState getBlockState(ItemStack stack) {
        IItemState iState = this.getStateManager().get(stack.func_77960_j());
        IBlockState bState = this.field_150939_a.func_176223_P();
        if (iState != null) {
            for (IProperty prop : this.getStateManager().getProperties()) {
                bState = bState.func_177226_a(prop, iState.getValue(prop));
            }
        }
        return bState;
    }
}

