/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import gigaherz.survivalist.ConfigManager;
import gigaherz.survivalist.SurvivalistMod;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class ConfigurationCondition
implements ICondition {
    public static final ResourceLocation NAME = SurvivalistMod.location("configuration");
    private final String categoryName;
    private final String keyName;

    public ConfigurationCondition(String categoryName, String keyName) {
        this.categoryName = categoryName;
        this.keyName = keyName;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        return ConfigManager.getConfigBoolean(this.categoryName, this.keyName);
    }

    public static class Serializer
    implements IConditionSerializer<ConfigurationCondition> {
        public static Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, ConfigurationCondition value) {
            json.add("category", (JsonElement)new JsonPrimitive(value.categoryName));
            json.add("key", (JsonElement)new JsonPrimitive(value.keyName));
        }

        public ConfigurationCondition read(JsonObject json) {
            String categoryName = JSONUtils.func_151200_h((JsonObject)json, (String)"category");
            String keyName = JSONUtils.func_151200_h((JsonObject)json, (String)"key");
            return new ConfigurationCondition(categoryName, keyName);
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

