/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gigaherz.survivalist.ConfigManager;
import gigaherz.survivalist.SurvivalistMod;
import gigaherz.survivalist.api.ChoppingContext;
import gigaherz.survivalist.api.SingletonInventory;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

public class ChoppingRecipe
implements IRecipe<ChoppingContext> {
    @ObjectHolder(value="survivalist:chopping")
    public static IRecipeSerializer<?> SERIALIZER = null;
    public static final ResourceLocation RECIPE_TYPE_ID = SurvivalistMod.location("chopping");
    public static IRecipeType<ChoppingRecipe> CHOPPING = (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)RECIPE_TYPE_ID, (Object)new IRecipeType<ChoppingRecipe>(){

        public String toString() {
            return RECIPE_TYPE_ID.toString();
        }
    });
    private final ResourceLocation id;
    private final String group;
    private final Ingredient input;
    private final ItemStack output;
    private final double outputMultiplier;
    private final double hitCountMultiplier;
    private final int maxOutput;
    private final int sawingTime;

    public static Optional<ChoppingRecipe> getRecipe(World world, ChoppingContext ctx) {
        return world.func_199532_z().func_215371_a(CHOPPING, (IInventory)ctx, world);
    }

    public static Optional<ChoppingRecipe> getRecipe(World world, ItemStack stack) {
        return ChoppingRecipe.getRecipe(world, new ChoppingContext(new SingletonInventory(stack), null, 0, 0, null));
    }

    public static Collection<ChoppingRecipe> getAllRecipes(World world) {
        return world.func_199532_z().func_215366_a(CHOPPING).values().stream().map(r -> (ChoppingRecipe)r).collect(Collectors.toList());
    }

    public ChoppingRecipe(ResourceLocation id, String group, Ingredient input, ItemStack output, double outputMultiplier, double hitCountMultiplier, int maxOutput, int sawingTime) {
        this.id = id;
        this.group = group;
        this.input = input;
        this.output = output;
        this.outputMultiplier = outputMultiplier;
        this.hitCountMultiplier = hitCountMultiplier;
        this.maxOutput = maxOutput;
        this.sawingTime = sawingTime;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public double getOutputMultiplier() {
        return this.outputMultiplier;
    }

    public double getHitCountMultiplier() {
        return this.hitCountMultiplier;
    }

    public int getSawingTime() {
        return this.sawingTime;
    }

    public int getMaxOutput() {
        return this.maxOutput;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.input});
    }

    public boolean matches(ChoppingContext inv, World worldIn) {
        return this.input.test(inv.func_70301_a(0));
    }

    public ItemStack getCraftingResult(ChoppingContext inv) {
        return inv.getPlayer() != null ? this.getResults(inv.func_70301_a(0), inv.getPlayer(), inv.getAxeLevel(), inv.getFortune(), inv.getRandom()) : this.getResultsSawmill();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public String func_193358_e() {
        return this.group;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return CHOPPING;
    }

    private ItemStack getResults(ItemStack input, @Nullable PlayerEntity player, int axeLevel, int fortune, Random random) {
        double number = this.getOutputMultiplier(axeLevel) * (double)(1.0f + random.nextFloat() * (float)fortune);
        int whole = (int)Math.floor(number);
        double remainder = number - (double)whole;
        if ((double)random.nextFloat() < remainder) {
            ++whole;
        }
        if (this.getMaxOutput() > 0) {
            whole = Math.min(whole, this.getMaxOutput());
        }
        if (whole > 0) {
            ItemStack out = this.getOutput().func_77946_l();
            out.func_190920_e(whole);
            return out;
        }
        return ItemStack.field_190927_a;
    }

    public double getOutputMultiplier(int axeLevel) {
        double number = (Double)ConfigManager.SERVER.choppingWithEmptyHand.get() * this.getOutputMultiplier();
        if (axeLevel >= 0) {
            number = Math.max(0.0, this.getOutputMultiplier() * ConfigManager.getAxeLevelMultiplier(axeLevel));
        }
        return number;
    }

    private ItemStack getResultsSawmill() {
        double number = Math.max(0.0, this.getOutputMultiplier() * 4.0);
        int whole = (int)Math.floor(number);
        if (this.getMaxOutput() > 0) {
            whole = Math.min(whole, this.getMaxOutput());
        }
        if (whole > 0) {
            ItemStack out = this.getOutput().func_77946_l();
            out.func_190920_e(whole);
            return out;
        }
        return ItemStack.field_190927_a;
    }

    public double getHitProgress(int axeLevel) {
        return 25.0 + this.getHitCountMultiplier() * 25.0 * (double)Math.max(0, axeLevel);
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ChoppingRecipe> {
        public ChoppingRecipe read(ResourceLocation recipeId, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            JsonArray jsonelement = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonelement);
            String s1 = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
            ResourceLocation resourcelocation = new ResourceLocation(s1);
            ItemStack itemstack = new ItemStack((IItemProvider)Optional.ofNullable(ForgeRegistries.ITEMS.getValue(resourcelocation)).orElseThrow(() -> new IllegalStateException("Item: " + s1 + " does not exist")));
            double outputMultiplier = JSONUtils.func_151221_a((JsonObject)json, (String)"output_multiplier", (float)1.0f);
            double hitCountMultiplier = JSONUtils.func_151221_a((JsonObject)json, (String)"hit_count_multiplier", (float)1.0f);
            int maxOutput = JSONUtils.func_151208_a((JsonObject)json, (String)"max_output", (int)0);
            int sawingTime = JSONUtils.func_151208_a((JsonObject)json, (String)"sawing_time", (int)200);
            return new ChoppingRecipe(recipeId, group, ingredient, itemstack, outputMultiplier, hitCountMultiplier, maxOutput, sawingTime);
        }

        public ChoppingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack itemstack = buffer.func_150791_c();
            double outputMultiplier = buffer.readDouble();
            double hitCountMultiplier = buffer.readDouble();
            int maxOutput = buffer.func_150792_a();
            int sawingTime = buffer.func_150792_a();
            return new ChoppingRecipe(recipeId, group, ingredient, itemstack, outputMultiplier, hitCountMultiplier, maxOutput, sawingTime);
        }

        public void write(PacketBuffer buffer, ChoppingRecipe recipe) {
            buffer.func_180714_a(recipe.group);
            recipe.input.func_199564_a(buffer);
            buffer.func_150788_a(recipe.output);
            buffer.writeDouble(recipe.outputMultiplier);
            buffer.writeDouble(recipe.hitCountMultiplier);
            buffer.func_150787_b(recipe.maxOutput);
            buffer.func_150787_b(recipe.sawingTime);
        }
    }
}

