/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gigaherz.survivalist.SurvivalistBlocks;
import gigaherz.survivalist.SurvivalistMod;
import gigaherz.survivalist.api.ItemHandlerWrapper;
import gigaherz.survivalist.api.SingletonInventory;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

public class DryingRecipe
implements IRecipe<ItemHandlerWrapper> {
    @ObjectHolder(value="survivalist:drying")
    public static IRecipeSerializer<?> SERIALIZER = null;
    public static final ResourceLocation RECIPE_TYPE_ID = SurvivalistMod.location("drying");
    public static IRecipeType<DryingRecipe> DRYING = (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)RECIPE_TYPE_ID, (Object)new IRecipeType<DryingRecipe>(){

        public String toString() {
            return RECIPE_TYPE_ID.toString();
        }
    });
    private final String group;
    private final ResourceLocation id;
    private final Ingredient input;
    private final int time;
    private final ItemStack output;

    public static int getDryingTime(World world, ItemHandlerWrapper ctx) {
        return world.func_199532_z().func_215371_a(DRYING, (IInventory)ctx, world).map(DryingRecipe::getDryTime).orElse(0);
    }

    public static int getDryingTime(World world, ItemStack input) {
        ItemHandlerWrapper ctx = new ItemHandlerWrapper(new SingletonInventory(input));
        return world.func_199532_z().func_215371_a(DRYING, (IInventory)ctx, world).map(DryingRecipe::getDryTime).orElse(200);
    }

    public static ItemStack getDryingResult(World world, ItemHandlerWrapper ctx) {
        return world.func_199532_z().func_215371_a(DRYING, (IInventory)ctx, world).map(r -> r.getCraftingResult(ctx)).orElse(ItemStack.field_190927_a);
    }

    public static Optional<DryingRecipe> getRecipe(World world, ItemHandlerWrapper ctx) {
        return world.func_199532_z().func_215371_a(DRYING, (IInventory)ctx, world);
    }

    public static Collection<DryingRecipe> getAllRecipes(World world) {
        return world.func_199532_z().func_215366_a(DRYING).values().stream().map(r -> (DryingRecipe)r).collect(Collectors.toList());
    }

    public DryingRecipe(ResourceLocation id, String group, Ingredient input, ItemStack output, int time) {
        this.group = group;
        this.id = id;
        this.input = input;
        this.time = time;
        this.output = output;
    }

    public String func_193358_e() {
        return this.group;
    }

    public int getDryTime() {
        return this.time;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.input});
    }

    public boolean matches(ItemHandlerWrapper inv, World worldIn) {
        return this.input.test(inv.func_70301_a(0));
    }

    public ItemStack getCraftingResult(ItemHandlerWrapper inv) {
        return this.input.test(inv.func_70301_a(0)) ? this.output.func_77946_l() : ItemStack.field_190927_a;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return DRYING;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)SurvivalistBlocks.RACK.get());
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<DryingRecipe> {
        public DryingRecipe read(ResourceLocation recipeId, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            JsonArray jsonelement = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonelement);
            String s1 = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
            ResourceLocation resourcelocation = new ResourceLocation(s1);
            ItemStack itemstack = new ItemStack((IItemProvider)Optional.ofNullable(ForgeRegistries.ITEMS.getValue(resourcelocation)).orElseThrow(() -> new IllegalStateException("Item: " + s1 + " does not exist")));
            int dryingTime = JSONUtils.func_151208_a((JsonObject)json, (String)"dryingTime", (int)200);
            return new DryingRecipe(recipeId, group, ingredient, itemstack, dryingTime);
        }

        public DryingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack itemstack = buffer.func_150791_c();
            int dryingTime = buffer.func_150792_a();
            return new DryingRecipe(recipeId, group, ingredient, itemstack, dryingTime);
        }

        public void write(PacketBuffer buffer, DryingRecipe recipe) {
            buffer.func_180714_a(recipe.group);
            recipe.input.func_199564_a(buffer);
            buffer.func_150788_a(recipe.output);
            buffer.func_150787_b(recipe.time);
        }
    }
}

