/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.rack;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gigaherz.survivalist.rack.DryingRackItemsStateData;
import gigaherz.survivalist.rack.DryingRackTileEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.QuadTransformer;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class DryingRackBakedModel
implements IDynamicBakedModel {
    private final TextureAtlasSprite particle;
    private final IBakedModel rackBakedModel;
    private final TRSRTransformation[] itemTransforms;
    private final List<Map<Pair<IBakedModel, Matrix4f>, List<BakedQuad>>> caches = Lists.newArrayList((Object[])new Map[]{Maps.newHashMap(), Maps.newHashMap(), Maps.newHashMap(), Maps.newHashMap()});
    private final ItemOverrideList overrides;
    private final VertexFormat format;
    private static final Direction[] faces = (Direction[])Streams.concat((Stream[])new Stream[]{Arrays.stream(Direction.values()), Stream.of((Direction)null)}).toArray(Direction[]::new);

    public DryingRackBakedModel(ModelBakery bakery, IUnbakedModel original, Function<ResourceLocation, IUnbakedModel> modelGetter, Function<ResourceLocation, TextureAtlasSprite> textureGetter, VertexFormat format, TextureAtlasSprite particle, IBakedModel rackBakedModel, TRSRTransformation[] itemTransforms) {
        this.particle = particle;
        this.rackBakedModel = rackBakedModel;
        this.itemTransforms = itemTransforms;
        this.overrides = new ItemOverrideList(bakery, original, modelGetter, textureGetter, Collections.emptyList(), format);
        this.format = format;
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        ArrayList quads = Lists.newArrayList();
        BlockRenderLayer renderLayer = MinecraftForgeClient.getRenderLayer();
        if (renderLayer == BlockRenderLayer.SOLID) {
            quads.addAll(this.rackBakedModel.func_200117_a(state, side, rand));
        } else if (renderLayer == BlockRenderLayer.CUTOUT && side == null) {
            ItemRenderer renderItem = Minecraft.func_71410_x().func_175599_af();
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            DryingRackItemsStateData items = (DryingRackItemsStateData)extraData.getData(DryingRackTileEntity.CONTAINED_ITEMS_DATA);
            for (int i = 0; i < 4; ++i) {
                ItemStack stack = items.stacks[i];
                if (stack.func_190926_b()) continue;
                IBakedModel model = renderItem.func_184393_a(stack, (World)world, null);
                if (stack.func_77973_b() == Items.field_203184_eO) {
                    model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174953_a(new ModelResourceLocation("minecraft:trident#inventory"));
                }
                Pair pair = model.handlePerspective(ItemCameraTransforms.TransformType.FIXED);
                model = (IBakedModel)pair.getLeft();
                Matrix4f matrix1 = (Matrix4f)pair.getRight();
                if (model.func_188618_c()) continue;
                Map<Pair<IBakedModel, Matrix4f>, List<BakedQuad>> cache = this.caches.get(i);
                Pair pair2 = Pair.of((Object)model, (Object)matrix1);
                ArrayList cachedQuads = cache.get(pair2);
                Matrix4f matrix = new Matrix4f();
                matrix.setIdentity();
                TRSRTransformation cfr_ignored_0 = this.itemTransforms[i];
                Matrix4f matrix2 = TRSRTransformation.getMatrix((Direction)Direction.NORTH);
                if (matrix2 != null) {
                    matrix.mul(matrix2);
                }
                if (matrix1 != null) {
                    matrix.mul(matrix1);
                }
                cachedQuads = Lists.newArrayList();
                for (Direction face : faces) {
                    List inQuads = model.func_200117_a(null, face, rand);
                    List outQuads = new QuadTransformer(this.format, new TRSRTransformation(matrix)).processMany(inQuads);
                    cachedQuads.addAll(outQuads);
                }
                cache.put((Pair<IBakedModel, Matrix4f>)pair2, cachedQuads);
                quads.addAll(cachedQuads);
            }
        }
        return quads;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particle;
    }

    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    public static class ModelLoader
    implements IModelLoader<Geometry> {
        public static final ModelLoader INSTANCE = new ModelLoader();

        protected ModelLoader() {
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public Geometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            BlockModel baseModel = null;
            if (modelContents.has("base_model")) {
                baseModel = (BlockModel)deserializationContext.deserialize((JsonElement)JSONUtils.func_152754_s((JsonObject)modelContents, (String)"base_model"), BlockModel.class);
            }
            TRSRTransformation[] transformations = new TRSRTransformation[4];
            for (int i = 0; i < 4; ++i) {
                String key = "transform_" + i;
                if (!modelContents.has(key)) continue;
                transformations[i] = (TRSRTransformation)deserializationContext.deserialize(modelContents.get(key), TRSRTransformation.class);
            }
            return new Geometry(baseModel, transformations);
        }
    }

    public static class Geometry
    implements IModelGeometry<Geometry> {
        private final TRSRTransformation[] transformations;
        @Nullable
        private BlockModel baseModel;

        public Geometry(@Nullable BlockModel baseModel, TRSRTransformation[] matrices) {
            this.baseModel = baseModel;
            this.transformations = matrices;
        }

        public Collection<ResourceLocation> getTextureDependencies(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
            ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
            if (this.baseModel != null) {
                list.addAll(this.baseModel.func_209559_a(modelGetter, missingTextureErrors));
            }
            return list;
        }

        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format, ItemOverrideList overrides) {
            IBakedModel rackBakedModel;
            TextureAtlasSprite particleSprite = spriteGetter.apply(new ResourceLocation(owner.resolveTexture("particle")));
            if (this.baseModel == null) {
                IUnbakedModel rackModel = ModelLoaderRegistry.getMissingModel();
                rackBakedModel = rackModel.bake(bakery, spriteGetter, sprite, format);
            } else {
                rackBakedModel = this.baseModel.bake(bakery, this.baseModel, spriteGetter, sprite, format);
            }
            Optional baseTransform = sprite.getState().apply(Optional.empty());
            if (baseTransform.isPresent()) {
                TRSRTransformation value = (TRSRTransformation)baseTransform.get();
                this.transformations[0] = value.compose(this.transformations[0]);
                this.transformations[1] = value.compose(this.transformations[1]);
                this.transformations[2] = value.compose(this.transformations[2]);
                this.transformations[3] = value.compose(this.transformations[3]);
            }
            return new DryingRackBakedModel(bakery, owner.getOwnerModel(), arg_0 -> ((ModelBakery)bakery).func_209597_a(arg_0), spriteGetter, format, particleSprite, rackBakedModel, this.transformations);
        }
    }
}

