/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist;

import com.google.common.base.Joiner;
import gigaherz.survivalist.ConfigManager;
import gigaherz.survivalist.ConfigToggledIngredientSerializer;
import gigaherz.survivalist.ConfigurationCondition;
import gigaherz.survivalist.SurvivalistBlocks;
import gigaherz.survivalist.SurvivalistData;
import gigaherz.survivalist.SurvivalistItems;
import gigaherz.survivalist.SurvivalistRecipeBookCategories;
import gigaherz.survivalist.SurvivalistTileEntityTypes;
import gigaherz.survivalist.api.ChoppingRecipe;
import gigaherz.survivalist.api.DryingRecipe;
import gigaherz.survivalist.fibers.AddFibersModifier;
import gigaherz.survivalist.misc.BlockTagCondition;
import gigaherz.survivalist.misc.StringEventHandling;
import gigaherz.survivalist.rack.DryingRackBakedModel;
import gigaherz.survivalist.rack.DryingRackContainer;
import gigaherz.survivalist.rack.DryingRackScreen;
import gigaherz.survivalist.rocks.RockEntity;
import gigaherz.survivalist.sawmill.gui.SawmillContainer;
import gigaherz.survivalist.sawmill.gui.SawmillScreen;
import gigaherz.survivalist.scraping.ItemBreakingTracker;
import gigaherz.survivalist.scraping.ScrapingEnchantment;
import gigaherz.survivalist.scraping.ScrapingMessage;
import gigaherz.survivalist.slime.SlimeMerger;
import gigaherz.survivalist.torchfire.TorchFireEventHandling;
import gigaherz.survivalist.util.RegSitter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.packs.DelegatableResourcePack;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
@Mod(value="survivalist")
public class SurvivalistMod {
    public static final String MODID = "survivalist";
    public static SurvivalistMod instance;
    public static Logger LOGGER;
    public static final ItemGroup SURVIVALIST_ITEMS;
    static final RegSitter HELPER;
    public static RegistryObject<SoundEvent> SOUND_SHLOP;
    public static RegistryObject<ScrapingEnchantment> SCRAPING;
    public static RegistryObject<EntityType<RockEntity>> THROWN_ROCK;
    public static final String CHANNEL = "main";
    private static final String PROTOCOL_VERSION = "1.0";
    public static SimpleChannel channel;

    public SurvivalistMod() {
        instance = this;
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        HELPER.subscribeEvents(modEventBus);
        SurvivalistBlocks.HELPER.subscribeEvents(modEventBus);
        SurvivalistItems.HELPER.subscribeEvents(modEventBus);
        SurvivalistTileEntityTypes.HELPER.subscribeEvents(modEventBus);
        modEventBus.addGenericListener(ContainerType.class, this::registerContainers);
        modEventBus.addGenericListener(IRecipeSerializer.class, this::registerRecipeSerializers);
        modEventBus.addGenericListener(GlobalLootModifierSerializer.class, this::lootModifiers);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::gatherData);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        modLoadingContext.registerConfig(ModConfig.Type.SERVER, ConfigManager.SERVER_SPEC);
    }

    public void gatherData(GatherDataEvent event) {
        SurvivalistData.gatherData(event);
    }

    private void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new ContainerType[]{SurvivalistMod.withName(new ContainerType(DryingRackContainer::new), "rack"), SurvivalistMod.withName(new ContainerType(SawmillContainer::new), "sawmill")});
    }

    private void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        CraftingHelper.register((IConditionSerializer)ConfigurationCondition.Serializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)ConfigToggledIngredientSerializer.NAME, (IIngredientSerializer)ConfigToggledIngredientSerializer.INSTANCE);
        event.getRegistry().registerAll((IForgeRegistryEntry[])new IRecipeSerializer[]{(IRecipeSerializer)new DryingRecipe.Serializer().setRegistryName("drying"), (IRecipeSerializer)new ChoppingRecipe.Serializer().setRegistryName("chopping")});
    }

    private void lootModifiers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)new BlockTagCondition.Serializer());
        event.getRegistry().register((IForgeRegistryEntry)new AddFibersModifier.Serializer().setRegistryName(SurvivalistMod.location("plant_fibers")));
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        SurvivalistRecipeBookCategories.instance();
        TorchFireEventHandling.register();
        ItemBreakingTracker.register();
        StringEventHandling.register();
        SlimeMerger.register();
        LOGGER.info("Registering network channel...");
        int messageNumber = 0;
        channel.registerMessage(messageNumber++, ScrapingMessage.class, ScrapingMessage::encode, ScrapingMessage::new, ScrapingMessage::handle);
        LOGGER.debug("Final message number: " + messageNumber);
    }

    public void clientSetup(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(DryingRackContainer.TYPE, DryingRackScreen::new);
        ScreenManager.func_216911_a(SawmillContainer.TYPE, SawmillScreen::new);
        ModelLoaderRegistry.registerLoader((ResourceLocation)SurvivalistMod.location("rack"), (IModelLoader)DryingRackBakedModel.ModelLoader.INSTANCE);
    }

    public void serverStarting(FMLServerAboutToStartEvent event) {
        event.getServer().func_195561_aH().func_198982_a(new IPackFinder(){

            public <T extends ResourcePackInfo> void func_195730_a(Map<String, T> map, ResourcePackInfo.IFactory<T> infoFactory) {
                map.computeIfAbsent("survivalist_vanilla_replacements", id -> ResourcePackInfo.func_195793_a((String)id, (boolean)false, () -> new SurvivalistVanillaReplacements((String)id), (ResourcePackInfo.IFactory)infoFactory, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.TOP));
            }
        });
    }

    private static <R extends T, T extends IForgeRegistryEntry<T>> R withName(R obj, ResourceLocation name) {
        obj.setRegistryName(name);
        return obj;
    }

    private static <R extends T, T extends IForgeRegistryEntry<T>> R withName(R obj, String name) {
        return SurvivalistMod.withName(obj, new ResourceLocation(MODID, name));
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MODID, path);
    }

    static {
        LOGGER = LogManager.getLogger((String)MODID);
        SURVIVALIST_ITEMS = new ItemGroup("survivalist_items"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)SurvivalistItems.PICK.get());
            }
        };
        HELPER = new RegSitter(MODID);
        SOUND_SHLOP = HELPER.soundEvent("shlop", () -> new SoundEvent(SurvivalistMod.location("mob.slime.merge"))).defer();
        SCRAPING = HELPER.enchantment("scraping", ScrapingEnchantment::new).defer();
        THROWN_ROCK = HELPER.entityType("thrown_rock", RockEntity::new, EntityClassification.MISC).size(0.5f, 0.5f).immuneToFire().setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).setCustomClientFactory((packet, world) -> new RockEntity((World)world)).defer();
        channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MODID, CHANNEL)).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    }

    private static class SurvivalistVanillaReplacements
    extends DelegatableResourcePack {
        private final String id;
        private final ModFile modFile;

        public SurvivalistVanillaReplacements(String id) {
            super(new File(id));
            this.id = id;
            this.modFile = ModList.get().getModFileById(SurvivalistMod.MODID).getFile();
        }

        public String func_195762_a() {
            return this.id;
        }

        public InputStream func_195766_a(String name) throws IOException {
            Path path = this.modFile.getLocator().findPath((IModFile)this.modFile, new String[]{"vanilla_replacements", name});
            return Files.newInputStream(path, StandardOpenOption.READ);
        }

        public boolean func_195768_c(String name) {
            return Files.exists(this.modFile.getLocator().findPath((IModFile)this.modFile, new String[]{"vanilla_replacements", name}), new LinkOption[0]);
        }

        public Collection<ResourceLocation> func_225637_a_(ResourcePackType type, String namespaceIn, String pathIn, int maxDepth, Predicate<String> filter) {
            try {
                Path root = this.modFile.getLocator().findPath((IModFile)this.modFile, new String[]{"vanilla_replacements", type.func_198956_a()}).toAbsolutePath();
                Path inputPath = root.getFileSystem().getPath(pathIn, new String[0]);
                List<ResourceLocation> resourceLocationList = Files.walk(root, new FileVisitOption[0]).map(path -> root.relativize(path.toAbsolutePath())).filter(path -> path.getNameCount() > 1 && path.getNameCount() - 1 <= maxDepth).filter(path -> !path.toString().endsWith(".mcmeta")).filter(path -> path.subpath(1, path.getNameCount()).startsWith(inputPath)).filter(path -> filter.test(path.getFileName().toString())).map(path -> new ResourceLocation(path.getName(0).toString(), Joiner.on((char)'/').join((Iterable)path.subpath(1, Math.min(maxDepth, path.getNameCount()))))).collect(Collectors.toList());
                return resourceLocationList;
            }
            catch (IOException e) {
                return Collections.emptyList();
            }
        }

        public Set<String> func_195759_a(ResourcePackType type) {
            try {
                Path root = this.modFile.getLocator().findPath((IModFile)this.modFile, new String[]{"vanilla_replacements", type.func_198956_a()}).toAbsolutePath();
                return Files.walk(root, 1, new FileVisitOption[0]).map(path -> root.relativize(path.toAbsolutePath())).filter(path -> path.getNameCount() > 0).map(p -> p.toString().replaceAll("/$", "")).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
            }
            catch (IOException e) {
                return Collections.emptySet();
            }
        }

        public InputStream func_195761_a(ResourcePackType type, ResourceLocation location) throws IOException {
            if (location.func_110623_a().startsWith("lang/")) {
                return super.func_195761_a(ResourcePackType.CLIENT_RESOURCES, location);
            }
            return super.func_195761_a(type, location);
        }

        public boolean func_195764_b(ResourcePackType type, ResourceLocation location) {
            if (location.func_110623_a().startsWith("lang/")) {
                return super.func_195764_b(ResourcePackType.CLIENT_RESOURCES, location);
            }
            return super.func_195764_b(type, location);
        }

        public void close() {
        }
    }
}

