/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.fibers;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.IGlobalLootModifier;

public class AddFibersModifier
implements IGlobalLootModifier {
    private final ILootCondition[] lootConditions;
    private final ResourceLocation lootTable;
    boolean reentryPrevention = false;

    public AddFibersModifier(ILootCondition[] lootConditions, ResourceLocation lootTable) {
        this.lootConditions = lootConditions;
        this.lootTable = lootTable;
    }

    @Nonnull
    public List<ItemStack> apply(List<ItemStack> generatedLoot, LootContext context) {
        if (this.reentryPrevention) {
            return generatedLoot;
        }
        if (!Arrays.stream(this.lootConditions).allMatch(c -> c.test((Object)context))) {
            return generatedLoot;
        }
        this.reentryPrevention = true;
        LootTable lootTable = context.func_227502_a_(this.lootTable);
        List extras = lootTable.func_216113_a(context);
        generatedLoot.addAll(extras);
        this.reentryPrevention = false;
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AddFibersModifier> {
        public AddFibersModifier read(ResourceLocation location, JsonObject object, ILootCondition[] ailootcondition) {
            ResourceLocation lootTable = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"add_loot"));
            return new AddFibersModifier(ailootcondition, lootTable);
        }
    }
}

