/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.integration;

import com.google.common.collect.Lists;
import gigaherz.survivalist.SurvivalistBlocks;
import gigaherz.survivalist.SurvivalistMod;
import gigaherz.survivalist.api.ChoppingRecipe;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ToolType;

public class ChoppingCategory
implements IRecipeCategory<ChoppingRecipe> {
    private static final ResourceLocation GUI_TEXTURE_LOCATION = SurvivalistMod.location("textures/gui/conversion.png");
    private static final ResourceLocation JEI_RECIPE_GUI_VANILLA = new ResourceLocation("jei", "textures/gui/gui_vanilla.png");
    public static final ResourceLocation UID = SurvivalistMod.location("chopping");
    public static ChoppingCategory INSTANCE;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private List<ItemStack> tools = Lists.newArrayList((Object[])new ItemStack[]{ItemStack.field_190927_a, new ItemStack((IItemProvider)Items.field_151053_p), new ItemStack((IItemProvider)Items.field_151006_E), new ItemStack((IItemProvider)Items.field_151049_t), new ItemStack((IItemProvider)Items.field_151036_c), new ItemStack((IItemProvider)Items.field_151056_x)});

    public ChoppingCategory(IGuiHelper guiHelper) {
        INSTANCE = this;
        this.background = guiHelper.createDrawable(GUI_TEXTURE_LOCATION, 0, 0, 112, 50);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)SurvivalistBlocks.OAK_CHOPPING_BLOCK.get()));
        this.arrow = guiHelper.drawableBuilder(JEI_RECIPE_GUI_VANILLA, 82, 128, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends ChoppingRecipe> getRecipeClass() {
        return ChoppingRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"text.survivalist.jei.category.chopping", (Object[])new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(ChoppingRecipe choppingRecipe, IIngredients iIngredients) {
        iIngredients.setInputIngredients(choppingRecipe.func_192400_c());
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)choppingRecipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, ChoppingRecipe recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 16, 16);
        itemStacks.init(1, false, 78, 16);
        itemStacks.set(ingredients);
    }

    public void draw(ChoppingRecipe recipe, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemRenderer itemRenderer = mc.func_175599_af();
        this.arrow.draw(42, 16);
        float gameTime = mc.field_71441_e.func_82737_E();
        int index = MathHelper.func_76141_d((float)(gameTime / 20.0f)) % this.tools.size();
        ItemStack stack = this.tools.get(index);
        int axeLevel = stack.getHarvestLevel(ToolType.AXE, null, null);
        double outputMultiplier = recipe.getOutputMultiplier(axeLevel);
        String text = String.format("x%1.1f", outputMultiplier);
        int width = mc.field_71466_p.func_78256_a(text);
        mc.field_71466_p.func_175063_a(text, (float)(110 - width), 40.0f, -1);
        int clickMultiplier = MathHelper.func_76143_f((double)(200.0 / recipe.getHitProgress(axeLevel)));
        itemRenderer.func_180450_b(stack, 36, 30);
        mc.field_71466_p.func_175063_a(String.format("x%d", clickMultiplier), 50.0f, 40.0f, -1);
    }
}

