/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.integration;

import gigaherz.survivalist.SurvivalistBlocks;
import gigaherz.survivalist.SurvivalistMod;
import gigaherz.survivalist.api.DryingRecipe;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class DryingCategory
implements IRecipeCategory<DryingRecipe> {
    private static final ResourceLocation GUI_TEXTURE_LOCATION = SurvivalistMod.location("textures/gui/conversion.png");
    private static final ResourceLocation JEI_RECIPE_GUI_VANILLA = new ResourceLocation("jei", "textures/gui/gui_vanilla.png");
    public static final ResourceLocation UID = SurvivalistMod.location("drying");
    public static DryingCategory INSTANCE;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;

    public DryingCategory(IGuiHelper guiHelper) {
        INSTANCE = this;
        this.background = guiHelper.createDrawable(GUI_TEXTURE_LOCATION, 12, 12, 88, 26);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)SurvivalistBlocks.RACK.get()));
        this.arrow = guiHelper.drawableBuilder(JEI_RECIPE_GUI_VANILLA, 82, 128, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends DryingRecipe> getRecipeClass() {
        return DryingRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"text.survivalist.jei.category.drying", (Object[])new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(DryingRecipe dryingRecipe, IIngredients iIngredients) {
        iIngredients.setInputIngredients(dryingRecipe.func_192400_c());
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)dryingRecipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, DryingRecipe recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 4, 4);
        itemStacks.init(1, false, 66, 4);
        itemStacks.set(ingredients);
    }

    public void draw(DryingRecipe recipe, double mouseX, double mouseY) {
        this.arrow.draw(30, 4);
    }
}

