/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.sawmill;

import gigaherz.survivalist.SurvivalistTileEntityTypes;
import gigaherz.survivalist.api.ChoppingContext;
import gigaherz.survivalist.api.ChoppingRecipe;
import gigaherz.survivalist.sawmill.SawmillBlock;
import gigaherz.survivalist.sawmill.gui.SawmillContainer;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class SawmillTileEntity
extends TileEntity
implements ITickableTileEntity,
IIntArray,
INamedContainerProvider {
    public static RegistryObject<TileEntityType<SawmillTileEntity>> TYPE = SurvivalistTileEntityTypes.SAWMILL_RACK_TILE_ENTITY_TYPE;
    @CapabilityInject(value=IItemHandler.class)
    public static Capability<IItemHandler> ITEMS_CAP;
    public final ItemStackHandler inventory = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            SawmillTileEntity.this.func_70296_d();
            SawmillTileEntity.this.needRefreshRecipe = true;
        }
    };
    private final RangedWrapper top = new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 1);
    private final RangedWrapper sides = new RangedWrapper((IItemHandlerModifiable)this.inventory, 1, 2){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!AbstractFurnaceTileEntity.func_213991_b((ItemStack)stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    private final RangedWrapper bottom = new RangedWrapper((IItemHandlerModifiable)this.inventory, 2, 3){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }
    };
    private final LazyOptional<IItemHandler> combined_provider = LazyOptional.of(() -> this.inventory);
    private final LazyOptional<IItemHandler> top_provider = LazyOptional.of(() -> this.top);
    private final LazyOptional<IItemHandler> sides_provider = LazyOptional.of(() -> this.sides);
    private final LazyOptional<IItemHandler> bottom_provider = LazyOptional.of(() -> this.bottom);
    private static final Random RANDOM;
    private int remainingBurnTime;
    private int totalBurnTime;
    private int cookTime;
    private int totalCookTime;
    private boolean needRefreshRecipe = true;

    public SawmillTileEntity() {
        super((TileEntityType)TYPE.get());
    }

    public boolean isBurning() {
        return this.remainingBurnTime > 0;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ITEMS_CAP) {
            if (facing == Direction.UP) {
                return this.top_provider.cast();
            }
            if (facing == Direction.DOWN) {
                return this.bottom_provider.cast();
            }
            if (facing != null) {
                return this.sides_provider.cast();
            }
            return this.combined_provider.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        ITEMS_CAP.readNBT((Object)this.inventory, null, compound.func_74781_a("Items"));
        this.remainingBurnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.needRefreshRecipe = true;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        compound.func_218657_a("Items", ITEMS_CAP.writeNBT((Object)this.inventory, null));
        compound.func_74768_a("BurnTime", (int)((short)this.remainingBurnTime));
        compound.func_74768_a("CookTime", (int)((short)this.cookTime));
        return compound;
    }

    public void handleUpdateTag(CompoundNBT tag) {
    }

    public static int getSawmillTime(World world, ItemStack stack) {
        return ChoppingRecipe.getRecipe(world, stack).map(recipe -> recipe.getSawingTime()).orElse(0);
    }

    public void func_73660_a() {
        BlockState state;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean changes = false;
        if (this.needRefreshRecipe) {
            this.totalBurnTime = ForgeHooks.getBurnTime((ItemStack)this.inventory.getStackInSlot(1));
            this.totalCookTime = SawmillTileEntity.getSawmillTime(this.field_145850_b, this.inventory.getStackInSlot(0));
            this.needRefreshRecipe = false;
        }
        if (this.isBurning()) {
            --this.remainingBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack fuel = this.inventory.getStackInSlot(1);
            if (this.isBurning() || !fuel.func_190926_b()) {
                ChoppingContext ctx = new ChoppingContext((IItemHandlerModifiable)this.inventory, null, 0, 0, RANDOM);
                changes |= ChoppingRecipe.getRecipe(this.field_145850_b, ctx).map(choppingRecipe -> {
                    boolean changes2 = false;
                    if (!this.isBurning() && this.canWork(ctx, (ChoppingRecipe)choppingRecipe)) {
                        this.remainingBurnTime = this.totalBurnTime = ForgeHooks.getBurnTime((ItemStack)fuel);
                        if (this.isBurning()) {
                            changes2 = true;
                            if (!fuel.func_190926_b()) {
                                Item item = fuel.func_77973_b();
                                fuel.func_190918_g(1);
                                if (fuel.func_190926_b()) {
                                    ItemStack containerItem = item.getContainerItem(fuel);
                                    this.inventory.setStackInSlot(1, containerItem);
                                }
                            }
                        }
                    }
                    if (this.isBurning() && this.canWork(ctx, (ChoppingRecipe)choppingRecipe)) {
                        ++this.cookTime;
                        if (this.totalCookTime == 0) {
                            this.totalCookTime = choppingRecipe.getSawingTime();
                        }
                        if (this.cookTime >= this.totalCookTime) {
                            this.cookTime = 0;
                            this.totalCookTime = choppingRecipe.getSawingTime();
                            this.processItem(ctx, (ChoppingRecipe)choppingRecipe);
                            changes2 = true;
                        }
                    } else {
                        this.cookTime = 0;
                    }
                    return changes2;
                }).orElse(false).booleanValue();
            }
            if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
        }
        if (((Boolean)(state = this.func_195044_w()).func_177229_b((IProperty)SawmillBlock.POWERED)).booleanValue() != this.isBurning()) {
            state = (BlockState)state.func_206870_a((IProperty)SawmillBlock.POWERED, (Comparable)Boolean.valueOf(this.isBurning()));
            this.field_145850_b.func_175656_a(this.field_174879_c, state);
        }
        if (changes) {
            this.func_70296_d();
        }
    }

    private boolean canWork(ChoppingContext ctx, ChoppingRecipe choppingRecipe) {
        return this.getResult(ctx, choppingRecipe).func_190916_E() > 0;
    }

    private void processItem(ChoppingContext ctx, ChoppingRecipe recipe) {
        ItemStack input = this.inventory.getStackInSlot(0);
        if (input.func_190926_b()) {
            return;
        }
        ItemStack result = this.getResult(ctx, recipe);
        if (result.func_190916_E() <= 0) {
            return;
        }
        this.inventory.insertItem(2, result, false);
        input.func_190918_g(1);
    }

    private ItemStack getResult(ChoppingContext ctx, @Nullable ChoppingRecipe choppingRecipe) {
        if (choppingRecipe == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = choppingRecipe.getCraftingResult(ctx);
        ItemStack output = this.inventory.getStackInSlot(2);
        int max = Math.min(this.inventory.getSlotLimit(2), output.func_77976_d());
        int space = max - output.func_190916_E();
        if (space < result.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        return result;
    }

    public int func_221476_a(int index) {
        switch (index) {
            case 0: {
                return this.remainingBurnTime;
            }
            case 1: {
                return this.totalBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_221477_a(int index, int value) {
        switch (index) {
            case 0: {
                this.remainingBurnTime = value;
            }
            case 1: {
                this.totalBurnTime = value;
            }
            case 2: {
                this.cookTime = value;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public int func_221478_a() {
        return 4;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("text.survivalist.sawmill", new Object[0]);
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        return new SawmillContainer(windowId, this, playerInventory);
    }

    static {
        RANDOM = new Random();
    }
}

