/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.scraping;

import com.google.common.collect.Lists;
import gigaherz.survivalist.ConfigManager;
import gigaherz.survivalist.SurvivalistItems;
import gigaherz.survivalist.SurvivalistMod;
import gigaherz.survivalist.scraping.ScrapingMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.TieredItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.CombatTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Triple;

public class ItemBreakingTracker {
    public static final ResourceLocation PROP_KEY = SurvivalistMod.location("item_breaking_tracker");
    PlayerEntity player;
    World world;
    ItemStack[] equipmentSlots;

    public static LazyOptional<ItemBreakingTracker> get(PlayerEntity p) {
        return p.getCapability(Handler.TRACKER, null);
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new Handler());
    }

    public void init(Entity entity, World world) {
        this.player = (PlayerEntity)entity;
        this.world = world;
    }

    public void before() {
        ArrayList equipment = Lists.newArrayList((Iterable)this.player.func_184193_aE());
        this.equipmentSlots = new ItemStack[equipment.size()];
        for (int i = 0; i < equipment.size(); ++i) {
            ItemStack stack = (ItemStack)equipment.get(i);
            this.equipmentSlots[i] = stack != null ? stack.func_77946_l() : null;
        }
    }

    public Collection<ItemStack> after() {
        if (this.equipmentSlots == null) {
            return Collections.emptyList();
        }
        ArrayList changes = Lists.newArrayList();
        ArrayList equipment = Lists.newArrayList((Iterable)this.player.func_184193_aE());
        for (int i = 0; i < equipment.size(); ++i) {
            ItemStack stack;
            ItemStack stack2 = this.equipmentSlots[i];
            if (stack2 == null || (stack = (ItemStack)equipment.get(i)) != null) continue;
            changes.add(stack2);
        }
        return changes;
    }

    public static class CombatTrackerIntercept
    extends CombatTracker {
        CombatTracker inner;
        PlayerEntity entity;

        public CombatTrackerIntercept(PlayerEntity fighterIn) {
            super((LivingEntity)fighterIn);
            this.inner = fighterIn.func_110142_aN();
            this.entity = fighterIn;
        }

        public void func_94547_a(DamageSource damageSrc, float healthIn, float damageAmount) {
            Handler.instance.onTrackDamage(this.entity);
            this.inner.func_94547_a(damageSrc, healthIn, damageAmount);
        }

        public int func_180134_f() {
            return this.inner.func_180134_f();
        }

        public LivingEntity func_94550_c() {
            return this.inner.func_94550_c();
        }

        public void func_94545_a() {
            this.inner.func_94545_a();
        }

        public ITextComponent func_151521_b() {
            return this.inner.func_151521_b();
        }

        public LivingEntity func_180135_h() {
            return this.inner.func_180135_h();
        }

        public void func_94549_h() {
            this.inner.func_94549_h();
        }
    }

    public static class Handler {
        final Random rnd = new Random();
        @CapabilityInject(value=ItemBreakingTracker.class)
        public static Capability<ItemBreakingTracker> TRACKER;
        public static Handler instance;
        List<Triple<ItemStack, ItemStack, ItemStack>> scrapingRegistry = Lists.newArrayList();

        public Handler() {
            instance = this;
            CapabilityManager.INSTANCE.register(ItemBreakingTracker.class, (Capability.IStorage)new Capability.IStorage<ItemBreakingTracker>(){

                public INBT writeNBT(Capability<ItemBreakingTracker> capability, ItemBreakingTracker instance, Direction side) {
                    return new CompoundNBT();
                }

                public void readNBT(Capability<ItemBreakingTracker> capability, ItemBreakingTracker instance, Direction side, INBT nbt) {
                }
            }, () -> {
                throw new RuntimeException("Creating default instances is not supported for this capability.");
            });
            this.registerScrapoingConversions();
        }

        void registerScrapoingConversions() {
            if (((Boolean)ConfigManager.SERVER.enableToolScraping.get()).booleanValue()) {
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151038_n), (Object)new ItemStack((IItemProvider)Blocks.field_196662_n), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151017_I), (Object)new ItemStack((IItemProvider)Blocks.field_196662_n), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151053_p), (Object)new ItemStack((IItemProvider)Blocks.field_196662_n), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151039_o), (Object)new ItemStack((IItemProvider)Blocks.field_196662_n), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151041_m), (Object)new ItemStack((IItemProvider)Blocks.field_196662_n), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151051_r), (Object)new ItemStack((IItemProvider)Blocks.field_150347_e), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151018_J), (Object)new ItemStack((IItemProvider)Blocks.field_150347_e), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151049_t), (Object)new ItemStack((IItemProvider)Blocks.field_150347_e), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151050_s), (Object)new ItemStack((IItemProvider)Blocks.field_150347_e), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151052_q), (Object)new ItemStack((IItemProvider)Blocks.field_150347_e), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151037_a), (Object)new ItemStack((IItemProvider)Items.field_151042_j), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151019_K), (Object)new ItemStack((IItemProvider)Items.field_151042_j), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151036_c), (Object)new ItemStack((IItemProvider)Items.field_151042_j), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151035_b), (Object)new ItemStack((IItemProvider)Items.field_151042_j), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151040_l), (Object)new ItemStack((IItemProvider)Items.field_151042_j), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151011_C), (Object)new ItemStack((IItemProvider)Items.field_151043_k), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151013_M), (Object)new ItemStack((IItemProvider)Items.field_151043_k), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151006_E), (Object)new ItemStack((IItemProvider)Items.field_151043_k), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151005_D), (Object)new ItemStack((IItemProvider)Items.field_151043_k), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151010_B), (Object)new ItemStack((IItemProvider)Items.field_151043_k), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151047_v), (Object)new ItemStack((IItemProvider)Items.field_151045_i), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151012_L), (Object)new ItemStack((IItemProvider)Items.field_151045_i), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151056_x), (Object)new ItemStack((IItemProvider)Items.field_151045_i), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151046_w), (Object)new ItemStack((IItemProvider)Items.field_151045_i), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151048_u), (Object)new ItemStack((IItemProvider)Items.field_151045_i), (Object)new ItemStack((IItemProvider)Items.field_151055_y)));
            }
            if (((Boolean)ConfigManager.SERVER.enableArmorScraping.get()).booleanValue()) {
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151021_T), (Object)new ItemStack((IItemProvider)Items.field_151116_aA, 2), (Object)new ItemStack((IItemProvider)Items.field_151116_aA)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151024_Q), (Object)new ItemStack((IItemProvider)Items.field_151116_aA, 2), (Object)new ItemStack((IItemProvider)Items.field_151116_aA)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151027_R), (Object)new ItemStack((IItemProvider)Items.field_151116_aA, 2), (Object)new ItemStack((IItemProvider)Items.field_151116_aA)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151026_S), (Object)new ItemStack((IItemProvider)Items.field_151116_aA, 2), (Object)new ItemStack((IItemProvider)Items.field_151116_aA)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)SurvivalistItems.TANNED_BOOTS.get()), (Object)new ItemStack((IItemProvider)SurvivalistItems.TANNED_LEATHER.get(), 2), (Object)new ItemStack((IItemProvider)SurvivalistItems.TANNED_LEATHER.get())));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)SurvivalistItems.TANNED_HELMET.get()), (Object)new ItemStack((IItemProvider)SurvivalistItems.TANNED_LEATHER.get(), 2), (Object)new ItemStack((IItemProvider)SurvivalistItems.TANNED_LEATHER.get())));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)SurvivalistItems.TANNED_CHESTPLATE.get()), (Object)new ItemStack((IItemProvider)SurvivalistItems.TANNED_LEATHER.get(), 2), (Object)new ItemStack((IItemProvider)SurvivalistItems.TANNED_LEATHER.get())));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)SurvivalistItems.TANNED_LEGGINGS.get()), (Object)new ItemStack((IItemProvider)SurvivalistItems.TANNED_LEATHER.get(), 2), (Object)new ItemStack((IItemProvider)SurvivalistItems.TANNED_LEATHER.get())));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151029_X), (Object)new ItemStack((IItemProvider)SurvivalistItems.CHAINMAIL.get(), 2), (Object)new ItemStack((IItemProvider)SurvivalistItems.CHAINMAIL.get())));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151020_U), (Object)new ItemStack((IItemProvider)SurvivalistItems.CHAINMAIL.get(), 2), (Object)new ItemStack((IItemProvider)SurvivalistItems.CHAINMAIL.get())));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151023_V), (Object)new ItemStack((IItemProvider)SurvivalistItems.CHAINMAIL.get(), 2), (Object)new ItemStack((IItemProvider)SurvivalistItems.CHAINMAIL.get())));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151022_W), (Object)new ItemStack((IItemProvider)SurvivalistItems.CHAINMAIL.get(), 2), (Object)new ItemStack((IItemProvider)SurvivalistItems.CHAINMAIL.get())));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151167_ab), (Object)new ItemStack((IItemProvider)Items.field_151042_j, 2), (Object)new ItemStack((IItemProvider)Items.field_151042_j)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151028_Y), (Object)new ItemStack((IItemProvider)Items.field_151042_j, 2), (Object)new ItemStack((IItemProvider)Items.field_151042_j)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151030_Z), (Object)new ItemStack((IItemProvider)Items.field_151042_j, 2), (Object)new ItemStack((IItemProvider)Items.field_151042_j)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151165_aa), (Object)new ItemStack((IItemProvider)Items.field_151042_j, 2), (Object)new ItemStack((IItemProvider)Items.field_151042_j)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151151_aj), (Object)new ItemStack((IItemProvider)Items.field_151043_k, 2), (Object)new ItemStack((IItemProvider)Items.field_151043_k)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151169_ag), (Object)new ItemStack((IItemProvider)Items.field_151043_k, 2), (Object)new ItemStack((IItemProvider)Items.field_151043_k)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151171_ah), (Object)new ItemStack((IItemProvider)Items.field_151043_k, 2), (Object)new ItemStack((IItemProvider)Items.field_151043_k)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151149_ai), (Object)new ItemStack((IItemProvider)Items.field_151043_k, 2), (Object)new ItemStack((IItemProvider)Items.field_151043_k)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151175_af), (Object)new ItemStack((IItemProvider)Items.field_151045_i, 2), (Object)new ItemStack((IItemProvider)Items.field_151045_i)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151161_ac), (Object)new ItemStack((IItemProvider)Items.field_151045_i, 2), (Object)new ItemStack((IItemProvider)Items.field_151045_i)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151163_ad), (Object)new ItemStack((IItemProvider)Items.field_151045_i, 2), (Object)new ItemStack((IItemProvider)Items.field_151045_i)));
                this.scrapingRegistry.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)new ItemStack((IItemProvider)Items.field_151173_ae), (Object)new ItemStack((IItemProvider)Items.field_151045_i, 2), (Object)new ItemStack((IItemProvider)Items.field_151045_i)));
            }
        }

        private void onItemBroken(PlayerEntity player, ItemStack stack) {
            int scrappingLevel = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)SurvivalistMod.SCRAPING.get()), (ItemStack)stack);
            if (player.getClass().getName().equals("com.rwtema.extrautils2.fakeplayer.XUFakePlayer")) {
                return;
            }
            boolean fortune = this.rnd.nextDouble() > 0.9 / (double)(1 + scrappingLevel);
            ItemStack ret = null;
            for (Triple<ItemStack, ItemStack, ItemStack> scraping : this.scrapingRegistry) {
                ItemStack source = (ItemStack)scraping.getLeft();
                if (source.func_77973_b() != stack.func_77973_b()) continue;
                ItemStack good = (ItemStack)scraping.getMiddle();
                ItemStack bad = (ItemStack)scraping.getRight();
                ItemStack itemStack = ret = fortune ? good.func_77946_l() : bad.func_77946_l();
                break;
            }
            if (ret != null) {
                SurvivalistMod.LOGGER.debug("Item broke (" + stack + ") and the player got " + ret + " in return!");
                SurvivalistMod.channel.sendTo((Object)new ScrapingMessage(stack, ret), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)ret);
            }
        }

        @SubscribeEvent
        public void onPlayerDestroyItem(PlayerDestroyItemEvent ev) {
            if (!((Boolean)ConfigManager.SERVER.enableScraping.get()).booleanValue()) {
                return;
            }
            if (ev.getPlayer().field_70170_p.field_72995_K) {
                return;
            }
            ItemStack stack = ev.getOriginal();
            if (stack.func_190926_b()) {
                return;
            }
            Item item = stack.func_77973_b();
            if (!(item instanceof TieredItem)) {
                return;
            }
            this.onItemBroken(ev.getPlayer(), stack);
        }

        @SubscribeEvent
        public void onLivingHurt(LivingHurtEvent ev) {
            if (!((Boolean)ConfigManager.SERVER.enableScraping.get()).booleanValue()) {
                return;
            }
            if (ev.getEntity().field_70170_p.field_72995_K) {
                return;
            }
            if (ev.getEntity() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)ev.getEntityLiving();
                ItemBreakingTracker.get(player).ifPresent(ItemBreakingTracker::before);
            }
        }

        @SubscribeEvent
        public void entityJoinWorld(EntityJoinWorldEvent ev) {
            if (!((Boolean)ConfigManager.SERVER.enableScraping.get()).booleanValue()) {
                return;
            }
            if (ev.getEntity().field_70170_p.field_72995_K) {
                return;
            }
            if (ev.getEntity() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)ev.getEntity();
                CombatTrackerIntercept interceptTracker = new CombatTrackerIntercept(player);
                ObfuscationReflectionHelper.setPrivateValue(LivingEntity.class, (Object)player, (Object)((Object)interceptTracker), (String)"field_94063_bt");
            }
        }

        public void onTrackDamage(PlayerEntity player) {
            ItemBreakingTracker.get(player).ifPresent(tracker -> {
                Collection<ItemStack> missing = tracker.after();
                for (ItemStack broken : missing) {
                    this.onItemBroken(player, broken);
                }
            });
        }

        @SubscribeEvent
        public void attachCapabilities(AttachCapabilitiesEvent<Entity> e) {
            if (!((Boolean)ConfigManager.SERVER.enableScraping.get()).booleanValue()) {
                return;
            }
            final Entity entity = (Entity)e.getObject();
            if (!(entity instanceof ServerPlayerEntity)) {
                return;
            }
            if (entity.field_70170_p == null || entity.field_70170_p.field_72995_K) {
                return;
            }
            e.addCapability(PROP_KEY, new ICapabilityProvider(){
                ItemBreakingTracker cap = new ItemBreakingTracker();
                LazyOptional<ItemBreakingTracker> cap_provider = LazyOptional.of(() -> this.cap);
                {
                    this.cap.init(entity, entity.field_70170_p);
                }

                public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
                    if (capability == TRACKER) {
                        return this.cap_provider.cast();
                    }
                    return LazyOptional.empty();
                }
            });
        }
    }
}

