/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;

public class MultiVBORenderer
implements Closeable {
    private static final int BUFFER_SIZE = 0x200000;
    private final ImmutableMap<RenderType, VertexBuffer> buffers;
    private final ImmutableMap<RenderType, BufferBuilder.State> sortCaches;

    public static MultiVBORenderer of(Consumer<IRenderTypeBuffer> vertexProducer) {
        HashMap builders = Maps.newHashMap();
        vertexProducer.accept(rt -> builders.computeIfAbsent(rt, _rt -> {
            BufferBuilder builder = new BufferBuilder(0x200000);
            builder.func_181668_a(_rt.func_228664_q_(), _rt.func_228663_p_());
            return builder;
        }));
        ImmutableMap.Builder sortCaches = ImmutableMap.builder();
        ImmutableMap.Builder buffers = ImmutableMap.builder();
        builders.forEach((rt, builder) -> {
            Objects.requireNonNull(rt);
            Objects.requireNonNull(builder);
            builder.func_178977_d();
            sortCaches.put(rt, (Object)builder.func_181672_a());
            VertexFormat fmt = rt.func_228663_p_();
            VertexBuffer vbo = new VertexBuffer(fmt);
            vbo.func_227875_a_(builder);
            buffers.put(rt, (Object)vbo);
        });
        return new MultiVBORenderer((ImmutableMap<RenderType, VertexBuffer>)buffers.build(), (ImmutableMap<RenderType, BufferBuilder.State>)sortCaches.build());
    }

    protected MultiVBORenderer(ImmutableMap<RenderType, VertexBuffer> buffers, ImmutableMap<RenderType, BufferBuilder.State> sortCaches) {
        this.buffers = buffers;
        this.sortCaches = sortCaches;
    }

    public void sort(float x, float y, float z) {
        for (Map.Entry kv : this.sortCaches.entrySet()) {
            RenderType rt = (RenderType)kv.getKey();
            BufferBuilder.State state = (BufferBuilder.State)kv.getValue();
            BufferBuilder builder = new BufferBuilder(0x200000);
            builder.func_178993_a(state);
            builder.func_181674_a(x, y, z);
            VertexBuffer vbo = (VertexBuffer)this.buffers.get((Object)rt);
            vbo.func_227875_a_(builder);
        }
    }

    public void render(Matrix4f matrix) {
        this.buffers.entrySet().forEach(kv -> {
            RenderType rt = (RenderType)kv.getKey();
            VertexBuffer vbo = (VertexBuffer)kv.getValue();
            VertexFormat fmt = rt.func_228663_p_();
            rt.func_228547_a_();
            vbo.func_177359_a();
            fmt.func_227892_a_(0L);
            vbo.func_227874_a_(matrix, rt.func_228664_q_());
            VertexBuffer.func_177361_b();
            fmt.func_227895_d_();
            rt.func_228549_b_();
        });
    }

    @Override
    public void close() {
        this.buffers.values().forEach(VertexBuffer::close);
    }
}

