/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.util;

import java.io.FileInputStream;
import java.io.IOException;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.EndNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;

public class ReaderNBTLE {
    public static INBT parse(FileInputStream input) throws IOException {
        return ReaderNBTLE.readCompound(input).func_74781_a("");
    }

    private static INBT readSpecific(FileInputStream input, byte type) throws IOException {
        switch (type) {
            case 0: {
                return EndNBT.field_229686_b_;
            }
            case 1: {
                return ByteNBT.func_229671_a_((byte)ReaderNBTLE.readByte(input));
            }
            case 2: {
                return ShortNBT.func_229701_a_((short)ReaderNBTLE.readShort(input));
            }
            case 3: {
                return IntNBT.func_229692_a_((int)ReaderNBTLE.readInt(input));
            }
            case 4: {
                return LongNBT.func_229698_a_((long)ReaderNBTLE.readLong(input));
            }
            case 5: {
                return FloatNBT.func_229689_a_((float)Float.intBitsToFloat(ReaderNBTLE.readInt(input)));
            }
            case 6: {
                return DoubleNBT.func_229684_a_((double)Double.longBitsToDouble(ReaderNBTLE.readLong(input)));
            }
            case 8: {
                return StringNBT.func_229705_a_((String)ReaderNBTLE.readString(input));
            }
            case 9: {
                return ReaderNBTLE.readTagList(input);
            }
            case 10: {
                return ReaderNBTLE.readCompound(input);
            }
            case 7: {
                return ReaderNBTLE.readByteArray(input);
            }
            case 11: {
                return ReaderNBTLE.readIntArray(input);
            }
            case 12: {
                return ReaderNBTLE.readLongArray(input);
            }
        }
        throw new IllegalStateException("Unrecognized tag type: " + type);
    }

    private static LongArrayNBT readLongArray(FileInputStream input) throws IOException {
        int count = ReaderNBTLE.readInt(input);
        long[] longs = new long[count];
        for (int i = 0; i < count; ++i) {
            longs[i] = ReaderNBTLE.readInt(input);
        }
        return new LongArrayNBT(longs);
    }

    private static IntArrayNBT readIntArray(FileInputStream input) throws IOException {
        int count = ReaderNBTLE.readInt(input);
        int[] ints = new int[count];
        for (int i = 0; i < count; ++i) {
            ints[i] = ReaderNBTLE.readInt(input);
        }
        return new IntArrayNBT(ints);
    }

    private static ByteArrayNBT readByteArray(FileInputStream input) throws IOException {
        int count = ReaderNBTLE.readInt(input);
        byte[] bytes = new byte[count];
        for (int i = 0; i < count; ++i) {
            bytes[i] = ReaderNBTLE.readByte(input);
        }
        return new ByteArrayNBT(bytes);
    }

    private static CompoundNBT readCompound(FileInputStream input) throws IOException {
        int type;
        CompoundNBT tag = new CompoundNBT();
        while ((type = input.read()) > 0) {
            String key = ReaderNBTLE.readString(input);
            INBT child = ReaderNBTLE.readSpecific(input, (byte)type);
            tag.func_218657_a(key, child);
        }
        return tag;
    }

    private static ListNBT readTagList(FileInputStream input) throws IOException {
        byte type = ReaderNBTLE.readByte(input);
        int count = ReaderNBTLE.readInt(input);
        ListNBT list = new ListNBT();
        for (int i = 0; i < count; ++i) {
            list.add((Object)ReaderNBTLE.readSpecific(input, type));
        }
        return list;
    }

    private static String readString(FileInputStream input) throws IOException {
        int count = ReaderNBTLE.readShort(input);
        char[] chars = new char[count];
        for (int i = 0; i < count; ++i) {
            char c = (char)input.read();
            if (c >= '\u0080') {
                throw new UnsupportedOperationException("UTF codes > 127 not supported yet");
            }
            chars[i] = c;
        }
        return new String(chars);
    }

    private static long readLong(FileInputStream input) throws IOException {
        return (long)ReaderNBTLE.readInt(input) | (long)ReaderNBTLE.readInt(input) << 32;
    }

    private static int readInt(FileInputStream input) throws IOException {
        return input.read() | input.read() << 8 | input.read() << 16 | input.read() << 24;
    }

    private static short readShort(FileInputStream input) throws IOException {
        return (short)(input.read() | input.read() << 8);
    }

    private static byte readByte(FileInputStream input) throws IOException {
        return (byte)input.read();
    }
}

