/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gigaherz.survivalist.ConfigManager;
import gigaherz.survivalist.SurvivalistMod;
import it.unimi.dsi.fastutil.ints.IntList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ConfigToggledIngredientSerializer
implements IIngredientSerializer<Ingredient> {
    public static ResourceLocation NAME = SurvivalistMod.location("config_toggled_ingredient");
    public static ConfigToggledIngredientSerializer INSTANCE = new ConfigToggledIngredientSerializer();

    public Ingredient parse(PacketBuffer buffer) {
        return Ingredient.field_193370_a;
    }

    public Ingredient parse(JsonObject json) {
        String categoryName = JSONUtils.func_151200_h((JsonObject)json, (String)"category");
        String keyName = JSONUtils.func_151200_h((JsonObject)json, (String)"key");
        return new ConfigToggledIngredient(categoryName, keyName, CraftingHelper.getIngredient((JsonElement)json.getAsJsonObject("then")), CraftingHelper.getIngredient((JsonElement)json.getAsJsonObject("else")));
    }

    public void write(PacketBuffer buffer, Ingredient ingredient) {
    }

    public static class ConfigToggledIngredient
    extends Ingredient {
        private final String categoryName;
        private final String keyName;
        private final Ingredient then;
        private final Ingredient other;
        private static Method invalidateMethod = ObfuscationReflectionHelper.findMethod(Ingredient.class, (String)"invalidate", (Class[])new Class[0]);

        protected ConfigToggledIngredient(String categoryName, String keyName, Ingredient then, Ingredient other) {
            super(Stream.empty());
            this.categoryName = categoryName;
            this.keyName = keyName;
            this.then = then;
            this.other = other;
        }

        protected boolean getConfigValue() {
            return ConfigManager.getConfigBoolean(this.categoryName, this.keyName);
        }

        public ItemStack[] func_193365_a() {
            return this.getConfigValue() ? this.then.func_193365_a() : this.other.func_193365_a();
        }

        public boolean test(@Nullable ItemStack stack) {
            return this.getConfigValue() ? this.then.test(stack) : this.other.test(stack);
        }

        public IntList func_194139_b() {
            return this.getConfigValue() ? this.then.func_194139_b() : this.other.func_194139_b();
        }

        public boolean func_203189_d() {
            return this.getConfigValue() ? this.then.func_203189_d() : this.other.func_203189_d();
        }

        protected void invalidate() {
            try {
                invalidateMethod.invoke((Object)this.then, new Object[0]);
                invalidateMethod.invoke((Object)this.other, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean isSimple() {
            return this.getConfigValue() ? this.then.isSimple() : this.other.isSimple();
        }

        public IIngredientSerializer<? extends Ingredient> getSerializer() {
            return INSTANCE;
        }

        public JsonElement func_200304_c() {
            JsonObject obj = new JsonObject();
            obj.addProperty("type", NAME.toString());
            obj.addProperty("category", this.categoryName);
            obj.addProperty("key", this.keyName);
            obj.add("then", this.then.func_200304_c());
            obj.add("else", this.other.func_200304_c());
            return obj;
        }
    }
}

