/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist;

import gigaherz.survivalist.ConfigManager;
import gigaherz.survivalist.ConfigToggledIngredientSerializer;
import gigaherz.survivalist.ConfigurationCondition;
import gigaherz.survivalist.SurvivalistBlocks;
import gigaherz.survivalist.SurvivalistData;
import gigaherz.survivalist.SurvivalistItems;
import gigaherz.survivalist.SurvivalistRecipeBookCategories;
import gigaherz.survivalist.SurvivalistTileEntityTypes;
import gigaherz.survivalist.api.ChoppingRecipe;
import gigaherz.survivalist.api.DryingRecipe;
import gigaherz.survivalist.misc.StringEventHandling;
import gigaherz.survivalist.rack.DryingRackBakedModel;
import gigaherz.survivalist.rack.DryingRackContainer;
import gigaherz.survivalist.rack.DryingRackScreen;
import gigaherz.survivalist.rocks.RockEntity;
import gigaherz.survivalist.sawmill.gui.SawmillContainer;
import gigaherz.survivalist.sawmill.gui.SawmillScreen;
import gigaherz.survivalist.scraping.ItemBreakingTracker;
import gigaherz.survivalist.scraping.ScrapingEnchantment;
import gigaherz.survivalist.scraping.ScrapingMessage;
import gigaherz.survivalist.slime.SlimeMerger;
import gigaherz.survivalist.torchfire.TorchFireEventHandling;
import gigaherz.survivalist.util.AppendLootTable;
import gigaherz.survivalist.util.MatchBlockCondition;
import gigaherz.survivalist.util.RegSitter;
import gigaherz.survivalist.util.ReplaceDrops;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.conditions.LootConditionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
@Mod(value="survivalist")
public class SurvivalistMod {
    public static final String MODID = "survivalist";
    public static SurvivalistMod instance;
    public static Logger LOGGER;
    public static final ItemGroup SURVIVALIST_ITEMS;
    static final RegSitter HELPER;
    public static RegistryObject<SoundEvent> SOUND_SHLOP;
    public static RegistryObject<ScrapingEnchantment> SCRAPING;
    public static RegistryObject<EntityType<RockEntity>> THROWN_ROCK;
    public static final String CHANNEL = "main";
    private static final String PROTOCOL_VERSION = "1.0";
    public static SimpleChannel channel;

    public SurvivalistMod() {
        instance = this;
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        HELPER.subscribeEvents(modEventBus);
        SurvivalistBlocks.HELPER.subscribeEvents(modEventBus);
        SurvivalistItems.HELPER.subscribeEvents(modEventBus);
        SurvivalistTileEntityTypes.HELPER.subscribeEvents(modEventBus);
        modEventBus.addGenericListener(ContainerType.class, this::registerContainers);
        modEventBus.addGenericListener(IRecipeSerializer.class, this::registerRecipeSerializers);
        modEventBus.addGenericListener(GlobalLootModifierSerializer.class, this::lootModifiers);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::gatherData);
        modLoadingContext.registerConfig(ModConfig.Type.SERVER, ConfigManager.SERVER_SPEC);
    }

    public void gatherData(GatherDataEvent event) {
        SurvivalistData.gatherData(event);
    }

    private void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new ContainerType[]{SurvivalistMod.withName(new ContainerType(DryingRackContainer::new), "rack"), SurvivalistMod.withName(new ContainerType(SawmillContainer::new), "sawmill")});
    }

    private void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        CraftingHelper.register((IConditionSerializer)ConfigurationCondition.Serializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)ConfigToggledIngredientSerializer.NAME, (IIngredientSerializer)ConfigToggledIngredientSerializer.INSTANCE);
        event.getRegistry().registerAll((IForgeRegistryEntry[])new IRecipeSerializer[]{(IRecipeSerializer)new DryingRecipe.Serializer().setRegistryName("drying"), (IRecipeSerializer)new ChoppingRecipe.Serializer().setRegistryName("chopping")});
    }

    private void lootModifiers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        MatchBlockCondition.BLOCK_TAG_CONDITION = LootConditionManager.func_237475_a_((String)"survivalist:match_block", (ILootSerializer)new MatchBlockCondition.Serializer());
        event.getRegistry().registerAll((IForgeRegistryEntry[])new GlobalLootModifierSerializer[]{new AppendLootTable.Serializer().setRegistryName(SurvivalistMod.location("append_loot")), new ReplaceDrops.Serializer().setRegistryName(SurvivalistMod.location("replace_drops"))});
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        SurvivalistRecipeBookCategories.instance();
        TorchFireEventHandling.register();
        ItemBreakingTracker.register();
        StringEventHandling.register();
        SlimeMerger.register();
        LOGGER.info("Registering network channel...");
        int messageNumber = 0;
        channel.registerMessage(messageNumber++, ScrapingMessage.class, ScrapingMessage::encode, ScrapingMessage::new, ScrapingMessage::handle);
        LOGGER.debug("Final message number: " + messageNumber);
    }

    public void clientSetup(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(DryingRackContainer.TYPE, DryingRackScreen::new);
        ScreenManager.func_216911_a(SawmillContainer.TYPE, SawmillScreen::new);
        ModelLoaderRegistry.registerLoader((ResourceLocation)SurvivalistMod.location("rack"), (IModelLoader)DryingRackBakedModel.ModelLoader.INSTANCE);
    }

    private static <R extends T, T extends IForgeRegistryEntry<T>> R withName(R obj, ResourceLocation name) {
        obj.setRegistryName(name);
        return obj;
    }

    private static <R extends T, T extends IForgeRegistryEntry<T>> R withName(R obj, String name) {
        return SurvivalistMod.withName(obj, new ResourceLocation(MODID, name));
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MODID, path);
    }

    static {
        LOGGER = LogManager.getLogger((String)MODID);
        SURVIVALIST_ITEMS = new ItemGroup("survivalist_items"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)SurvivalistItems.PICK.get());
            }
        };
        HELPER = new RegSitter(MODID);
        SOUND_SHLOP = HELPER.soundEvent("shlop", () -> new SoundEvent(SurvivalistMod.location("mob.slime.merge"))).defer();
        SCRAPING = HELPER.enchantment("scraping", ScrapingEnchantment::new).defer();
        THROWN_ROCK = HELPER.entityType("thrown_rock", RockEntity::new, EntityClassification.MISC).size(0.5f, 0.5f).immuneToFire().setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).setCustomClientFactory((packet, world) -> new RockEntity((World)world)).defer();
        channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MODID, CHANNEL)).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    }
}

