/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.integration;

import gigaherz.survivalist.SurvivalistBlocks;
import gigaherz.survivalist.SurvivalistMod;
import gigaherz.survivalist.api.ChoppingRecipe;
import gigaherz.survivalist.api.DryingRecipe;
import gigaherz.survivalist.chopblock.ChopblockMaterials;
import gigaherz.survivalist.integration.ChoppingCategory;
import gigaherz.survivalist.integration.DryingCategory;
import java.util.Objects;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = SurvivalistMod.location("jei_plugin");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        Stream.of(ChopblockMaterials.values()).forEach(v -> registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)v.getPristine().get()), new ResourceLocation[]{ChoppingCategory.UID}));
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)SurvivalistBlocks.SAWMILL.get()), new ResourceLocation[]{ChoppingCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)SurvivalistBlocks.RACK.get()), new ResourceLocation[]{DryingCategory.UID});
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new DryingCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new ChoppingCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientWorld world = Objects.requireNonNull(Minecraft.func_71410_x().field_71441_e);
        registration.addRecipes(DryingRecipe.getAllRecipes((World)world), DryingCategory.UID);
        registration.addRecipes(ChoppingRecipe.getAllRecipes((World)world), ChoppingCategory.UID);
    }
}

