/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.rack;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import gigaherz.survivalist.rack.DryingRackItemsStateData;
import gigaherz.survivalist.rack.DryingRackTileEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.QuadTransformer;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import org.apache.commons.lang3.tuple.Pair;

public class DryingRackBakedModel
implements IDynamicBakedModel {
    private final TextureAtlasSprite particle;
    private final IBakedModel rackBakedModel;
    private final TransformationMatrix[] itemTransforms;
    private final List<Map<Pair<IBakedModel, TransformationMatrix>, List<BakedQuad>>> caches = Lists.newArrayList((Object[])new Map[]{Maps.newHashMap(), Maps.newHashMap(), Maps.newHashMap(), Maps.newHashMap()});
    private final ItemOverrideList overrides;
    private final boolean isSideLit;
    private static final Direction[] faces = (Direction[])Streams.concat((Stream[])new Stream[]{Arrays.stream(Direction.values()), Stream.of((Direction)null)}).toArray(Direction[]::new);

    public DryingRackBakedModel(ModelBakery bakery, IUnbakedModel original, Function<ResourceLocation, IUnbakedModel> modelGetter, Function<RenderMaterial, TextureAtlasSprite> textureGetter, TextureAtlasSprite particle, IBakedModel rackBakedModel, TransformationMatrix[] itemTransforms, boolean isSideLit) {
        this.particle = particle;
        this.rackBakedModel = rackBakedModel;
        this.itemTransforms = itemTransforms;
        this.isSideLit = isSideLit;
        this.overrides = new ItemOverrideList(bakery, original, modelGetter, textureGetter, Collections.emptyList());
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        ArrayList quads = Lists.newArrayList();
        RenderType renderLayer = MinecraftForgeClient.getRenderLayer();
        if (renderLayer == RenderType.func_228639_c_()) {
            quads.addAll(this.rackBakedModel.func_200117_a(state, side, rand));
        } else if (renderLayer == RenderType.func_228643_e_() && side == null) {
            ItemRenderer renderItem = Minecraft.func_71410_x().func_175599_af();
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            DryingRackItemsStateData items = (DryingRackItemsStateData)extraData.getData(DryingRackTileEntity.CONTAINED_ITEMS_DATA);
            for (int i = 0; i < 4; ++i) {
                Matrix4f positionTransform;
                TransformationMatrix transformMatrix;
                Pair pair;
                ItemStack stack = items.stacks[i];
                if (stack.func_190926_b()) continue;
                MatrixStack matrixStack = new MatrixStack();
                matrixStack.func_227860_a_();
                TransformationMatrix ct = this.itemTransforms[i];
                matrixStack.func_227866_c_().func_227870_a_().func_226595_a_(ct.func_227988_c_());
                matrixStack.func_227866_c_().func_227872_b_().func_226118_b_(ct.getNormalMatrix());
                IBakedModel model = renderItem.func_184393_a(stack, (World)world, null);
                if (stack.func_77973_b() == Items.field_203184_eO) {
                    model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174953_a(new ModelResourceLocation("minecraft:trident#inventory"));
                }
                if ((model = model.handlePerspective(ItemCameraTransforms.TransformType.FIXED, matrixStack)).func_188618_c()) continue;
                Map<Pair<IBakedModel, TransformationMatrix>, List<BakedQuad>> cache = this.caches.get(i);
                ArrayList cachedQuads = cache.get(pair = Pair.of((Object)model, (Object)(transformMatrix = new TransformationMatrix(positionTransform = matrixStack.func_227866_c_().func_227870_a_()))));
                if (cachedQuads == null) {
                    cachedQuads = Lists.newArrayList();
                    for (Direction face : faces) {
                        List inQuads = model.func_200117_a(null, face, rand);
                        List outQuads = new QuadTransformer(transformMatrix).processMany(inQuads);
                        cachedQuads.addAll(outQuads);
                    }
                    cache.put((Pair<IBakedModel, TransformationMatrix>)pair, cachedQuads);
                }
                quads.addAll(cachedQuads);
            }
        }
        return quads;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_230044_c_() {
        return this.isSideLit;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particle;
    }

    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    public static class ModelLoader
    implements IModelLoader<Geometry> {
        public static final ModelLoader INSTANCE = new ModelLoader();

        protected ModelLoader() {
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public Geometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            BlockModel baseModel = null;
            if (modelContents.has("base_model")) {
                baseModel = (BlockModel)deserializationContext.deserialize((JsonElement)JSONUtils.func_152754_s((JsonObject)modelContents, (String)"base_model"), BlockModel.class);
            }
            TransformationMatrix[] transformations = new TransformationMatrix[4];
            for (int i = 0; i < 4; ++i) {
                String key = "transform_" + i;
                if (!modelContents.has(key)) continue;
                transformations[i] = (TransformationMatrix)deserializationContext.deserialize(modelContents.get(key), TransformationMatrix.class);
            }
            return new Geometry(baseModel, transformations);
        }
    }

    public static class Geometry
    implements IModelGeometry<Geometry> {
        private final TransformationMatrix[] transformations;
        @Nullable
        private BlockModel baseModel;

        public Geometry(@Nullable BlockModel baseModel, TransformationMatrix[] matrices) {
            this.baseModel = baseModel;
            this.transformations = matrices;
        }

        public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<com.mojang.datafixers.util.Pair<String, String>> missingTextureErrors) {
            ArrayList<RenderMaterial> list = new ArrayList<RenderMaterial>();
            if (this.baseModel != null) {
                list.addAll(this.baseModel.func_225614_a_(modelGetter, missingTextureErrors));
            }
            return list;
        }

        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform sprite, ItemOverrideList overrides, ResourceLocation modelLocation) {
            TextureAtlasSprite particleSprite = spriteGetter.apply(owner.resolveTexture("particle"));
            TransformationMatrix[] transformations = Arrays.copyOf(this.transformations, 4);
            IBakedModel rackBakedModel = null;
            if (this.baseModel != null) {
                TransformationMatrix baseTransform = sprite.func_225615_b_();
                rackBakedModel = this.baseModel.func_225613_a_(bakery, spriteGetter, (IModelTransform)new SimpleModelTransform(baseTransform), modelLocation);
                if (!baseTransform.isIdentity()) {
                    baseTransform = baseTransform.blockCenterToCorner();
                    transformations[0] = baseTransform.compose(transformations[0]);
                    transformations[1] = baseTransform.compose(transformations[1]);
                    transformations[2] = baseTransform.compose(transformations[2]);
                    transformations[3] = baseTransform.compose(transformations[3]);
                }
            }
            return new DryingRackBakedModel(bakery, owner.getOwnerModel(), arg_0 -> ((ModelBakery)bakery).func_209597_a(arg_0), spriteGetter, particleSprite, rackBakedModel, transformations, owner.isSideLit());
        }
    }
}

