/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.rack;

import gigaherz.survivalist.SurvivalistTileEntityTypes;
import gigaherz.survivalist.api.DryingRecipe;
import gigaherz.survivalist.api.ItemHandlerWrapper;
import gigaherz.survivalist.rack.DryingRackContainer;
import gigaherz.survivalist.rack.DryingRackItemsStateData;
import gigaherz.survivalist.util.IntArrayWrapper;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class DryingRackTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public static final RegistryObject<TileEntityType<DryingRackTileEntity>> TYPE = SurvivalistTileEntityTypes.DRYING_RACK_TILE_ENTITY_TYPE;
    public static final ModelProperty<DryingRackItemsStateData> CONTAINED_ITEMS_DATA = new ModelProperty();
    private final ModelDataMap data = new ModelDataMap.Builder().withProperty(CONTAINED_ITEMS_DATA).build();
    private int[] dryTimeRemaining = new int[4];
    private final IIntArray dryTimeArray = new IntArrayWrapper(this.dryTimeRemaining);
    private final ItemStackHandler items = new ItemStackHandler(4){

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            DryingRackTileEntity.this.func_70296_d();
            BlockState state = DryingRackTileEntity.this.func_195044_w();
            DryingRackTileEntity.this.field_145850_b.func_184138_a(DryingRackTileEntity.this.field_174879_c, state, state, 3);
            DryingRackTileEntity.this.requestModelDataUpdate();
        }
    };
    private final LazyOptional<IItemHandler> itemsProvider = LazyOptional.of(() -> this.items);
    private final NonNullList<ItemStack> oldItems = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private final ItemHandlerWrapper[] dryingSlots = new ItemHandlerWrapper[]{new ItemHandlerWrapper((IItemHandlerModifiable)new RangedWrapper((IItemHandlerModifiable)this.items, 0, 1), () -> Vector3d.func_237489_a_((Vector3i)this.field_174879_c), 64), new ItemHandlerWrapper((IItemHandlerModifiable)new RangedWrapper((IItemHandlerModifiable)this.items, 1, 2), () -> Vector3d.func_237489_a_((Vector3i)this.field_174879_c), 64), new ItemHandlerWrapper((IItemHandlerModifiable)new RangedWrapper((IItemHandlerModifiable)this.items, 2, 3), () -> Vector3d.func_237489_a_((Vector3i)this.field_174879_c), 64), new ItemHandlerWrapper((IItemHandlerModifiable)new RangedWrapper((IItemHandlerModifiable)this.items, 3, 4), () -> Vector3d.func_237489_a_((Vector3i)this.field_174879_c), 64)};

    public DryingRackTileEntity() {
        super((TileEntityType)TYPE.get());
    }

    @Nonnull
    public IModelData getModelData() {
        this.data.setData(CONTAINED_ITEMS_DATA, (Object)new DryingRackItemsStateData(this.getItems()));
        return this.data;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT compound = super.func_189517_E_();
        compound.func_218657_a("Items", (INBT)this.items.serializeNBT());
        return compound;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.items.deserializeNBT(tag.func_74775_l("Items"));
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.handleUpdateTag(this.func_195044_w(), packet.func_148857_g());
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = this.items.getStackInSlot(i);
            if (ItemStack.func_77989_b((ItemStack)stack, (ItemStack)((ItemStack)this.oldItems.get(i)))) {
                if (this.dryTimeRemaining[i] <= 0) continue;
                Optional<DryingRecipe> recipe = DryingRecipe.getRecipe(this.field_145850_b, this.dryingSlots[i]);
                if (recipe.isPresent()) {
                    int n = i;
                    this.dryTimeRemaining[n] = this.dryTimeRemaining[n] - 1;
                    if (this.dryTimeRemaining[n] > 0) continue;
                    ItemStack result = recipe.get().getCraftingResult(this.dryingSlots[i]);
                    this.items.setStackInSlot(i, result);
                    continue;
                }
                this.dryTimeRemaining[i] = 0;
                continue;
            }
            this.oldItems.set(i, (Object)stack);
            this.dryTimeRemaining[i] = DryingRecipe.getDryingTime(this.field_145850_b, this.dryingSlots[i]);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemsProvider.cast();
        }
        return super.getCapability(capability, facing);
    }

    public boolean isUseableByPlayer(PlayerEntity player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        compound.func_218657_a("Items", (INBT)this.items.serializeNBT());
        compound.func_74783_a("RemainingTime", this.dryTimeRemaining);
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.items.deserializeNBT(compound.func_74775_l("Items"));
        this.dryTimeRemaining = Arrays.copyOf(compound.func_74759_k("RemainingTime"), 4);
    }

    public IItemHandler inventory() {
        return this.items;
    }

    public IIntArray progress() {
        return this.dryTimeArray;
    }

    public ItemStack[] getItems() {
        return new ItemStack[]{this.items.getStackInSlot(0), this.items.getStackInSlot(1), this.items.getStackInSlot(2), this.items.getStackInSlot(3)};
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("text.survivalist.rack.inventory");
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        return new DryingRackContainer(windowId, this, playerInventory);
    }
}

