/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.sawmill;

import gigaherz.survivalist.sawmill.SawmillTileEntity;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class SawmillBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public SawmillBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, POWERED});
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)POWERED) != false ? 15 : 0;
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((Property)POWERED)).booleanValue()) {
            Direction enumfacing = (Direction)stateIn.func_177229_b((Property)FACING);
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double z = (double)pos.func_177952_p() + 0.5;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            if (rand.nextDouble() < 0.1) {
                worldIn.func_184134_a(x, y, z, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            switch (enumfacing) {
                case WEST: {
                    z += d4;
                    x -= 0.52;
                    break;
                }
                case EAST: {
                    z += d4;
                    x += 0.52;
                    break;
                }
                case NORTH: {
                    x += d4;
                    z -= 0.52;
                    break;
                }
                case SOUTH: {
                    x += d4;
                    z += 0.52;
                }
            }
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x, y, z, 0.0, 0.0, 0.0);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof INamedContainerProvider)) {
            return ActionResultType.FAIL;
        }
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tileEntity));
        return ActionResultType.SUCCESS;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SawmillTileEntity();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof SawmillTileEntity) {
                SawmillBlock.dropInventoryItems(worldIn, pos, (IItemHandler)((SawmillTileEntity)te).getInventory());
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    private static void dropInventoryItems(World worldIn, BlockPos pos, IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack.func_190916_E() <= 0) continue;
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemstack);
        }
    }

    @Deprecated
    public boolean func_149740_M(BlockState state) {
        return true;
    }

    @Deprecated
    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof SawmillTileEntity) {
            return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)((SawmillTileEntity)te).getInventory());
        }
        return 0;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)).func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }
}

