/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.util;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class MatchBlockCondition
implements ILootCondition {
    public static LootConditionType BLOCK_TAG_CONDITION;
    @Nullable
    final List<Block> blockList;
    @Nullable
    final ITag.INamedTag<Block> blockTag;

    public MatchBlockCondition(@Nullable List<Block> blockList, @Nullable ITag.INamedTag<Block> blockTag) {
        this.blockList = blockList;
        this.blockTag = blockTag;
    }

    public boolean test(LootContext lootContext) {
        BlockState state = (BlockState)lootContext.func_216031_c(LootParameters.field_216287_g);
        if (state == null) {
            return false;
        }
        if (this.blockTag != null) {
            return this.blockTag.func_230235_a_((Object)state.func_177230_c());
        }
        if (this.blockList != null) {
            return this.blockList.contains(state.func_177230_c());
        }
        return false;
    }

    public LootConditionType func_230419_b_() {
        return BLOCK_TAG_CONDITION;
    }

    public static class Serializer
    implements ILootSerializer<MatchBlockCondition> {
        public void func_230424_a_(JsonObject json, MatchBlockCondition value, JsonSerializationContext context) {
            json.addProperty("tag", value.blockTag.func_230234_a_().toString());
        }

        public MatchBlockCondition func_230423_a_(JsonObject json, JsonDeserializationContext context) {
            if (json.has("tag")) {
                ResourceLocation tagName = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"tag"));
                return new MatchBlockCondition(null, (ITag.INamedTag<Block>)BlockTags.func_199894_a((String)tagName.toString()));
            }
            if (json.has("blocks")) {
                ArrayList blockNames = Lists.newArrayList();
                for (JsonElement e : JSONUtils.func_151214_t((JsonObject)json, (String)"blocks")) {
                    ResourceLocation blockName = new ResourceLocation(e.getAsString());
                    blockNames.add(ForgeRegistries.BLOCKS.getValue(blockName));
                }
                return new MatchBlockCondition(blockNames, null);
            }
            if (json.has("block")) {
                ResourceLocation blockName = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"block"));
                return new MatchBlockCondition(Collections.singletonList(ForgeRegistries.BLOCKS.getValue(blockName)), null);
            }
            throw new RuntimeException("match_block must have one of 'tag', 'block' or 'blocks' key");
        }
    }
}

