/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.util;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class ReplaceDrops
extends LootModifier {
    private final List<Replacement> replacements;

    public ReplaceDrops(ILootCondition[] lootConditions, List<Replacement> replacements) {
        super(lootConditions);
        this.replacements = replacements;
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Random rnd = context.func_216032_b();
        ArrayList outputs = Lists.newArrayList();
        for (ItemStack input : generatedLoot) {
            boolean replaced = false;
            for (Replacement r : this.replacements) {
                if (!r.input.test(input)) continue;
                for (Result out : r.outputs) {
                    ItemStack output = out.stack.func_77946_l();
                    int count = out.max > out.min ? rnd.nextInt(out.max - out.min) + out.min : out.min;
                    output.func_190920_e(count);
                    if (output.func_190916_E() <= 0) continue;
                    outputs.add(output);
                }
                replaced = true;
                break;
            }
            if (replaced) continue;
            outputs.add(input);
        }
        return outputs;
    }

    private static class Result {
        int min;
        int max;
        ItemStack stack;

        public Result(int min, int max, ItemStack stack) {
            this.min = min;
            this.max = max;
            this.stack = stack;
        }
    }

    private static class Replacement {
        final Ingredient input;
        final List<Result> outputs;

        private Replacement(Ingredient input, List<Result> outputs) {
            this.input = input;
            this.outputs = outputs;
        }
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<ReplaceDrops> {
        public ReplaceDrops read(ResourceLocation location, JsonObject json, ILootCondition[] conditions) {
            ArrayList replacements = Lists.newArrayList();
            for (JsonElement e : JSONUtils.func_151214_t((JsonObject)json, (String)"replacements")) {
                JsonObject repl = e.getAsJsonObject();
                if (!repl.has("from")) {
                    throw new JsonSyntaxException("Replacement must have a 'from' ingredient.");
                }
                if (!repl.has("to")) {
                    throw new JsonSyntaxException("Replacement must have a 'to' element, either object or array.");
                }
                Ingredient input = CraftingHelper.getIngredient((JsonElement)repl.get("from"));
                ArrayList results = Lists.newArrayList();
                JsonElement to = repl.get("to");
                if (to.isJsonObject()) {
                    results.add(this.parseResult(to.getAsJsonObject()));
                } else {
                    for (JsonElement ee : to.getAsJsonArray()) {
                        results.add(this.parseResult(ee.getAsJsonObject()));
                    }
                }
                replacements.add(new Replacement(input, results));
            }
            return new ReplaceDrops(conditions, replacements);
        }

        private Result parseResult(JsonObject obj) {
            int min = 1;
            int max = 1;
            ItemStack output = CraftingHelper.getItemStack((JsonObject)obj, (boolean)true);
            if (obj.has("quantity")) {
                JsonElement q = obj.get("quantity");
                if (q.isJsonObject()) {
                    JsonObject qq = q.getAsJsonObject();
                    min = JSONUtils.func_151208_a((JsonObject)qq, (String)"min", (int)0);
                    max = JSONUtils.func_151208_a((JsonObject)qq, (String)"max", (int)min);
                } else if (q.isJsonPrimitive()) {
                    min = max = q.getAsInt();
                } else {
                    throw new JsonSyntaxException("If 'quantity' isp resent, it must be either an integer or an object");
                }
            }
            return new Result(min, max, output);
        }
    }
}

