/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.client;

import gigaherz.survivalist.ISidedProxy;
import gigaherz.survivalist.Survivalist;
import gigaherz.survivalist.rocks.EntityRock;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ClientProxy
implements ISidedProxy {
    @Override
    public void preInit() {
        OBJLoader.instance.addDomain("survivalist");
        this.registerModels();
        RenderingRegistry.registerEntityRenderingHandler(EntityRock.class, (IRenderFactory)new IRenderFactory<EntityRock>(){

            public Render<? super EntityRock> createRenderFor(RenderManager manager) {
                return new RenderSnowball(manager, Survivalist.rock, Minecraft.func_71410_x().func_175599_af());
            }
        });
    }

    public void registerModels() {
        if (Survivalist.iron_nugget != null) {
            this.registerItemModel(Survivalist.iron_nugget, "iron_nugget");
        }
        if (Survivalist.chainmail != null) {
            this.registerItemModel(Survivalist.chainmail, "chainmail");
        }
        if (Survivalist.tanned_leather != null) {
            this.registerItemModel(Survivalist.tanned_leather, "tanned_leather");
        }
        if (Survivalist.jerky != null) {
            this.registerItemModel(Survivalist.jerky, "jerky");
        }
        if (Survivalist.tanned_helmet != null) {
            this.registerItemModel(Survivalist.tanned_helmet, 0, "tanned_armor", "part=helmet");
        }
        if (Survivalist.tanned_chestplate != null) {
            this.registerItemModel(Survivalist.tanned_chestplate, 0, "tanned_armor", "part=chestplate");
        }
        if (Survivalist.tanned_leggings != null) {
            this.registerItemModel(Survivalist.tanned_leggings, 0, "tanned_armor", "part=leggings");
        }
        if (Survivalist.tanned_boots != null) {
            this.registerItemModel(Survivalist.tanned_boots, 0, "tanned_armor", "part=boots");
        }
        if (Survivalist.rock_normal != null) {
            this.registerItemModel(Survivalist.rock_normal, "rock", "rock=normal");
        }
        if (Survivalist.rock_andesite != null) {
            this.registerItemModel(Survivalist.rock_andesite, "rock", "rock=andesite");
        }
        if (Survivalist.rock_diorite != null) {
            this.registerItemModel(Survivalist.rock_diorite, "rock", "rock=diorite");
        }
        if (Survivalist.rock_granite != null) {
            this.registerItemModel(Survivalist.rock_granite, "rock", "rock=granite");
        }
        if (Survivalist.iron_ore_rock != null) {
            this.registerItemModel(Survivalist.iron_ore_rock, "rock_ore", "ore=iron");
        }
        if (Survivalist.gold_ore_rock != null) {
            this.registerItemModel(Survivalist.gold_ore_rock, "rock_ore", "ore=gold");
        }
        if (Survivalist.rack != null) {
            this.registerBlockModelAsItem(Survivalist.rack, "rack");
        }
        if (Survivalist.dough != null) {
            this.registerItemModel(Survivalist.dough, "dough");
        }
        if (Survivalist.round_bread != null) {
            this.registerItemModel(Survivalist.round_bread, "round_bread");
        }
    }

    public void registerBlockModelAsItem(Block block, String blockName) {
        this.registerBlockModelAsItem(block, 0, blockName);
    }

    public void registerBlockModelAsItem(Block block, String blockName, String variantName) {
        this.registerBlockModelAsItem(block, 0, blockName, variantName);
    }

    public void registerBlockModelAsItem(Block block, int meta, String blockName) {
        this.registerBlockModelAsItem(block, meta, blockName, "inventory");
    }

    public void registerBlockModelAsItem(Block block, int meta, String blockName, String variantName) {
        this.registerItemModel(Item.func_150898_a((Block)block), meta, blockName, variantName);
    }

    public void registerItemModel(ItemStack stack, String itemName, String variantName) {
        this.registerItemModel(stack.func_77973_b(), stack.func_77960_j(), itemName, variantName);
    }

    public void registerItemModel(Item item, String itemName) {
        this.registerItemModel(item, 0, itemName, "inventory");
    }

    public void registerItemModel(Item item, int meta, String itemName, String variantName) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("survivalist:" + itemName, variantName));
    }
}

